/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.remoteapi;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.Base64;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import net.wouterdanes.docker.remoteapi.exception.DockerException;
import net.wouterdanes.docker.remoteapi.exception.ImageNotFoundException;
import net.wouterdanes.docker.remoteapi.model.Credentials;
import net.wouterdanes.docker.remoteapi.util.HttpsHelper;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public abstract class BaseService {
    public static final String REGISTRY_AUTH_HEADER = "X-Registry-Auth";
    private static final String REGISTRY_AUTH_NULL_VALUE = "null";
    private static final String TARGET_DOCKER_API_VERSION = "v1.21";
    private static final String ENV_DOCKER_TLS_VERIFY = "DOCKER_TLS_VERIFY";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final WebTarget serviceEndPoint;
    private Credentials credentials = null;

    public BaseService(String dockerApiRoot, String endPointPath) {
        this.objectMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        DeserializationConfig deserializationConfig = this.objectMapper.getDeserializationConfig().without(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
        this.objectMapper.setDeserializationConfig(deserializationConfig);
        this.serviceEndPoint = BaseService.createDockerTarget(dockerApiRoot).path(TARGET_DOCKER_API_VERSION).path(endPointPath);
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    protected WebTarget getServiceEndPoint() {
        return this.serviceEndPoint;
    }

    protected String getRegistryAuthHeaderValue() {
        if (this.credentials == null) {
            return REGISTRY_AUTH_NULL_VALUE;
        }
        return Base64.getEncoder().encodeToString(this.toJson(this.credentials).getBytes(Charset.forName("UTF-8")));
    }

    protected String toJson(Object obj) {
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to Jsonify", e);
        }
    }

    protected <T> T toObject(String json, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot convert Json", e);
        }
    }

    protected static void checkImageTargetingResponse(String id, Response.StatusType statusInfo) {
        if (statusInfo.getFamily() == Response.Status.Family.SUCCESSFUL) {
            return;
        }
        switch (statusInfo.getStatusCode()) {
            case 404: {
                throw new ImageNotFoundException(id);
            }
        }
        throw new DockerException(statusInfo.getReasonPhrase());
    }

    protected static DockerException makeImageTargetingException(String id, WebApplicationException cause) {
        Response.StatusType statusInfo = cause.getResponse().getStatusInfo();
        switch (statusInfo.getStatusCode()) {
            case 404: {
                return new ImageNotFoundException(id, (Throwable)cause);
            }
        }
        return new DockerException(statusInfo.getReasonPhrase(), (Throwable)cause);
    }

    private static WebTarget createDockerTarget(String dockerApiRoot) {
        KeyStore trustStore;
        KeyStore keyStore;
        String encrypted = System.getenv(ENV_DOCKER_TLS_VERIFY);
        if (!"1".equals(encrypted)) {
            return ClientBuilder.newClient().target("http://" + dockerApiRoot);
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        String certPath = System.getenv("DOCKER_CERT_PATH");
        if (certPath == null) {
            certPath = System.getProperty("USER_HOME") + File.separator + ".docker";
        }
        BaseService.ensureThatCertificatesExist(certPath);
        try {
            keyStore = HttpsHelper.createKeyStore(certPath);
            trustStore = HttpsHelper.createTrustStore(certPath);
        }
        catch (Exception e) {
            throw new DockerException("Can't load docker certificates", e);
        }
        return ClientBuilder.newBuilder().keyStore(keyStore, HttpsHelper.KEYSTORE_PWD).trustStore(trustStore).build().target("https://" + dockerApiRoot);
    }

    private static void ensureThatCertificatesExist(String certPath) {
        String[] files;
        for (String file : files = new String[]{"ca.pem", "cert.pem", "key.pem"}) {
            Path path = Paths.get(certPath, file);
            boolean exists = Files.exists(path, new LinkOption[0]);
            if (exists) continue;
            throw new DockerException(String.format("%s not found in cert path (%s), make sure that ca.pem, cert.pem and key.pem are available there.", file, certPath));
        }
    }
}

