/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.wouterdanes.docker.provider.RemoteApiBasedDockerProvider;
import net.wouterdanes.docker.provider.model.ContainerStartConfiguration;
import net.wouterdanes.docker.provider.model.ExposedPort;
import net.wouterdanes.docker.remoteapi.model.ContainerInspectionResult;
import net.wouterdanes.docker.remoteapi.model.ContainerStartRequest;

public class RemoteDockerProvider
extends RemoteApiBasedDockerProvider {
    @Override
    public ContainerInspectionResult startContainer(ContainerStartConfiguration configuration) {
        ContainerStartRequest startRequest = new ContainerStartRequest().withAllPortsPublished().withLinks(configuration.getLinks());
        return super.startContainer(configuration, startRequest);
    }

    @Override
    public List<ExposedPort> getExposedPorts(String containerId) {
        ContainerInspectionResult containerInspectionResult = this.getContainersService().inspectContainer(containerId);
        if (containerInspectionResult.getNetworkSettings().getPorts().isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, List<ContainerInspectionResult.NetworkSettings.PortMappingInfo>> ports = containerInspectionResult.getNetworkSettings().getPorts();
        ArrayList<ExposedPort> exposedPorts = new ArrayList<ExposedPort>();
        for (Map.Entry<String, List<ContainerInspectionResult.NetworkSettings.PortMappingInfo>> port : ports.entrySet()) {
            String exposedPort = port.getKey();
            int hostPort = port.getValue().get(0).getHostPort();
            exposedPorts.add(new ExposedPort(exposedPort, hostPort, this.getHost()));
        }
        return exposedPorts;
    }
}

