/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.provider;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.wouterdanes.docker.provider.DockerProvider;
import net.wouterdanes.docker.provider.LocalDockerProvider;
import net.wouterdanes.docker.provider.RemoteDockerProvider;

public class DockerProviderSupplier
implements Supplier<DockerProvider> {
    private final String providerName;
    private static volatile Map<String, Class<? extends DockerProvider>> providers = new HashMap<String, Class<? extends DockerProvider>>();

    public DockerProviderSupplier(String providerName) {
        this.providerName = providerName;
    }

    public static void registerProvider(String name, Class<? extends DockerProvider> providerClass) {
        assert (providerClass != null);
        providers.put(name, providerClass);
    }

    public static void removeProvider(String name) {
        assert (name != null);
        providers.remove(name);
    }

    @Override
    public DockerProvider get() {
        if (providers.containsKey(this.providerName)) {
            Class<? extends DockerProvider> providerClass = providers.get(this.providerName);
            try {
                return providerClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Can't instantiate provider", e);
            }
        }
        throw new IllegalStateException(String.format("No provider known by name '%s'", this.providerName));
    }

    static {
        providers.put("remote", RemoteDockerProvider.class);
        providers.put("local", LocalDockerProvider.class);
    }
}

