/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.maven;

import java.util.Iterator;
import net.wouterdanes.docker.maven.AbstractDockerMojo;
import net.wouterdanes.docker.provider.model.PushableImage;
import net.wouterdanes.docker.remoteapi.exception.DockerException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(defaultPhase=LifecyclePhase.DEPLOY, name="push-images", threadSafe=true, instantiationStrategy=InstantiationStrategy.PER_LOOKUP)
public class PushImageMojo
extends AbstractDockerMojo {
    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        this.ensureThatAllPushableImagesHaveAName();
        for (PushableImage image : this.getImagesToPush()) {
            this.getLog().info((CharSequence)String.format("Pushing image '%s' with tag '%s'", image.getImageId(), image.getNameAndTag().orElse("<Unspecified>")));
            try {
                this.getDockerProvider().pushImage(image.getNameAndTag().get());
            }
            catch (DockerException e) {
                String message = String.format("Cannot push image '%s' with tag '%s'", image.getImageId(), image.getNameAndTag().orElse("<Unspecified>"));
                this.handleDockerException(message, e);
            }
        }
    }

    private void ensureThatAllPushableImagesHaveAName() throws MojoFailureException {
        Iterator imagesWithoutNameAndTag = this.getImagesToPush().parallelStream().filter(image -> !image.getNameAndTag().isPresent()).iterator();
        if (imagesWithoutNameAndTag.hasNext()) {
            imagesWithoutNameAndTag.forEachRemaining(image -> {
                String message = String.format("Image '%s' needs to be pushed but doesn't have a name.", image.getImageId());
                this.getLog().error((CharSequence)message);
            });
            throw new MojoFailureException("There are images that need to be pushed without a name.");
        }
    }
}

