/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.maven;

import java.util.List;
import java.util.Optional;
import net.wouterdanes.docker.maven.AbstractPreVerifyDockerMojo;
import net.wouterdanes.docker.maven.DockerPluginError;
import net.wouterdanes.docker.maven.StartedContainerInfo;
import net.wouterdanes.docker.provider.model.ContainerCommitConfiguration;
import net.wouterdanes.docker.provider.model.ImageBuildConfiguration;
import net.wouterdanes.docker.remoteapi.exception.DockerException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="commit-containers", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST, threadSafe=true, instantiationStrategy=InstantiationStrategy.PER_LOOKUP)
public class CommitContainerMojo
extends AbstractPreVerifyDockerMojo {
    @Parameter(required=true)
    private List<ContainerCommitConfiguration> containers;

    public void setConfiguration(List<ContainerCommitConfiguration> containers) {
        this.containers = containers;
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.containers == null || this.containers.isEmpty()) {
            this.getLog().warn((CharSequence)"No containers specified.");
            return;
        }
        for (ContainerCommitConfiguration container : this.containers) {
            this.commitContainer(container);
        }
    }

    protected void commitContainer(ContainerCommitConfiguration container) throws MojoFailureException {
        this.getLog().info((CharSequence)String.format("Creating image for configuration '%s'", container));
        String containerId = container.getId();
        Optional<StartedContainerInfo> containerInfo = this.getInfoForContainerStartId(containerId);
        if (containerInfo.isPresent()) {
            try {
                String startedContainerId = containerInfo.get().getContainerInfo().getId();
                container.setId(startedContainerId);
                String imageId = this.getDockerProvider().commitContainer(container);
                this.getLog().info((CharSequence)String.format("Image '%s' created from container '%s'", imageId, container.getId()));
                ImageBuildConfiguration imageBuildConfiguration = new ImageBuildConfiguration();
                imageBuildConfiguration.setId(containerId);
                imageBuildConfiguration.setNameAndTag(container.getRepo() + ":" + container.getTag());
                imageBuildConfiguration.setPush(container.isPush());
                this.registerBuiltImage(imageId, imageBuildConfiguration);
            }
            catch (DockerException e) {
                String errorMessage = String.format("Image '%s:%s' could not be created from container '%s'", container.getRepo(), container.getTag(), container.getId());
                this.handleDockerException(errorMessage, e);
            }
        } else {
            String message = String.format("No container found for id '%s'", containerId);
            this.registerPluginError(new DockerPluginError("commit-containers", message));
            this.getLog().warn((CharSequence)message);
        }
    }

    @Override
    protected String getMojoGoalName() {
        return "commit-containers";
    }
}

