/*
 * Decompiled with CFR 0.152.
 */
package net.worktrail.appapi.model;

import java.util.Date;
import net.worktrail.appapi.model.Employee;
import net.worktrail.appapi.model.Privacy;
import net.worktrail.appapi.model.SrcType;
import org.json.JSONException;
import org.json.JSONObject;

public class HubEntry {
    private Employee employee;
    private Date time;
    private Date endTime;
    private SrcType srcType;
    private String summary;
    private String link;
    private String identifier;
    private Privacy privacy;

    public HubEntry(String identifier, Employee employee, Date time, Date endTime, SrcType srcType, String summary, String link) {
        this.identifier = identifier;
        this.employee = employee;
        this.time = time;
        this.endTime = endTime;
        this.srcType = srcType;
        this.summary = summary;
        this.link = link;
    }

    public HubEntry(String identifier, Employee employee, Date time, Date endTime, SrcType srcType, String summary, String link, Privacy privacy) {
        this(identifier, employee, time, endTime, srcType, summary, link);
        this.privacy = privacy;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public Date getTime() {
        return this.time;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public SrcType getSrcType() {
        return this.srcType;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getLink() {
        return this.link;
    }

    public Privacy getPrivacy() {
        return this.privacy;
    }

    public JSONObject toJSONObject() {
        try {
            JSONObject ret = new JSONObject();
            if (this.employee != null) {
                ret.put("employee_id", this.employee.getEmployeeId());
            }
            ret.put("time", this.time.getTime() / 1000L);
            if (this.endTime != null) {
                ret.put("endtime", this.endTime.getTime() / 1000L);
            }
            ret.put("srctype", (Object)this.srcType.getStringIdentifier());
            ret.put("summary", (Object)this.summary);
            ret.put("link", (Object)this.link);
            if (this.privacy != null) {
                ret.put("privacy", (Object)this.privacy.getStringIdentifier());
            }
            return ret;
        }
        catch (JSONException e) {
            throw new RuntimeException("Error while converting hub entry to json.", e);
        }
    }
}

