/*
 * Decompiled with CFR 0.152.
 */
package net.worktrail.appapi;

import at.tapo.worktrail.api.javaonly.WorkTrailConnectionUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.worktrail.appapi.EmployeeListResponse;
import net.worktrail.appapi.WorkTrailAccessType;
import net.worktrail.appapi.WorkTrailScope;
import net.worktrail.appapi.model.Company;
import net.worktrail.appapi.model.CompanyImpl;
import net.worktrail.appapi.model.EmployeeImpl;
import net.worktrail.appapi.model.HubEntry;
import net.worktrail.appapi.model.WorkEntry;
import net.worktrail.appapi.model.WorkEntryImpl;
import net.worktrail.appapi.response.CreateAuthResponse;
import net.worktrail.appapi.response.CreateHubEntriesResponse;
import net.worktrail.appapi.response.RequestErrorException;
import net.worktrail.appapi.response.WorkEntryListResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WorkTrailAppApi {
    private static Logger logger = Logger.getLogger(WorkTrailAppApi.class.getName());
    private String appKey;
    private String secretApiKey;
    private String authToken;
    public static final String WORKTRAIL_SERVER = "https://worktrail.net";
    private String workTrailServer = "https://worktrail.net";
    public Object setServerUrl;

    public WorkTrailAppApi(String appKey, String secretApiKey, String authToken) {
        this.appKey = appKey;
        this.secretApiKey = secretApiKey;
        this.authToken = authToken;
        this.workTrailServer = System.getProperty("net.worktrail.hub.server", WORKTRAIL_SERVER);
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public CreateAuthResponse createAuthRequest(WorkTrailAccessType accessType, WorkTrailScope[] scopes) throws RequestErrorException {
        Map<String, String> args = this.createAuthArgs(accessType, scopes);
        JSONObject ret = this.requestPage("rest/token/request/", args);
        try {
            return new CreateAuthResponse(ret.getString("requestkey"), ret.getString("authtoken"), new URL(ret.getString("redirecturl")));
        }
        catch (MalformedURLException | JSONException e) {
            throw new RequestErrorException("Error while sending auth request.", e);
        }
    }

    private Map<String, String> createAuthArgs(WorkTrailAccessType accessType, WorkTrailScope[] scopes) {
        StringBuilder builder = new StringBuilder();
        for (WorkTrailScope scope : scopes) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(scope.getStringIdentifier());
        }
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("scopes", builder.toString());
        args.put("accesstype", accessType.getStringIdentifier());
        return args;
    }

    public EmployeeListResponse fetchEmployees() throws RequestErrorException {
        JSONObject ret = this.requestPage("rest/employees/");
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Retrieved employees: " + ret.toString(4));
            }
            JSONArray array = ret.getJSONArray("list");
            ArrayList<EmployeeImpl> employeeList = new ArrayList<EmployeeImpl>();
            for (int i = 0; i < array.length(); ++i) {
                JSONObject employee = array.getJSONObject(i);
                EmployeeImpl e = new EmployeeImpl(employee.getLong("id"), employee.getString("first_name"), employee.getString("last_name"), employee.getString("name"), employee.getString("username"));
                employeeList.add(e);
            }
            return new EmployeeListResponse(employeeList);
        }
        catch (JSONException e) {
            throw new RequestErrorException("Error while fetching employee list.", e);
        }
    }

    public WorkEntryListResponse fetchWorkEntries(long lastModifyDate, long page) throws RequestErrorException {
        JSONObject ret = this.requestPage("rest/workentries/?after=" + lastModifyDate + "&page=" + page);
        try {
            JSONArray array = ret.getJSONArray("list");
            ArrayList<WorkEntry> workEntryList = new ArrayList<WorkEntry>();
            for (int i = 0; i < array.length(); ++i) {
                JSONObject workEntryObj = array.getJSONObject(i);
                try {
                    WorkEntryImpl workEntry = new WorkEntryImpl(workEntryObj.getLong("id"), workEntryObj.getString("description"), new Date(workEntryObj.getJSONObject("start").getLong("time") * 1000L), new Date(workEntryObj.getJSONObject("end").getLong("time") * 1000L), workEntryObj.getLong("taskid"), workEntryObj.getLong("employee"), workEntryObj.getLong("modifydate"));
                    workEntryList.add(workEntry);
                    continue;
                }
                catch (JSONException e) {
                    logger.log(Level.SEVERE, "catched in invalid json response for work entry. " + workEntryObj.toString(4), e);
                }
            }
            return new WorkEntryListResponse(ret.getLong("num_pages"), ret.getLong("page"), workEntryList);
        }
        catch (JSONException e) {
            throw new RequestErrorException("Error while fetching work entry list.", e);
        }
    }

    public CreateHubEntriesResponse createHubEntries(Collection<HubEntry> hubEntries) throws RequestErrorException {
        try {
            JSONArray create = new JSONArray();
            for (HubEntry hubEntry : hubEntries) {
                create.put((Object)hubEntry.toJSONObject());
            }
            JSONObject req = new JSONObject();
            req.put("create", (Object)create);
            JSONObject ret = this.requestPage("rest/hub/entries/create/", req);
            JSONArray created = ret.getJSONArray("created");
            ArrayList<Long> createdList = new ArrayList<Long>();
            for (int i = 0; i < created.length(); ++i) {
                createdList.add(created.getLong(i));
            }
            return new CreateHubEntriesResponse(createdList);
        }
        catch (JSONException e) {
            throw new RequestErrorException("Error while creating hub entries.", e);
        }
    }

    public void cleanHubEntries() throws RequestErrorException {
        this.requestPage("rest/hub/entries/clean/");
    }

    public boolean verifyAuthorization(String requestKey) throws RequestErrorException {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("requestkey", requestKey);
        JSONObject ret = this.requestPage("rest/token/confirm/", args);
        try {
            String status = ret.getString("status");
            if ("active".equals(status)) {
                return true;
            }
            if ("rejected".equals(status)) {
                throw new RequestErrorException("authorization was rejected.", null);
            }
            return false;
        }
        catch (JSONException e) {
            throw new RequestErrorException("Error while retrieving status.", e);
        }
    }

    private JSONObject requestPage(String path) throws RequestErrorException {
        return this.requestPage(path, (Map<String, String>)null);
    }

    private JSONObject requestPage(String path, JSONObject data) throws RequestErrorException {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("data", data.toString());
        return this.requestPage(path, args);
    }

    private JSONObject requestPage(String path, Map<String, String> args) throws RequestErrorException {
        try {
            String query;
            URL url;
            StringBuilder ret;
            JSONObject response;
            if (args == null) {
                args = new HashMap<String, String>();
            }
            args.put("appkey", this.appKey);
            args.put("secretapikey", this.secretApiKey);
            if (this.authToken != null) {
                args.put("authtoken", this.authToken);
            }
            if ((response = new JSONObject((ret = WorkTrailConnectionUtils.requestDataFromUrl(url = new URL(this.workTrailServer + "/" + path), (query = WorkTrailConnectionUtils.getQuery(args.entrySet())).getBytes("UTF-8"), "WorkTrail Hub")).toString())).has("error")) {
                logger.severe("Server returned error from request." + response.toString(4));
                throw new RequestErrorException("Server responded with an error message: " + response.getString("error"), null, response);
            }
            return response;
        }
        catch (IOException | JSONException e) {
            throw new RequestErrorException("Error when requesting page {" + path + "}", e);
        }
    }

    public void setServerUrl(String serverUrl) {
        this.workTrailServer = serverUrl;
    }

    public String generateTestUser(WorkTrailAccessType accessType, WorkTrailScope[] scopes) throws RequestErrorException {
        Map<String, String> args = this.createAuthArgs(accessType, scopes);
        JSONObject ret = this.requestPage("rest/token/generatetestuser/", args);
        try {
            String authToken;
            this.authToken = authToken = ret.getString("authtoken");
            return authToken;
        }
        catch (JSONException e) {
            try {
                logger.log(Level.SEVERE, "Error while generating test user: " + ret.toString(4));
            }
            catch (JSONException e1) {
                // empty catch block
            }
            throw new RequestErrorException("Error while generating test user.", e);
        }
    }

    public Company fetchCompany() throws RequestErrorException {
        JSONObject ret = this.requestPage("rest/company/");
        try {
            CompanyImpl company = new CompanyImpl(ret.getLong("id"), ret.getString("name"), ret.getString("slug"), ret.getLong("break_task_id"), ret.getLong("org_project_id"), ret.getLong("unassigned_project_id"));
            return company;
        }
        catch (JSONException e) {
            throw new RequestErrorException("Error while parsing response.", e);
        }
    }
}

