/*
 * Decompiled with CFR 0.152.
 */
package at.tapo.worktrail.api.javaonly;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WorkTrailConnectionUtils {
    private static Logger logger = Logger.getLogger(WorkTrailConnectionUtils.class.getName());

    public static StringBuilder requestDataFromUrl(URL url, byte[] tosend, String userAgent) throws IOException {
        int i;
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        if (userAgent != null) {
            urlConnection.setRequestProperty("User-Agent", userAgent);
        }
        urlConnection.setDoOutput(true);
        urlConnection.setDoInput(true);
        urlConnection.setConnectTimeout(5000);
        urlConnection.setReadTimeout(20000);
        urlConnection.setFixedLengthStreamingMode(tosend.length);
        BufferedOutputStream out = new BufferedOutputStream(urlConnection.getOutputStream());
        out.write(tosend);
        out.flush();
        out.close();
        InputStreamReader reader = new InputStreamReader(urlConnection.getInputStream());
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[2048];
        while ((i = reader.read(buf)) != -1) {
            sb.append(buf, 0, i);
        }
        return sb;
    }

    public static String getQuery(Collection<Map.Entry<String, String>> encoded) {
        try {
            StringBuilder result = new StringBuilder();
            boolean first = true;
            for (Map.Entry<String, String> pair : encoded) {
                if (first) {
                    first = false;
                } else {
                    result.append("&");
                }
                result.append(URLEncoder.encode(pair.getKey(), "UTF-8"));
                result.append("=");
                result.append(URLEncoder.encode(pair.getValue(), "UTF-8"));
            }
            return result.toString();
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.SEVERE, "This should not have happened.", e);
            return null;
        }
    }

    public static List<Map.Entry<String, String>> encodeMap(Set<Map.Entry<String, Object>> set) {
        ArrayList<Map.Entry<String, String>> pairs = new ArrayList<Map.Entry<String, String>>(set.size());
        for (Map.Entry<String, Object> entry : set) {
            Object value = entry.getValue();
            if (value == null) continue;
            String val = null;
            val = value instanceof Date ? Long.toString(((Date)value).getTime() / 100L) : value.toString();
            pairs.add(new AbstractMap.SimpleEntry<String, String>(entry.getKey(), val));
        }
        return pairs;
    }
}

