/*
 * Decompiled with CFR 0.152.
 */
package net.wisedream.ezhc;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.wisedream.ezhc.HttpClientFactory;
import net.wisedream.ezhc.bean.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;

public final class XmlHttpClientFactory
extends HttpClientFactory {
    private String xmlFilePath;

    public XmlHttpClientFactory(String xmlFilePath) {
        this.xmlFilePath = xmlFilePath;
    }

    @Override
    public CloseableHttpClient create() throws Exception {
        HttpClient hcBean = XmlHttpClientFactory.unmarshal(HttpClient.class, this.loadXmlFile(this.xmlFilePath));
        return this.create(hcBean);
    }

    private static <T> T unmarshal(Class<T> docClass, InputStream inputStream) throws JAXBException {
        String packageName = docClass.getPackage().getName();
        JAXBContext jc = JAXBContext.newInstance((String)packageName);
        Unmarshaller u = jc.createUnmarshaller();
        return (T)u.unmarshal(inputStream);
    }

    private InputStream loadXmlFile(String filePath) throws FileNotFoundException {
        if (filePath.startsWith("classpath:")) {
            InputStream in = this.getClass().getResourceAsStream(filePath.substring("classpath:".length(), filePath.length()).trim());
            if (in == null) {
                throw new FileNotFoundException(filePath + " not found");
            }
            return in;
        }
        return new FileInputStream(filePath);
    }
}

