/*
 * Decompiled with CFR 0.152.
 */
package net.wisedream.ezhc;

import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;

public class HttpRequestBuilder {
    private String url;
    private String method = "GET";
    private Map<String, String> headers = new HashMap<String, String>();
    private HttpEntity entity;
    private HttpHost proxy;

    public HttpRequestBuilder(String url) {
        this.url = url;
    }

    public static HttpRequestBuilder of(String url) {
        return new HttpRequestBuilder(url);
    }

    public static HttpRequestBuilder of(String uri, String charset, NameValuePair ... nvps) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(uri).setCharset(Charset.forName(charset));
        builder.addParameters(Arrays.asList(nvps));
        return HttpRequestBuilder.of(builder.build().toString());
    }

    public HttpRequestBuilder withMethod(String method) {
        this.method = method.toUpperCase();
        return this;
    }

    public HttpRequestBuilder withHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public HttpRequestBuilder withEntity(HttpEntity entity) {
        this.entity = entity;
        return this;
    }

    public HttpRequestBuilder withProxy(String host, int port) {
        this.proxy = new HttpHost(host, port);
        return this;
    }

    public HttpUriRequest build() {
        RequestBuilder builder = RequestBuilder.create((String)this.method).setUri(this.url);
        this.headers.forEach((k, v) -> builder.setHeader(k, v));
        if (this.entity != null) {
            builder.setEntity(this.entity);
        }
        if (this.proxy != null) {
            builder.setConfig(RequestConfig.custom().setProxy(this.proxy).build());
        }
        return builder.build();
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public HttpHost getProxy() {
        return this.proxy;
    }
}

