/*
 * Decompiled with CFR 0.152.
 */
package net.wisedream.ezhc;

import java.nio.charset.Charset;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class HttpEntities {
    public static HttpEntity urlEncodedFormEntity(List<? extends NameValuePair> params, Charset charset) {
        return new UrlEncodedFormEntity(params, charset);
    }

    public static HttpEntity urlEncodedFormEntity(String content, Charset charset) {
        return HttpEntities.stringEntity(content, ContentType.APPLICATION_FORM_URLENCODED.withCharset(charset));
    }

    public static HttpEntity textPlainEntity(String content, Charset charset) {
        return HttpEntities.stringEntity(content, ContentType.TEXT_PLAIN.withCharset(charset));
    }

    public static HttpEntity xmlEntity(String content, Charset charset) {
        return HttpEntities.stringEntity(content, ContentType.TEXT_XML.withCharset(charset));
    }

    public static HttpEntity jsonEntity(String content, Charset charset) {
        return HttpEntities.stringEntity(content, ContentType.APPLICATION_JSON.withCharset(charset));
    }

    public static HttpEntity octetStreamEntity(byte[] content) {
        return new ByteArrayEntity(content, ContentType.APPLICATION_OCTET_STREAM);
    }

    public static HttpEntity byteArrayEntity(byte[] content, ContentType contentType) {
        return new ByteArrayEntity(content, contentType);
    }

    public static HttpEntity stringEntity(String content, ContentType contentType) {
        return new StringEntity(content, contentType);
    }
}

