/*
 * Decompiled with CFR 0.152.
 */
package net.wisedream.ezhc;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpClientService {
    private CloseableHttpClient httpClient;
    private RequestCustomizer customizer;

    public HttpClientService(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpClientService(CloseableHttpClient httpClient, RequestCustomizer customizer) {
        this(httpClient);
        this.customizer = customizer;
    }

    public void dispose() throws IOException {
        this.httpClient.close();
    }

    public String request(HttpUriRequest req, HttpClientContext cxt, String defaultCharset) {
        String content = null;
        try (CloseableHttpResponse resp = this.execute(req, cxt);){
            content = EntityUtils.toString((HttpEntity)resp.getEntity(), (String)(defaultCharset == null ? "UTF-8" : defaultCharset));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }

    public CloseableHttpResponse execute(HttpUriRequest request, HttpClientContext cxt) throws IOException {
        return this.httpClient.execute(this.customizer == null ? request : this.customizer.custom(request), (HttpContext)cxt);
    }

    public static interface RequestCustomizer {
        public HttpUriRequest custom(HttpUriRequest var1);
    }
}

