/*
 * Decompiled with CFR 0.152.
 */
package net.wisedream.ezhc;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.stream.Collectors;
import net.wisedream.ezhc.bean.Host;
import net.wisedream.ezhc.bean.HttpClient;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;

public abstract class HttpClientFactory {
    protected final CloseableHttpClient create(final HttpClient hcBean) throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        HttpClientBuilder builder = HttpClients.custom();
        if (hcBean.getProxy() != null) {
            HttpHost proxy = new HttpHost(hcBean.getProxy().getHost(), hcBean.getProxy().getPort().intValue());
            builder.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(proxy));
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(hcBean.getConnectTimeout().intValue()).setSocketTimeout(hcBean.getSocketTimeout().intValue()).setConnectionRequestTimeout(hcBean.getConnRequestTimeout().intValue()).setMaxRedirects(10).build();
        builder.setDefaultRequestConfig(requestConfig);
        if (hcBean.getCredentials() != null) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            List<HttpClient.Credentials.Credential> credentials = hcBean.getCredentials().getCredential();
            for (HttpClient.Credentials.Credential credential : credentials) {
                UsernamePasswordCredentials usernamePassword = new UsernamePasswordCredentials(credential.getUsername(), credential.getPassword());
                credential.getScope().forEach(arg_0 -> HttpClientFactory.lambda$create$0((CredentialsProvider)credsProvider, usernamePassword, arg_0));
            }
            builder.setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy()).setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        if (hcBean.getUserAgent() != null) {
            builder.setUserAgent(hcBean.getUserAgent().trim());
        }
        if (hcBean.getCookieStore() != null) {
            BasicCookieStore store = new BasicCookieStore();
            hcBean.getCookieStore().getCookie().forEach(arg_0 -> HttpClientFactory.lambda$create$1((CookieStore)store, arg_0));
            builder.setDefaultCookieStore((CookieStore)store);
        }
        if (hcBean.getDefaultHeaders() != null) {
            List headers = hcBean.getDefaultHeaders().getHeader().stream().map(ele -> new BasicHeader(ele.getName(), ele.getValue())).collect(Collectors.toList());
            builder.setDefaultHeaders(headers);
        }
        if (hcBean.getSpecificHeaders() != null) {
            builder.addInterceptorFirst(new HttpRequestInterceptor(){
                private List<HttpClient.SpecificHeaders.Header> headers;
                {
                    this.headers = hcBean.getSpecificHeaders().getHeader();
                }

                public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                    String url = HttpClientFactory.this.extractUrl(request);
                    this.headers.stream().filter(header -> url.matches(header.getUrlMatches()) && request.getFirstHeader(header.getName()) == null).forEach(header -> request.addHeader(header.getName(), header.getValue()));
                }
            });
        }
        return builder.setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, (chain, authType) -> true).build()).build();
    }

    private String extractUrl(HttpRequest request) {
        if (request instanceof HttpRequestWrapper) {
            return this.extractUrl(((HttpRequestWrapper)request).getOriginal());
        }
        return ((HttpUriRequest)request).getURI().toString();
    }

    public abstract CloseableHttpClient create() throws Exception;

    private static /* synthetic */ void lambda$create$1(CookieStore store, HttpClient.CookieStore.Cookie ele) {
        BasicClientCookie cookie = new BasicClientCookie(ele.getName(), ele.getValue());
        cookie.setDomain(ele.getDomain());
        cookie.setPath(ele.getPath());
        store.addCookie((Cookie)cookie);
    }

    private static /* synthetic */ void lambda$create$0(CredentialsProvider credsProvider, UsernamePasswordCredentials usernamePassword, Host ele) {
        credsProvider.setCredentials(new AuthScope(ele.getHost(), ele.getPort().intValue()), (Credentials)usernamePassword);
    }
}

