package net.wisedream.ezhc;

import net.wisedream.ezhc.bean.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

/**
 * Create httpclient from xml file.
 *
 * Created by pseudo on 16-1-22.
 */
public final class XmlHttpClientFactory extends HttpClientFactory {

    private String xmlFilePath;

    public XmlHttpClientFactory(String xmlFilePath) {
        this.xmlFilePath = xmlFilePath;
    }

    public CloseableHttpClient create() throws Exception {
        HttpClient hcBean = unmarshal(HttpClient.class, loadXmlFile(xmlFilePath));
        return create(hcBean);
    }

    private static <T> T unmarshal(Class<T> docClass, InputStream inputStream)
            throws JAXBException {
        String packageName = docClass.getPackage().getName();
        JAXBContext jc = JAXBContext.newInstance(packageName);
        Unmarshaller u = jc.createUnmarshaller();
        return (T) u.unmarshal(inputStream);
    }

    private InputStream loadXmlFile(String filePath) throws FileNotFoundException {
        if (filePath.startsWith("classpath:")) {
            InputStream in = this.getClass().getResourceAsStream(filePath.substring("classpath:".length(), filePath.length()).trim());
            if (in == null)
                throw new FileNotFoundException(filePath + " not found");
            return in;
        } else
            return new FileInputStream(filePath);
    }
}

