package net.wisedream.ezhc;


import lombok.Data;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;

import java.io.IOException;

/**
 * StatefulHttpClientService executes requests with the same
 * {@link org.apache.http.client.protocol.HttpClientContext},
 * that is requests are executed with the same resources such as
 * {@link org.apache.http.client.CookieStore}. It's applicable
 * for the Login-then-request scenario.
 *
 * @see net.wisedream.ezhc.HttpClientService
 */
@Data
public final class StatefulHttpClientService extends HttpClientService {
    private final HttpClientContext cxt;

    public StatefulHttpClientService(CloseableHttpClient httpClient) {
        this(httpClient, null, null);
    }

    public StatefulHttpClientService(CloseableHttpClient httpClient, HttpClientContext cxt) {
        this(httpClient, cxt, null);
    }

    public StatefulHttpClientService(CloseableHttpClient httpClient, HttpClientContext cxt, RequestCustomizer customizer) {
        super(httpClient, customizer);
        this.cxt = cxt == null ? HttpClientContext.create() : cxt;
    }

    /**
     * Send request and reads the response content
     *
     * @param req
     * @return null if failed
     */
    public String request(HttpUriRequest req, String defaultCharset) {
        return super.request(req, this.cxt, defaultCharset);
    }

    public CloseableHttpResponse execute(HttpUriRequest request) throws IOException {
        return execute(request, this.cxt);
    }

}
