package net.wisedream.ezhc;

import lombok.Getter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;

import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by pseudo on 16-1-26.
 */

public class HttpRequestBuilder {
    @Getter
    private String url;
    @Getter
    private String method = "GET";
    @Getter
    private Map<String, String> headers = new HashMap<>();
    @Getter
    private HttpEntity entity;
    @Getter
    private HttpHost proxy;

    public HttpRequestBuilder(String url) {
        this.url = url;
    }

    public static HttpRequestBuilder of(String url) {
        return new HttpRequestBuilder(url);
    }

    public static HttpRequestBuilder of(String uri, String charset, NameValuePair... nvps) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(uri).setCharset(Charset.forName(charset));
        builder.addParameters(Arrays.asList(nvps));
        return of(builder.build().toString());
    }

    public HttpRequestBuilder withMethod(String method) {
        this.method = method.toUpperCase();
        return this;
    }

    public HttpRequestBuilder withHeader(String name, String value) {
        headers.put(name, value);
        return this;
    }

    public HttpRequestBuilder withEntity(HttpEntity entity) {
        this.entity = entity;
        return this;
    }

    public HttpRequestBuilder withProxy(String host, int port) {
        this.proxy = new HttpHost(host, port);
        return this;
    }

    public HttpUriRequest build() {
        RequestBuilder builder = RequestBuilder.create(this.method).setUri(this.url);
        this.headers.forEach((k, v) -> builder.setHeader(k, v));
        if (this.entity != null) builder.setEntity(this.entity);
        if (this.proxy != null) builder.setConfig(RequestConfig.custom().setProxy(this.proxy).build());
        return builder.build();
    }
}
