package net.wisedream.ezhc;

import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

import java.nio.charset.Charset;
import java.util.List;

/**
 * Created by pseudo on 16-1-26.
 */
public class HttpEntities {
    public static HttpEntity urlEncodedFormEntity(List<? extends NameValuePair> params, Charset charset) {
        return new UrlEncodedFormEntity(params, charset);
    }

    public static HttpEntity urlEncodedFormEntity(String content, Charset charset) {
        return stringEntity(content, ContentType.APPLICATION_FORM_URLENCODED.withCharset(charset));
    }

    public static HttpEntity textPlainEntity(String content, Charset charset) {
        return stringEntity(content, ContentType.TEXT_PLAIN.withCharset(charset));
    }

    public static HttpEntity xmlEntity(String content, Charset charset) {
        return stringEntity(content, ContentType.TEXT_XML.withCharset(charset));
    }

    public static HttpEntity jsonEntity(String content, Charset charset) {
        return stringEntity(content, ContentType.APPLICATION_JSON.withCharset(charset));
    }

    public static HttpEntity octetStreamEntity(byte[] content) {
        return new ByteArrayEntity(content, ContentType.APPLICATION_OCTET_STREAM);
    }

    public static HttpEntity byteArrayEntity(byte[] content, ContentType contentType) {
        return new ByteArrayEntity(content, contentType);
    }

    public static HttpEntity stringEntity(String content, ContentType contentType) {
        return new StringEntity(content, contentType);
    }
}
