/*
 * Decompiled with CFR 0.152.
 */
package net.wiringbits.webapp.utils.admin.tasks;

import java.io.Serializable;
import java.sql.Connection;
import javax.inject.Inject;
import net.wiringbits.webapp.utils.admin.config.DataExplorerSettings;
import net.wiringbits.webapp.utils.admin.config.TableSettings;
import net.wiringbits.webapp.utils.admin.repositories.daos.DatabaseTablesDAO$;
import net.wiringbits.webapp.utils.admin.repositories.models.DatabaseTable;
import net.wiringbits.webapp.utils.admin.repositories.models.TableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.db.Database;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u00055a\u0001B\u0006\r\u0001eA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!)!\u0007\u0001C\u0001g!9\u0011\t\u0001b\u0001\n\u0013\u0011\u0005BB&\u0001A\u0003%1\tC\u0003M\u0001\u0011\u0005Q\nC\u0003R\u0001\u0011%Q\nC\u0003S\u0001\u0011%1\u000bC\u0003u\u0001\u0011%Q\u000fC\u0004\u0002\u0004\u0001!I!!\u0002\u0003?\u0011\u000bG/Y#ya2|'/\u001a:D_:4\u0017n\u001a,bY&$\u0017\r^8s)\u0006\u001c8N\u0003\u0002\u000e\u001d\u0005)A/Y:lg*\u0011q\u0002E\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003#I\tQ!\u001e;jYNT!a\u0005\u000b\u0002\r],'-\u00199q\u0015\t)b#\u0001\u0006xSJLgn\u001a2jiNT\u0011aF\u0001\u0004]\u0016$8\u0001A\n\u0003\u0001i\u0001\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a!\u00118z%\u00164\u0017\u0001\u00033bi\u0006\u0014\u0017m]3\u0011\u0005\tJS\"A\u0012\u000b\u0005\u0011*\u0013A\u00013c\u0015\t1s%A\u0002ba&T\u0011\u0001K\u0001\u0005a2\f\u00170\u0003\u0002+G\tAA)\u0019;bE\u0006\u001cX-\u0001\u0005tKR$\u0018N\\4t!\ti\u0003'D\u0001/\u0015\tyc\"\u0001\u0004d_:4\u0017nZ\u0005\u0003c9\u0012A\u0003R1uC\u0016C\b\u000f\\8sKJ\u001cV\r\u001e;j]\u001e\u001c\u0018A\u0002\u001fj]&$h\bF\u00025m]\u0002\"!\u000e\u0001\u000e\u00031AQ\u0001I\u0002A\u0002\u0005BQaK\u0002A\u00021B#aA\u001d\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014AB5oU\u0016\u001cGOC\u0001?\u0003\u0015Q\u0017M^1y\u0013\t\u00015H\u0001\u0004J]*,7\r^\u0001\u0007Y><w-\u001a:\u0016\u0003\r\u0003\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\u000bMdg\r\u000e6\u000b\u0003!\u000b1a\u001c:h\u0013\tQUI\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003\u0015\u0019H/\u0019:u)\u0005q\u0005CA\u000eP\u0013\t\u0001FD\u0001\u0003V]&$\u0018a\u0001:v]\u0006\tb/\u00197jI\u0006$X\rV1cY\u0016t\u0015-\\3\u0015\u00079#\u0016\rC\u0003V\u0011\u0001\u0007a+A\u0005uC\ndWMT1nKB\u0011qK\u0018\b\u00031r\u0003\"!\u0017\u000f\u000e\u0003iS!a\u0017\r\u0002\rq\u0012xn\u001c;?\u0013\tiF$\u0001\u0004Qe\u0016$WMZ\u0005\u0003?\u0002\u0014aa\u0015;sS:<'BA/\u001d\u0011\u0015\u0011\u0007\u00021\u0001d\u0003)!\u0018M\u00197fg&sGI\u0011\t\u0004I&dgBA3h\u001d\tIf-C\u0001\u001e\u0013\tAG$A\u0004qC\u000e\\\u0017mZ3\n\u0005)\\'\u0001\u0002'jgRT!\u0001\u001b\u000f\u0011\u00055\u0014X\"\u00018\u000b\u0005=\u0004\u0018AB7pI\u0016d7O\u0003\u0002r\u001d\u0005a!/\u001a9pg&$xN]5fg&\u00111O\u001c\u0002\u000e\t\u0006$\u0018MY1tKR\u000b'\r\\3\u00023Y\fG.\u001b3bi\u0016|%\u000fZ3sS:<7i\u001c8eSRLwN\u001c\u000b\u0004\u001dZ\\\b\"B<\n\u0001\u0004A\u0018!\u0002;bE2,\u0007CA\u0017z\u0013\tQhFA\u0007UC\ndWmU3ui&twm\u001d\u0005\u0006y&\u0001\r!`\u0001\u0007M&,G\u000eZ:\u0011\u0007\u0011Lg\u0010\u0005\u0002n\u007f&\u0019\u0011\u0011\u00018\u0003\u0015Q\u000b'\r\\3GS\u0016dG-A\nwC2LG-\u0019;f\u0013\u00124\u0015.\u001a7e\u001d\u0006lW\rF\u0003O\u0003\u000f\tY\u0001\u0003\u0004\u0002\n)\u0001\rAV\u0001\fS\u00124\u0015.\u001a7e\u001d\u0006lW\rC\u0003}\u0015\u0001\u0007Q\u0010")
public class DataExplorerConfigValidatorTask {
    private final Database database;
    private final DataExplorerSettings settings;
    private final Logger logger;

    private Logger logger() {
        return this.logger;
    }

    public void start() {
        this.logger().info("Running task");
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.run());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.logger().error("Data explorer settings validation failed", exception);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            this.logger().info("Data explorer settings validated");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    private void run() {
        this.database.withConnection((Function1 & Serializable)conn -> {
            DataExplorerConfigValidatorTask.$anonfun$run$1(this, conn);
            return BoxedUnit.UNIT;
        });
    }

    private void validateTableName(String tableName, List<DatabaseTable> tablesInDB) {
        if (!tablesInDB.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DataExplorerConfigValidatorTask.$anonfun$validateTableName$1(tableName, x$1)))) {
            throw new RuntimeException(new StringBuilder(31).append(tableName).append(" not found, available tables = ").append(tablesInDB.mkString(", ")).toString());
        }
    }

    private void validateOrderingCondition(TableSettings table, List<TableField> fields) {
        String orderingCondition = table.defaultOrderByClause();
        String[] splitCondition = orderingCondition.split(",");
        BoxedUnit[] boxedUnitArray = (BoxedUnit[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])splitCondition), (Function1 & Serializable)orderSQL -> {
            String fieldName = orderSQL.toUpperCase().replaceAll("(ASC)|(DESC)", "").trim();
            boolean exists = fields.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DataExplorerConfigValidatorTask.$anonfun$validateOrderingCondition$2(fieldName, x$2)));
            if (!exists) {
                throw new RuntimeException(new StringBuilder(90).append("You need to include a valid field name on OrderingCondition for table = ").append(table.tableName()).append(", unknown field = ").append(fieldName).toString());
            }
            BoxedUnit x$3 = BoxedUnit.UNIT;
            return new Tuple4(orderSQL, (Object)fieldName, (Object)BoxesRunTime.boxToBoolean((boolean)exists), (Object)x$3);
        }, ClassTag$.MODULE$.apply(Tuple4.class))), (Function1 & Serializable)x$4 -> {
            DataExplorerConfigValidatorTask.$anonfun$validateOrderingCondition$3(x$4);
            return BoxedUnit.UNIT;
        }, (ClassTag)ClassTag$.MODULE$.Unit());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    private void validateIdFieldName(String idFieldName, List<TableField> fields) {
        boolean exists = fields.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DataExplorerConfigValidatorTask.$anonfun$validateIdFieldName$1(idFieldName, x$6)));
        if (!exists) {
            throw new RuntimeException(new StringBuilder(57).append("The provided id on DataExplorer settings doesn't exists: ").append(idFieldName).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$run$2(DataExplorerConfigValidatorTask $this, Connection conn$1, List tables$1, TableSettings settingsTable) {
        $this.logger().info(new StringBuilder(10).append("Verifying ").append(settingsTable.tableName()).toString());
        List<TableField> fields = DatabaseTablesDAO$.MODULE$.getTableFields(settingsTable.tableName(), conn$1);
        $this.validateTableName(settingsTable.tableName(), (List<DatabaseTable>)tables$1);
        $this.validateOrderingCondition(settingsTable, fields);
        $this.validateIdFieldName(settingsTable.idFieldName(), fields);
    }

    public static final /* synthetic */ void $anonfun$run$1(DataExplorerConfigValidatorTask $this, Connection conn) {
        List<DatabaseTable> tables = DatabaseTablesDAO$.MODULE$.all(DatabaseTablesDAO$.MODULE$.all$default$1(), conn);
        $this.settings.tables().foreach((Function1 & Serializable)settingsTable -> {
            DataExplorerConfigValidatorTask.$anonfun$run$2($this, conn, tables, settingsTable);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$validateTableName$1(String tableName$1, DatabaseTable x$1) {
        String string = x$1.name();
        String string2 = tableName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateOrderingCondition$2(String fieldName$1, TableField x$2) {
        String string = x$2.name().toUpperCase();
        String string2 = fieldName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$validateOrderingCondition$3(Tuple4 x$4) {
        Tuple4 tuple4 = x$4;
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$validateIdFieldName$1(String idFieldName$1, TableField x$6) {
        String string = x$6.name();
        String string2 = idFieldName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Inject
    public DataExplorerConfigValidatorTask(Database database, DataExplorerSettings settings) {
        this.database = database;
        this.settings = settings;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.start();
    }
}

