/*
 * Decompiled with CFR 0.152.
 */
package net.wiringbits.webapp.utils.admin.services;

import java.io.Serializable;
import javax.inject.Inject;
import net.wiringbits.webapp.utils.admin.config.DataExplorerSettings;
import net.wiringbits.webapp.utils.admin.repositories.DatabaseTablesRepository;
import net.wiringbits.webapp.utils.admin.repositories.models.DatabaseTable;
import net.wiringbits.webapp.utils.admin.repositories.models.TableMetadata;
import net.wiringbits.webapp.utils.admin.utils.models.pagination.package;
import net.wiringbits.webapp.utils.api.models.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005e\u0001B\b\u0011\u0001uA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!A!\u0007\u0001B\u0001B\u0003-1\u0007C\u0003:\u0001\u0011\u0005!\bC\u0003K\u0001\u0011\u00051\nC\u0003j\u0001\u0011\u0005!\u000eC\u0004\u0002\u001a\u0001!\t!a\u0007\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003bBA+\u0001\u0011\u0005\u0011q\u000b\u0005\b\u0003;\u0002A\u0011BA0\u0011\u001d\ti\u0007\u0001C\u0005\u0003_Bq!!\u001e\u0001\t\u0013\t9\bC\u0004\u0002|\u0001!I!! \u0003\u0019\u0005#W.\u001b8TKJ4\u0018nY3\u000b\u0005E\u0011\u0012\u0001C:feZL7-Z:\u000b\u0005M!\u0012!B1e[&t'BA\u000b\u0017\u0003\u0015)H/\u001b7t\u0015\t9\u0002$\u0001\u0004xK\n\f\u0007\u000f\u001d\u0006\u00033i\t!b^5sS:<'-\u001b;t\u0015\u0005Y\u0012a\u00018fi\u000e\u00011C\u0001\u0001\u001f!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fM\u0006AB-\u0019;bE\u0006\u001cX\rV1cY\u0016\u001c(+\u001a9pg&$xN]=\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!\u0012\u0012\u0001\u0004:fa>\u001c\u0018\u000e^8sS\u0016\u001c\u0018B\u0001\u0016(\u0005a!\u0015\r^1cCN,G+\u00192mKN\u0014V\r]8tSR|'/_\u0001\u000ei\u0006\u0014G.Z*fiRLgnZ:\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=\u0012\u0012AB2p]\u001aLw-\u0003\u00022]\t!B)\u0019;b\u000bb\u0004Hn\u001c:feN+G\u000f^5oON\f!!Z2\u0011\u0005Q:T\"A\u001b\u000b\u0005Y\u0002\u0013AC2p]\u000e,(O]3oi&\u0011\u0001(\u000e\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0001P5oSRtDcA\u001e@\u0001R\u0011AH\u0010\t\u0003{\u0001i\u0011\u0001\u0005\u0005\u0006e\u0011\u0001\u001da\r\u0005\u0006I\u0011\u0001\r!\n\u0005\u0006W\u0011\u0001\r\u0001\f\u0015\u0003\t\t\u0003\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\r%t'.Z2u\u0015\u00059\u0015!\u00026bm\u0006D\u0018BA%E\u0005\u0019IeN[3di\u00061A/\u00192mKN$\u0012\u0001\u0014\t\u0004i5{\u0015B\u0001(6\u0005\u00191U\u000f^;sKB\u0011\u0001K\u001a\b\u0003#\u000et!A\u00151\u000f\u0005MsfB\u0001+^\u001d\t)FL\u0004\u0002W7:\u0011qKW\u0007\u00021*\u0011\u0011\fH\u0001\u0007yI|w\u000e\u001e \n\u0003mI!!\u0007\u000e\n\u0005]A\u0012BA\u000b\u0017\u0013\tyF#A\u0002ba&L!!\u00192\u0002\r5|G-\u001a7t\u0015\tyF#\u0003\u0002eK\u00069\u0001/Y2lC\u001e,'BA1c\u0013\t9\u0007N\u0001\fBI6LgnR3u)\u0006\u0014G.Z:SKN\u0004xN\\:f\u0015\t!W-A\u0007uC\ndW-T3uC\u0012\fG/\u0019\u000b\u0004W>L\bc\u0001\u001bNYB\u0011\u0001+\\\u0005\u0003]\"\u0014Q$\u00113nS:<U\r\u001e+bE2,W*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a\u0005\u0006a\u001a\u0001\r!]\u0001\ni\u0006\u0014G.\u001a(b[\u0016\u0004\"A\u001d<\u000f\u0005M$\bCA,!\u0013\t)\b%\u0001\u0004Qe\u0016$WMZ\u0005\u0003ob\u0014aa\u0015;sS:<'BA;!\u0011\u0015Qh\u00011\u0001|\u0003)\u0001\u0018mZ5oCRLwN\u001c\t\u0004y\u0006MabA?\u0002\u00109\u0019a0a\u0003\u000f\u0007}\f9A\u0004\u0003\u0002\u0002\u0005\u0015abA*\u0002\u0004%\u00111\u0003F\u0005\u0003+II1!YA\u0005\u0015\t)\"#C\u0002{\u0003\u001bQ1!YA\u0005\u0013\r!\u0017\u0011\u0003\u0006\u0004u\u00065\u0011\u0002BA\u000b\u0003/\u0011a\u0002U1hS:\fG/\u001a3Rk\u0016\u0014\u0018PC\u0002e\u0003#\tAAZ5oIR1\u0011QDA\u0013\u0003O\u0001B\u0001N'\u0002 A\u0019\u0001+!\t\n\u0007\u0005\r\u0002N\u0001\fBI6LgNR5oIR\u000b'\r\\3SKN\u0004xN\\:f\u0011\u0015\u0001x\u00011\u0001r\u0011\u0019\tIc\u0002a\u0001c\u0006\u0011\u0011\u000eZ\u0001\u0007GJ,\u0017\r^3\u0015\r\u0005=\u0012qGA\u001d!\u0011!T*!\r\u0011\u0007}\t\u0019$C\u0002\u00026\u0001\u0012A!\u00168ji\")\u0001\u000f\u0003a\u0001c\"9\u00111\b\u0005A\u0002\u0005u\u0012a\u0002:fcV,7\u000f\u001e\t\u0004!\u0006}\u0012bAA!Q\n9\u0012\tZ7j]\u000e\u0013X-\u0019;f)\u0006\u0014G.\u001a*fcV,7\u000f^\u0001\u0007kB$\u0017\r^3\u0015\u0011\u0005=\u0012qIA%\u0003\u001bBQ\u0001]\u0005A\u0002EDa!a\u0013\n\u0001\u0004\t\u0018AA%E\u0011\u001d\tY$\u0003a\u0001\u0003\u001f\u00022\u0001UA)\u0013\r\t\u0019\u0006\u001b\u0002\u0018\u0003\u0012l\u0017N\\+qI\u0006$X\rV1cY\u0016\u0014V-];fgR\fa\u0001Z3mKR,GCBA\u0018\u00033\nY\u0006C\u0003q\u0015\u0001\u0007\u0011\u000f\u0003\u0004\u0002L)\u0001\r!]\u0001\u0014m\u0006d\u0017\u000eZ1uKR\u000b'\r\\3GS\u0016dGm\u001d\u000b\u0007\u0003_\t\t'a\u0019\t\u000bA\\\u0001\u0019A9\t\u000f\u0005\u00154\u00021\u0001\u0002h\u0005!!m\u001c3z!\u0015\u0011\u0018\u0011N9r\u0013\r\tY\u0007\u001f\u0002\u0004\u001b\u0006\u0004\u0018\u0001\u0003<bY&$\u0017\r^3\u0015\r\u0005=\u0012\u0011OA:\u0011\u0015\u0001H\u00021\u0001r\u0011\u0015QH\u00021\u0001|\u0003E1\u0018\r\\5eCR,G+\u00192mK:\u000bW.\u001a\u000b\u0005\u0003_\tI\bC\u0003q\u001b\u0001\u0007\u0011/\u0001\nwC2LG-\u0019;f!\u0006<\u0017N\\1uS>tG\u0003BA\u0019\u0003\u007fBQA\u001f\bA\u0002m\u0004")
public class AdminService {
    private final DatabaseTablesRepository databaseTablesRepository;
    private final DataExplorerSettings tableSettings;
    private final ExecutionContext ec;

    public Future<package.AdminGetTablesResponse> tables() {
        return this.databaseTablesRepository.getTablesInSettings(this.tableSettings).map((Function1 & Serializable)tables -> {
            List items = tables.map((Function1 & Serializable)x -> new package.AdminGetTablesResponse.DatabaseTable(x.name()));
            return new Tuple2(tables, (Object)items);
        }, this.ec).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List items = (List)tuple2._2();
            package.AdminGetTablesResponse adminGetTablesResponse = new package.AdminGetTablesResponse(items);
            return adminGetTablesResponse;
        }, this.ec);
    }

    public Future<package.AdminGetTableMetadataResponse> tableMetadata(String tableName, package.PaginatedQuery pagination) {
        return this.validate(tableName, pagination).flatMap((Function1 & Serializable)x$3 -> {
            BoxedUnit boxedUnit = x$3;
            Future future = $this.databaseTablesRepository.getTableMetadata(tableName, pagination).map((Function1 & Serializable)tableMetadata -> new package.AdminGetTableMetadataResponse(((TableMetadata)tableMetadata.data()).name(), ((TableMetadata)tableMetadata.data()).fields().map((Function1 & Serializable)x -> new package.AdminGetTableMetadataResponse.TableField(x.name(), x.type())), ((TableMetadata)tableMetadata.data()).rows().map((Function1 & Serializable)x -> new package.AdminGetTableMetadataResponse.TableRow(x.data().map((Function1 & Serializable)x$2 -> x$2.value()).map((Function1 & Serializable)value -> new package.AdminGetTableMetadataResponse.Cell(value)))), tableMetadata.offset(), tableMetadata.limit(), tableMetadata.total()), $this.ec);
            return future;
        }, this.ec);
    }

    public Future<package.AdminFindTableResponse> find(String tableName, String id) {
        return this.validateTableName(tableName).flatMap((Function1 & Serializable)x$5 -> {
            BoxedUnit boxedUnit = x$5;
            Future future = $this.databaseTablesRepository.find(tableName, id).map((Function1 & Serializable)row -> new package.AdminFindTableResponse(new package.AdminGetTableMetadataResponse.TableRow(row.data().map((Function1 & Serializable)x$4 -> x$4.value()).map((Function1 & Serializable)value -> new package.AdminGetTableMetadataResponse.Cell(value)))), $this.ec);
            return future;
        }, this.ec);
    }

    public Future<BoxedUnit> create(String tableName, package.AdminCreateTableRequest request) {
        Map body = request.data();
        Future validate = this.validateTableName(tableName).flatMap((Function1 & Serializable)x$9 -> {
            BoxedUnit boxedUnit = x$9;
            Future future = this.validateTableFields(tableName, (Map<String, String>)body).flatMap((Function1 & Serializable)x$8 -> {
                BoxedUnit boxedUnit = x$8;
                Future future = $this.databaseTablesRepository.getMandatoryFields(tableName).map((Function1 & Serializable)mandatoryFields -> {
                    List mandatoryFieldNames = mandatoryFields.map((Function1 & Serializable)x$6 -> x$6.name());
                    return new Tuple2(mandatoryFields, (Object)mandatoryFieldNames);
                }, $this.ec).map((Function1 & Serializable)x$7 -> {
                    AdminService.$anonfun$create$5(request, x$7);
                    return BoxedUnit.UNIT;
                }, $this.ec);
                return future;
            }, $this.ec);
            return future;
        }, this.ec);
        return validate.flatMap((Function1 & Serializable)x$11 -> {
            BoxedUnit boxedUnit = x$11;
            Future future = $this.databaseTablesRepository.create(tableName, (Map<String, String>)body).map((Function1 & Serializable)x$10 -> {
                AdminService.$anonfun$create$9(x$10);
                return BoxedUnit.UNIT;
            }, $this.ec);
            return future;
        }, this.ec);
    }

    public Future<BoxedUnit> update(String tableName, String ID, package.AdminUpdateTableRequest request) {
        Future validate = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            if (request.data().isEmpty()) {
                throw new RuntimeException("You need to send some data");
            }
        }, this.ec);
        Map body = request.data();
        return validate.flatMap((Function1 & Serializable)x$15 -> {
            BoxedUnit boxedUnit = x$15;
            Future future = this.validateTableName(tableName).flatMap((Function1 & Serializable)x$14 -> {
                BoxedUnit boxedUnit = x$14;
                Future future = this.validateTableFields(tableName, (Map<String, String>)body).flatMap((Function1 & Serializable)x$13 -> {
                    BoxedUnit boxedUnit = x$13;
                    Future future = $this.databaseTablesRepository.update(tableName, ID, (Map<String, String>)body).map((Function1 & Serializable)x$12 -> {
                        AdminService.$anonfun$update$5(x$12);
                        return BoxedUnit.UNIT;
                    }, $this.ec);
                    return future;
                }, $this.ec);
                return future;
            }, $this.ec);
            return future;
        }, this.ec);
    }

    public Future<BoxedUnit> delete(String tableName, String ID) {
        return this.validateTableName(tableName).flatMap((Function1 & Serializable)x$17 -> {
            BoxedUnit boxedUnit = x$17;
            Future future = $this.databaseTablesRepository.delete(tableName, ID).map((Function1 & Serializable)x$16 -> {
                AdminService.$anonfun$delete$2(x$16);
                return BoxedUnit.UNIT;
            }, $this.ec);
            return future;
        }, this.ec);
    }

    private Future<BoxedUnit> validateTableFields(String tableName, Map<String, String> body) {
        return this.databaseTablesRepository.getTableFields(tableName).map((Function1 & Serializable)fields -> {
            List fieldsNames = fields.map((Function1 & Serializable)x$18 -> x$18.name());
            Iterable requestFields = body.keys();
            boolean exists = requestFields.forall((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)fieldsNames.contains(elem)));
            return new Tuple4(fields, (Object)fieldsNames, (Object)requestFields, (Object)BoxesRunTime.boxToBoolean((boolean)exists));
        }, this.ec).map((Function1 & Serializable)x$19 -> {
            AdminService.$anonfun$validateTableFields$4(x$19);
            return BoxedUnit.UNIT;
        }, this.ec);
    }

    private Future<BoxedUnit> validate(String tableName, package.PaginatedQuery pagination) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.validatePagination(pagination), this.ec).flatMap((Function1 & Serializable)x$21 -> {
            BoxedUnit boxedUnit = x$21;
            Future future = this.validateTableName(tableName).map((Function1 & Serializable)x$20 -> {
                AdminService.$anonfun$validate$3(x$20);
                return BoxedUnit.UNIT;
            }, $this.ec);
            return future;
        }, this.ec);
    }

    private Future<BoxedUnit> validateTableName(String tableName) {
        return this.databaseTablesRepository.getTablesInSettings(this.tableSettings).map((Function1 & Serializable)tables -> {
            boolean exists = tables.exists((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)AdminService.$anonfun$validateTableName$2(tableName, x$22)));
            return new Tuple2(tables, (Object)BoxesRunTime.boxToBoolean((boolean)exists));
        }, this.ec).map((Function1 & Serializable)x$23 -> {
            AdminService.$anonfun$validateTableName$3(tableName, x$23);
            return BoxedUnit.UNIT;
        }, this.ec);
    }

    private void validatePagination(package.PaginatedQuery pagination) {
        if (0 > pagination.offset() || 0 > pagination.limit()) {
            throw new RuntimeException("You can't query a table using negative numbers as a limit or offset");
        }
    }

    public static final /* synthetic */ boolean $anonfun$create$6(package.AdminCreateTableRequest request$1, String key) {
        return request$1.data().contains((Object)key);
    }

    public static final /* synthetic */ boolean $anonfun$create$7(package.AdminCreateTableRequest request$1, String key) {
        return request$1.data().contains((Object)key);
    }

    public static final /* synthetic */ void $anonfun$create$5(package.AdminCreateTableRequest request$1, Tuple2 x$7) {
        Tuple2 tuple2 = x$7;
        if (tuple2 != null) {
            List mandatoryFieldNames = (List)tuple2._2();
            if (!mandatoryFieldNames.forall((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)AdminService.$anonfun$create$6(request$1, key)))) {
                throw new RuntimeException(new StringBuilder(26).append("There are missing fields: ").append(mandatoryFieldNames.filterNot((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)AdminService.$anonfun$create$7(request$1, key))).mkString(", ")).toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$create$9(BoxedUnit x$10) {
        BoxedUnit boxedUnit = x$10;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$update$5(BoxedUnit x$12) {
        BoxedUnit boxedUnit = x$12;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$delete$2(BoxedUnit x$16) {
        BoxedUnit boxedUnit = x$16;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$validateTableFields$4(Tuple4 x$19) {
        Tuple4 tuple4 = x$19;
        if (tuple4 != null) {
            boolean exists = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
            if (!exists) {
                throw new RuntimeException("A field doesn't correspond to this table schema");
            }
        } else {
            throw new MatchError((Object)tuple4);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$validate$3(BoxedUnit x$20) {
        BoxedUnit boxedUnit = x$20;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$validateTableName$2(String tableName$7, DatabaseTable x$22) {
        String string = x$22.name();
        String string2 = tableName$7;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$validateTableName$3(String tableName$7, Tuple2 x$23) {
        Tuple2 tuple2 = x$23;
        if (tuple2 != null) {
            boolean exists = tuple2._2$mcZ$sp();
            if (!exists) {
                throw new RuntimeException(new StringBuilder(52).append("Unexpected error because the DB table wasn't found: ").append(tableName$7).toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Inject
    public AdminService(DatabaseTablesRepository databaseTablesRepository, DataExplorerSettings tableSettings, ExecutionContext ec) {
        this.databaseTablesRepository = databaseTablesRepository;
        this.tableSettings = tableSettings;
        this.ec = ec;
    }
}

