/*
 * Decompiled with CFR 0.152.
 */
package net.wiringbits.webapp.utils.admin.repositories;

import java.io.Serializable;
import java.sql.Connection;
import javax.inject.Inject;
import net.wiringbits.webapp.utils.admin.config.DataExplorerSettings;
import net.wiringbits.webapp.utils.admin.config.PrimaryKeyDataType;
import net.wiringbits.webapp.utils.admin.config.TableSettings;
import net.wiringbits.webapp.utils.admin.executors.DatabaseExecutionContext;
import net.wiringbits.webapp.utils.admin.repositories.daos.DatabaseTablesDAO$;
import net.wiringbits.webapp.utils.admin.repositories.models.DatabaseTable;
import net.wiringbits.webapp.utils.admin.repositories.models.ForeignKey;
import net.wiringbits.webapp.utils.admin.repositories.models.TableColumn;
import net.wiringbits.webapp.utils.admin.repositories.models.TableData;
import net.wiringbits.webapp.utils.admin.repositories.models.TableRow;
import net.wiringbits.webapp.utils.admin.utils.models.QueryParameters;
import play.api.db.Database;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005]f\u0001B\t\u0013\u0001}A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tc\u0001\u0011\t\u0011)A\u0006e!A\u0001\b\u0001B\u0001B\u0003-\u0011\bC\u0003@\u0001\u0011\u0005\u0001\tC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003k\u0001\u0011\u00051\u000eC\u0003|\u0001\u0011\u0005A\u0010C\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!9\u0011Q\u0007\u0001\u0005\n\u0005]\u0002bBA(\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u0003C\u0002A\u0011AA2\u0011\u001d\tI\b\u0001C\u0001\u0003wBq!a!\u0001\t\u0003\t)\tC\u0004\u0002\f\u0002!\t!!$\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\nAB)\u0019;bE\u0006\u001cX\rV1cY\u0016\u001c(+\u001a9pg&$xN]=\u000b\u0005M!\u0012\u0001\u0004:fa>\u001c\u0018\u000e^8sS\u0016\u001c(BA\u000b\u0017\u0003\u0015\tG-\\5o\u0015\t9\u0002$A\u0003vi&d7O\u0003\u0002\u001a5\u00051q/\u001a2baBT!a\u0007\u000f\u0002\u0015]L'/\u001b8hE&$8OC\u0001\u001e\u0003\rqW\r^\u0002\u0001'\t\u0001\u0001\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VMZ\u0001\tI\u0006$\u0018MY1tKB\u0011\u0001fL\u0007\u0002S)\u0011!fK\u0001\u0003I\nT!\u0001L\u0017\u0002\u0007\u0005\u0004\u0018NC\u0001/\u0003\u0011\u0001H.Y=\n\u0005AJ#\u0001\u0003#bi\u0006\u0014\u0017m]3\u0002\u0005\u0015\u001c\u0007CA\u001a7\u001b\u0005!$BA\u001b\u0015\u0003%)\u00070Z2vi>\u00148/\u0003\u00028i\tAB)\u0019;bE\u0006\u001cX-\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u001bQ\f'\r\\3TKR$\u0018N\\4t!\tQT(D\u0001<\u0015\taD#\u0001\u0004d_:4\u0017nZ\u0005\u0003}m\u0012A\u0003R1uC\u0016C\b\u000f\\8sKJ\u001cV\r\u001e;j]\u001e\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0002B\rR\u0019!\tR#\u0011\u0005\r\u0003Q\"\u0001\n\t\u000bE\"\u00019\u0001\u001a\t\u000ba\"\u00019A\u001d\t\u000b\u0019\"\u0001\u0019A\u0014)\u0005\u0011A\u0005CA%O\u001b\u0005Q%BA&M\u0003\u0019IgN[3di*\tQ*A\u0003kCZ\f\u00070\u0003\u0002P\u0015\n1\u0011J\u001c6fGR\f1!\u00197m)\u0005\u0011\u0006cA*W16\tAK\u0003\u0002VE\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005]#&A\u0002$viV\u0014X\rE\u0002ZC\u0012t!AW0\u000f\u0005msV\"\u0001/\u000b\u0005us\u0012A\u0002\u001fs_>$h(C\u0001$\u0013\t\u0001'%A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001c'\u0001\u0002'jgRT!\u0001\u0019\u0012\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001d\u0014\u0012AB7pI\u0016d7/\u0003\u0002jM\niA)\u0019;bE\u0006\u001cX\rV1cY\u0016\fqbZ3u)\u0006\u0014G.Z\"pYVlgn\u001d\u000b\u0003YF\u00042a\u0015,n!\rI\u0016M\u001c\t\u0003K>L!\u0001\u001d4\u0003\u0017Q\u000b'\r\\3D_2,XN\u001c\u0005\u0006e\u001a\u0001\ra]\u0001\ni\u0006\u0014G.\u001a(b[\u0016\u0004\"\u0001\u001e=\u000f\u0005U4\bCA.#\u0013\t9(%\u0001\u0004Qe\u0016$WMZ\u0005\u0003sj\u0014aa\u0015;sS:<'BA<#\u000399W\r\u001e$pe\u0016LwM\\&fsN$2!`A\u0003!\r\u0019fK \t\u00043\u0006|\bcA3\u0002\u0002%\u0019\u00111\u00014\u0003\u0015\u0019{'/Z5h].+\u0017\u0010C\u0003s\u000f\u0001\u00071/\u0001\nhKRl\u0015M\u001c3bi>\u0014\u0018PR5fY\u0012\u001cHc\u00017\u0002\f!)!\u000f\u0003a\u0001g\u0006\u0001r-\u001a;UC\ndW-T3uC\u0012\fG/\u0019\u000b\u0007\u0003#\tY\"!\n\u0011\tM3\u00161\u0003\t\u00053\u0006\f)\u0002E\u0002f\u0003/I1!!\u0007g\u0005%!\u0016M\u00197f\t\u0006$\u0018\rC\u0004\u0002\u001e%\u0001\r!a\b\u0002\u0011M,G\u000f^5oON\u00042AOA\u0011\u0013\r\t\u0019c\u000f\u0002\u000e)\u0006\u0014G.Z*fiRLgnZ:\t\u000f\u0005\u001d\u0012\u00021\u0001\u0002*\u0005y\u0011/^3ssB\u000b'/Y7fi\u0016\u00148\u000f\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\r9\u0017q\u0006\u0006\u0003/QIA!a\r\u0002.\ty\u0011+^3ssB\u000b'/Y7fi\u0016\u00148/\u0001\bhKR\u001cu\u000e\\;n]:\u000bW.Z:\u0015\r\u0005e\u0012qIA&!\u0015\tY$!\u0012t\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013!C5n[V$\u0018M\u00197f\u0015\r\t\u0019EI\u0001\u000bG>dG.Z2uS>t\u0017b\u00012\u0002>!1\u0011\u0011\n\u0006A\u00025\fqaY8mk6t7\u000f\u0003\u0004\u0002N)\u0001\ra]\u0001\u0010aJLW.\u0019:z\u0017\u0016Lh)[3mI\u0006!a-\u001b8e)\u0019\t\u0019&a\u0017\u0002^A!1KVA+!\u0015\t\u0013qKA\u000b\u0013\r\tIF\t\u0002\u0007\u001fB$\u0018n\u001c8\t\u000bI\\\u0001\u0019A:\t\r\u0005}3\u00021\u0001t\u0003=\u0001(/[7bef\\U-\u001f,bYV,\u0017AB2sK\u0006$X\r\u0006\u0004\u0002f\u00055\u0014q\u000e\t\u0005'Z\u000b9\u0007E\u0002\"\u0003SJ1!a\u001b#\u0005\u0011)f.\u001b;\t\u000bId\u0001\u0019A:\t\u000f\u0005ED\u00021\u0001\u0002t\u0005!!m\u001c3z!\u0015!\u0018QO:t\u0013\r\t9H\u001f\u0002\u0004\u001b\u0006\u0004\u0018AB;qI\u0006$X\r\u0006\u0005\u0002f\u0005u\u0014qPAA\u0011\u0015\u0011X\u00021\u0001t\u0011\u0019\ty&\u0004a\u0001g\"9\u0011\u0011O\u0007A\u0002\u0005M\u0014A\u00023fY\u0016$X\r\u0006\u0004\u0002f\u0005\u001d\u0015\u0011\u0012\u0005\u0006e:\u0001\ra\u001d\u0005\u0007\u0003?r\u0001\u0019A:\u0002\u001f9,XNY3s\u001f\u001a\u0014VmY8sIN$B!a$\u0002\u0018B!1KVAI!\r\t\u00131S\u0005\u0004\u0003+\u0013#aA%oi\")!o\u0004a\u0001g\u0006aq-\u001a;J[\u0006<W\rR1uCRA\u0011QTAW\u0003_\u000b\u0019\f\u0005\u0003T-\u0006}\u0005#B\u0011\u0002X\u0005\u0005\u0006#B\u0011\u0002$\u0006\u001d\u0016bAASE\t)\u0011I\u001d:bsB\u0019\u0011%!+\n\u0007\u0005-&E\u0001\u0003CsR,\u0007bBA\u000f!\u0001\u0007\u0011q\u0004\u0005\u0007\u0003c\u0003\u0002\u0019A:\u0002\u0015\r|G.^7o\u001d\u0006lW\r\u0003\u0004\u00026B\u0001\ra]\u0001\bS6\fw-Z%e\u0001")
public class DatabaseTablesRepository {
    private final Database database;
    private final DatabaseExecutionContext ec;
    private final DataExplorerSettings tableSettings;

    public Future<List<DatabaseTable>> all() {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (List)$this.database.withConnection((Function1 & Serializable)conn -> DatabaseTablesDAO$.MODULE$.all(DatabaseTablesDAO$.MODULE$.all$default$1(), (Connection)conn)), (ExecutionContext)this.ec);
    }

    public Future<List<TableColumn>> getTableColumns(String tableName) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (List)$this.database.withConnection((Function1 & Serializable)conn -> DatabaseTablesDAO$.MODULE$.getTableColumns(tableName, (Connection)conn)), (ExecutionContext)this.ec);
    }

    public Future<List<ForeignKey>> getForeignKeys(String tableName) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (List)$this.database.withConnection((Function1 & Serializable)conn -> DatabaseTablesDAO$.MODULE$.getForeignKeys(tableName, (Connection)conn)), (ExecutionContext)this.ec);
    }

    public Future<List<TableColumn>> getMandatoryFields(String tableName) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (List)$this.database.withConnection((Function1 & Serializable)conn -> {
            String primaryKeyField = $this.tableSettings.unsafeFindByName(tableName).primaryKeyField();
            return DatabaseTablesDAO$.MODULE$.getMandatoryFields(tableName, primaryKeyField, (Connection)conn);
        }), (ExecutionContext)this.ec);
    }

    public Future<List<TableData>> getTableMetadata(TableSettings settings, QueryParameters queryParameters) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (List)$this.database.withTransaction((Function1 & Serializable)conn -> {
            List<TableColumn> columns = DatabaseTablesDAO$.MODULE$.getTableColumns(settings.tableName(), (Connection)conn);
            List<TableRow> rows = DatabaseTablesDAO$.MODULE$.getTableData(settings, columns, queryParameters, $this.tableSettings.baseUrl(), (Connection)conn);
            List<String> columnNames = this.getColumnNames(columns, settings.primaryKeyField());
            return rows.map((Function1 & Serializable)row -> {
                Map<String, String> tableRow = row.convertToMap(columnNames);
                return new TableData(tableRow);
            });
        }), (ExecutionContext)this.ec);
    }

    private List<String> getColumnNames(List<TableColumn> columns, String primaryKeyField) {
        List columnNames = columns.map((Function1 & Serializable)x$1 -> x$1.name());
        return columnNames.updated(columnNames.indexOf((Object)primaryKeyField), (Object)"id");
    }

    public Future<Option<TableData>> find(String tableName, String primaryKeyValue) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (Option)$this.database.withTransaction((Function1 & Serializable)conn -> {
            TableSettings settings = $this.tableSettings.unsafeFindByName(tableName);
            List<TableColumn> columns = DatabaseTablesDAO$.MODULE$.getTableColumns(tableName, (Connection)conn);
            Option<TableRow> maybe = DatabaseTablesDAO$.MODULE$.find(settings, columns, primaryKeyValue, $this.tableSettings.baseUrl(), (Connection)conn);
            List<String> columnNames = this.getColumnNames(columns, settings.primaryKeyField());
            return maybe.map((Function1 & Serializable)x -> new TableData(x.convertToMap(columnNames)));
        }), (ExecutionContext)this.ec);
    }

    public Future<BoxedUnit> create(String tableName, Map<String, String> body) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.database.withConnection((Function1 & Serializable)conn -> {
            DatabaseTablesRepository.$anonfun$create$2(this, tableName, body, conn);
            return BoxedUnit.UNIT;
        }), (ExecutionContext)this.ec);
    }

    public Future<BoxedUnit> update(String tableName, String primaryKeyValue, Map<String, String> body) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.database.withTransaction((Function1 & Serializable)conn -> {
            DatabaseTablesRepository.$anonfun$update$2(this, tableName, body, primaryKeyValue, conn);
            return BoxedUnit.UNIT;
        }), (ExecutionContext)this.ec);
    }

    public Future<BoxedUnit> delete(String tableName, String primaryKeyValue) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.database.withConnection((Function1 & Serializable)conn -> {
            DatabaseTablesRepository.$anonfun$delete$2(this, tableName, primaryKeyValue, conn);
            return BoxedUnit.UNIT;
        }), (ExecutionContext)this.ec);
    }

    public Future<Object> numberOfRecords(String tableName) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.database.withConnection((Function1 & Serializable)conn -> BoxesRunTime.boxToInteger((int)DatabaseTablesDAO$.MODULE$.countRecordsOnTable(tableName, conn)))), (ExecutionContext)this.ec);
    }

    public Future<Option<byte[]>> getImageData(TableSettings settings, String columnName, String imageId) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (Option)$this.database.withConnection((Function1 & Serializable)conn -> DatabaseTablesDAO$.MODULE$.getImageData(settings, columnName, imageId, (Connection)conn)), (ExecutionContext)this.ec);
    }

    public static final /* synthetic */ void $anonfun$create$2(DatabaseTablesRepository $this, String tableName$5, Map body$1, Connection conn) {
        String primaryKeyField = $this.tableSettings.unsafeFindByName(tableName$5).primaryKeyField();
        PrimaryKeyDataType primaryKeyType = $this.tableSettings.unsafeFindByName(tableName$5).primaryKeyDataType();
        DatabaseTablesDAO$.MODULE$.create(tableName$5, (Map<String, String>)body$1, primaryKeyField, primaryKeyType, conn);
    }

    public static final /* synthetic */ boolean $anonfun$update$3(TableSettings settings$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = settings$2.nonEditableColumns().contains((Object)key);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$update$5(String key$1, TableColumn x$2) {
        String string = x$2.name();
        String string2 = key$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$update$2(DatabaseTablesRepository $this, String tableName$6, Map body$2, String primaryKeyValue$2, Connection conn) {
        TableSettings settings = $this.tableSettings.unsafeFindByName(tableName$6);
        List<TableColumn> columns = DatabaseTablesDAO$.MODULE$.getTableColumns(tableName$6, conn);
        Map bodyWithoutNonEditableColumns = (Map)body$2.filterNot((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DatabaseTablesRepository.$anonfun$update$3(settings, x0$1)));
        Map fieldsAndValues = (Map)bodyWithoutNonEditableColumns.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            TableColumn field = (TableColumn)columns.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DatabaseTablesRepository.$anonfun$update$5(key, x$2))).getOrElse((Function0 & Serializable)() -> {
                throw new RuntimeException(new StringBuilder(34).append("Invalid property in body request: ").append(key).toString());
            });
            Tuple2 tuple22 = new Tuple2((Object)field, (Object)value);
            return tuple22;
        });
        PrimaryKeyDataType primaryKeyType = settings.primaryKeyDataType();
        DatabaseTablesDAO$.MODULE$.update(tableName$6, (Map<TableColumn, String>)fieldsAndValues, settings.primaryKeyField(), primaryKeyValue$2, primaryKeyType, conn);
    }

    public static final /* synthetic */ void $anonfun$delete$2(DatabaseTablesRepository $this, String tableName$7, String primaryKeyValue$3, Connection conn) {
        String primaryKeyField = $this.tableSettings.unsafeFindByName(tableName$7).primaryKeyField();
        PrimaryKeyDataType primaryKeyType = $this.tableSettings.unsafeFindByName(tableName$7).primaryKeyDataType();
        DatabaseTablesDAO$.MODULE$.delete(tableName$7, primaryKeyField, primaryKeyValue$3, primaryKeyType, conn);
    }

    @Inject
    public DatabaseTablesRepository(Database database, DatabaseExecutionContext ec, DataExplorerSettings tableSettings) {
        this.database = database;
        this.ec = ec;
        this.tableSettings = tableSettings;
    }
}

