/*
 * Decompiled with CFR 0.152.
 */
package net.wiringbits.webapp.utils.admin.tasks;

import java.io.Serializable;
import java.sql.Connection;
import javax.inject.Inject;
import net.wiringbits.webapp.utils.admin.config.DataExplorerSettings;
import net.wiringbits.webapp.utils.admin.config.TableSettings;
import net.wiringbits.webapp.utils.admin.repositories.daos.DatabaseTablesDAO$;
import net.wiringbits.webapp.utils.admin.repositories.models.DatabaseTable;
import net.wiringbits.webapp.utils.admin.repositories.models.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.db.Database;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ub\u0001\u0002\b\u0010\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\t]\u0001\u0011\t\u0011)A\u0005_!)Q\u0007\u0001C\u0001m!9A\t\u0001b\u0001\n\u0013)\u0005B\u0002(\u0001A\u0003%a\tC\u0003P\u0001\u0011\u0005\u0001\u000bC\u0003U\u0001\u0011%\u0001\u000bC\u0003V\u0001\u0011%a\u000bC\u0003x\u0001\u0011%\u0001\u0010C\u0004\u0002\u0004\u0001!I!!\u0002\t\u000f\u0005=\u0001\u0001\"\u0003\u0002\u0012!9\u0011q\u0004\u0001\u0005\n\u0005\u0005\u0002bBA\u0015\u0001\u0011%\u00111\u0006\u0002 \t\u0006$\u0018-\u0012=qY>\u0014XM]\"p]\u001aLwMV1mS\u0012\fGo\u001c:UCN\\'B\u0001\t\u0012\u0003\u0015!\u0018m]6t\u0015\t\u00112#A\u0003bI6LgN\u0003\u0002\u0015+\u0005)Q\u000f^5mg*\u0011acF\u0001\u0007o\u0016\u0014\u0017\r\u001d9\u000b\u0005aI\u0012AC<je&twMY5ug*\t!$A\u0002oKR\u001c\u0001a\u0005\u0002\u0001;A\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1\u0011I\\=SK\u001a\f\u0001\u0002Z1uC\n\f7/\u001a\t\u0003K1j\u0011A\n\u0006\u0003O!\n!\u0001\u001a2\u000b\u0005%R\u0013aA1qS*\t1&\u0001\u0003qY\u0006L\u0018BA\u0017'\u0005!!\u0015\r^1cCN,\u0017\u0001C:fiRLgnZ:\u0011\u0005A\u001aT\"A\u0019\u000b\u0005I\n\u0012AB2p]\u001aLw-\u0003\u00025c\t!B)\u0019;b\u000bb\u0004Hn\u001c:feN+G\u000f^5oON\fa\u0001P5oSRtDcA\u001c:uA\u0011\u0001\bA\u0007\u0002\u001f!)1e\u0001a\u0001I!)af\u0001a\u0001_!\u00121\u0001\u0010\t\u0003{\tk\u0011A\u0010\u0006\u0003\u007f\u0001\u000ba!\u001b8kK\u000e$(\"A!\u0002\u000b)\fg/\u0019=\n\u0005\rs$AB%oU\u0016\u001cG/\u0001\u0004m_\u001e<WM]\u000b\u0002\rB\u0011q\tT\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0006g24GG\u001b\u0006\u0002\u0017\u0006\u0019qN]4\n\u00055C%A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u000bM$\u0018M\u001d;\u0015\u0003E\u0003\"A\b*\n\u0005M{\"\u0001B+oSR\f1A];o\u0003E1\u0018\r\\5eCR,G+\u00192mK:\u000bW.\u001a\u000b\u0004#^#\u0007\"\u0002-\t\u0001\u0004I\u0016!\u0003;bE2,g*Y7f!\tQ\u0016M\u0004\u0002\\?B\u0011AlH\u0007\u0002;*\u0011alG\u0001\u0007yI|w\u000e\u001e \n\u0005\u0001|\u0012A\u0002)sK\u0012,g-\u0003\u0002cG\n11\u000b\u001e:j]\u001eT!\u0001Y\u0010\t\u000b\u0015D\u0001\u0019\u00014\u0002\u0015Q\f'\r\\3t\u0013:$%\tE\u0002hY>t!\u0001\u001b6\u000f\u0005qK\u0017\"\u0001\u0011\n\u0005-|\u0012a\u00029bG.\fw-Z\u0005\u0003[:\u0014A\u0001T5ti*\u00111n\b\t\u0003aVl\u0011!\u001d\u0006\u0003eN\fa!\\8eK2\u001c(B\u0001;\u0012\u00031\u0011X\r]8tSR|'/[3t\u0013\t1\u0018OA\u0007ECR\f'-Y:f)\u0006\u0014G.Z\u0001\u001cm\u0006d\u0017\u000eZ1uKB\u0013\u0018.\\1ss.+\u0017PR5fY\u0012t\u0015-\\3\u0015\u0007EK8\u0010C\u0003{\u0013\u0001\u0007\u0011,A\u0006jI\u001aKW\r\u001c3OC6,\u0007\"\u0002?\n\u0001\u0004i\u0018A\u00024jK2$7\u000fE\u0002hYz\u0004\"\u0001]@\n\u0007\u0005\u0005\u0011OA\u0006UC\ndWmQ8mk6t\u0017!\u0006<bY&$\u0017\r^3IS\u0012$WM\\\"pYVlgn\u001d\u000b\u0006#\u0006\u001d\u0011Q\u0002\u0005\b\u0003\u0013Q\u0001\u0019AA\u0006\u0003\u001d\u0019w\u000e\\;n]N\u00042a\u001a7Z\u0011\u0015a(\u00021\u0001~\u0003Y1\u0018\r\\5eCR,'+\u001a4fe\u0016t7-\u001a$jK2$G#B)\u0002\u0014\u0005u\u0001bBA\u000b\u0017\u0001\u0007\u0011qC\u0001\u0006[\u0006L(-\u001a\t\u0005=\u0005e\u0011,C\u0002\u0002\u001c}\u0011aa\u00149uS>t\u0007\"\u0002?\f\u0001\u0004i\u0018A\u0007<bY&$\u0017\r^3O_:,E-\u001b;bE2,7i\u001c7v[:\u001cH#B)\u0002$\u0005\u0015\u0002bBA\u0005\u0019\u0001\u0007\u00111\u0002\u0005\u0007\u0003Oa\u0001\u0019A?\u0002\u0017Q\f'\r\\3GS\u0016dGm]\u0001\u0011m\u0006d\u0017\u000eZ1uKN+G\u000f^5oON$2!UA\u0017\u0011\u0019qS\u00021\u0001\u00020A\u0019\u0001'!\r\n\u0007\u0005M\u0012GA\u0007UC\ndWmU3ui&twm\u001d")
public class DataExplorerConfigValidatorTask {
    private final Database database;
    private final DataExplorerSettings settings;
    private final Logger logger;

    private Logger logger() {
        return this.logger;
    }

    public void start() {
        this.logger().info("Running task");
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.run());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.logger().error("Data explorer settings validation failed", exception);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            this.logger().info("Data explorer settings validated");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    private void run() {
        this.database.withConnection((Function1 & Serializable)conn -> {
            DataExplorerConfigValidatorTask.$anonfun$run$1(this, conn);
            return BoxedUnit.UNIT;
        });
    }

    private void validateTableName(String tableName, List<DatabaseTable> tablesInDB) {
        if (!tablesInDB.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DataExplorerConfigValidatorTask.$anonfun$validateTableName$1(tableName, x$1)))) {
            throw new RuntimeException(new StringBuilder(31).append(tableName).append(" not found, available tables = ").append(tablesInDB.mkString(", ")).toString());
        }
    }

    private void validatePrimaryKeyFieldName(String idFieldName, List<TableColumn> fields) {
        boolean exists = fields.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DataExplorerConfigValidatorTask.$anonfun$validatePrimaryKeyFieldName$1(idFieldName, x$2)));
        if (!exists) {
            throw new RuntimeException(new StringBuilder(57).append("The provided id on DataExplorer settings doesn't exists: ").append(idFieldName).toString());
        }
    }

    private void validateHiddenColumns(List<String> columns, List<TableColumn> fields) {
        List fieldNames = fields.map((Function1 & Serializable)x$3 -> x$3.name());
        boolean isValid = columns.forall((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)fieldNames.contains(elem)));
        if (!isValid) {
            throw new RuntimeException(new StringBuilder(69).append("The provided hidden columns on DataExplorer settings doesn't exists: ").append(columns).toString());
        }
    }

    private void validateReferenceField(Option<String> maybe, List<TableColumn> fields) {
        maybe.foreach((Function1 & Serializable)field -> {
            DataExplorerConfigValidatorTask.$anonfun$validateReferenceField$1(fields, field);
            return BoxedUnit.UNIT;
        });
    }

    private void validateNonEditableColumns(List<String> columns, List<TableColumn> tableFields) {
        List fieldNames = tableFields.map((Function1 & Serializable)x$5 -> x$5.name());
        boolean isValid = columns.forall((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)fieldNames.contains(elem)));
        if (!isValid) {
            throw new RuntimeException(new StringBuilder(71).append("The provided disabled columns on DataExplorer settings doesn't exists: ").append(columns).toString());
        }
    }

    private void validateSettings(TableSettings settings) {
        if (settings.referenceField().exists((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DataExplorerConfigValidatorTask.$anonfun$validateSettings$1(settings, elem)))) {
            throw new RuntimeException("Hidden columns cannot contain the reference field");
        }
    }

    public static final /* synthetic */ void $anonfun$run$2(DataExplorerConfigValidatorTask $this, Connection conn$1, List tables$1, TableSettings settingsTable) {
        $this.logger().info(new StringBuilder(10).append("Verifying ").append(settingsTable.tableName()).toString());
        List<TableColumn> fields = DatabaseTablesDAO$.MODULE$.getTableColumns(settingsTable.tableName(), conn$1);
        $this.validateSettings(settingsTable);
        $this.validateTableName(settingsTable.tableName(), (List<DatabaseTable>)tables$1);
        $this.validatePrimaryKeyFieldName(settingsTable.primaryKeyField(), fields);
        $this.validateHiddenColumns(settingsTable.hiddenColumns(), fields);
        $this.validateNonEditableColumns(settingsTable.nonEditableColumns(), fields);
        $this.validateReferenceField(settingsTable.referenceField(), fields);
    }

    public static final /* synthetic */ void $anonfun$run$1(DataExplorerConfigValidatorTask $this, Connection conn) {
        List<DatabaseTable> tables = DatabaseTablesDAO$.MODULE$.all(DatabaseTablesDAO$.MODULE$.all$default$1(), conn);
        $this.settings.tables().foreach((Function1 & Serializable)settingsTable -> {
            DataExplorerConfigValidatorTask.$anonfun$run$2($this, conn, tables, settingsTable);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$validateTableName$1(String tableName$1, DatabaseTable x$1) {
        String string = x$1.name();
        String string2 = tableName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validatePrimaryKeyFieldName$1(String idFieldName$1, TableColumn x$2) {
        String string = x$2.name();
        String string2 = idFieldName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateReferenceField$2(String field$1, TableColumn x$4) {
        String string = x$4.name();
        String string2 = field$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$validateReferenceField$1(List fields$1, String field) {
        boolean isValid = fields$1.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DataExplorerConfigValidatorTask.$anonfun$validateReferenceField$2(field, x$4)));
        if (!isValid) {
            throw new RuntimeException(new StringBuilder(77).append("The provided reference field column on DataExplorer settings doesn't exists: ").append(field).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateSettings$1(TableSettings settings$1, Object elem) {
        return settings$1.hiddenColumns().contains(elem);
    }

    @Inject
    public DataExplorerConfigValidatorTask(Database database, DataExplorerSettings settings) {
        this.database = database;
        this.settings = settings;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.start();
    }
}

