/*
 * Decompiled with CFR 0.152.
 */
package net.wiringbits.webapp.utils.admin.controllers;

import java.io.Serializable;
import javax.inject.Inject;
import net.wiringbits.webapp.utils.admin.config.DataExplorerSettings;
import net.wiringbits.webapp.utils.admin.controllers.package$;
import net.wiringbits.webapp.utils.admin.services.AdminService;
import net.wiringbits.webapp.utils.admin.utils.models.QueryParameters;
import net.wiringbits.webapp.utils.api.models.AdminCreateTable;
import net.wiringbits.webapp.utils.api.models.AdminCreateTable$;
import net.wiringbits.webapp.utils.api.models.AdminDeleteTable;
import net.wiringbits.webapp.utils.api.models.AdminDeleteTable$;
import net.wiringbits.webapp.utils.api.models.AdminGetTables$;
import net.wiringbits.webapp.utils.api.models.AdminUpdateTable;
import net.wiringbits.webapp.utils.api.models.AdminUpdateTable$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.http.Writeable$;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.mvc.AbstractController;
import play.api.mvc.Action;
import play.api.mvc.AnyContent;
import play.api.mvc.ControllerComponents;
import play.api.mvc.Request;
import play.api.mvc.Result;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.MapOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005}c\u0001B\b\u0011\u0001uA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!Ia\u0007\u0001B\u0001B\u0003-qG\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0006{!)Q\t\u0001C\u0001\r\"9q\u000b\u0001b\u0001\n\u0013A\u0006BB1\u0001A\u0003%\u0011\fC\u0003c\u0001\u0011\u00051\rC\u0003k\u0001\u0011\u00051\u000eC\u0004\u0002\u0006\u0001!\t!a\u0002\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\u0010!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0002bBA#\u0001\u0011\u0005\u0011q\t\u0005\b\u0003+\u0002A\u0011AA,\u0005=\tE-\\5o\u0007>tGO]8mY\u0016\u0014(BA\t\u0013\u0003-\u0019wN\u001c;s_2dWM]:\u000b\u0005M!\u0012!B1e[&t'BA\u000b\u0017\u0003\u0015)H/\u001b7t\u0015\t9\u0002$\u0001\u0004xK\n\f\u0007\u000f\u001d\u0006\u00033i\t!b^5sS:<'-\u001b;t\u0015\u0005Y\u0012a\u00018fi\u000e\u00011C\u0001\u0001\u001f!\tyb%D\u0001!\u0015\t\t#%A\u0002nm\u000eT!a\t\u0013\u0002\u0007\u0005\u0004\u0018NC\u0001&\u0003\u0011\u0001H.Y=\n\u0005\u001d\u0002#AE!cgR\u0014\u0018m\u0019;D_:$(o\u001c7mKJ\fA\"\u00193nS:\u001cVM\u001d<jG\u0016\u0004\"AK\u0017\u000e\u0003-R!\u0001\f\n\u0002\u0011M,'O^5dKNL!AL\u0016\u0003\u0019\u0005#W.\u001b8TKJ4\u0018nY3\u0002\u0011M,G\u000f^5oON\u0004\"!\r\u001b\u000e\u0003IR!a\r\n\u0002\r\r|gNZ5h\u0013\t)$G\u0001\u000bECR\fW\t\u001f9m_J,'oU3ui&twm]\u0001\u0003G\u000e\u0004\"a\b\u001d\n\u0005e\u0002#\u0001F\"p]R\u0014x\u000e\u001c7fe\u000e{W\u000e]8oK:$8/\u0003\u0002<M\u0005!2m\u001c8ue>dG.\u001a:D_6\u0004xN\\3oiN\f!!Z2\u0011\u0005y\u001aU\"A \u000b\u0005\u0001\u000b\u0015AC2p]\u000e,(O]3oi*\t!)A\u0003tG\u0006d\u0017-\u0003\u0002E\u007f\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u001dcU\nF\u0002I\u0015.\u0003\"!\u0013\u0001\u000e\u0003AAQAN\u0003A\u0004]BQ\u0001P\u0003A\u0004uBQ\u0001K\u0003A\u0002%BQaL\u0003A\u0002AB#!B(\u0011\u0005A+V\"A)\u000b\u0005I\u001b\u0016AB5oU\u0016\u001cGOC\u0001U\u0003\u0015Q\u0017M^1y\u0013\t1\u0016K\u0001\u0004J]*,7\r^\u0001\u0007Y><w-\u001a:\u0016\u0003e\u0003\"AW0\u000e\u0003mS!\u0001X/\u0002\u000bMdg\r\u000e6\u000b\u0003y\u000b1a\u001c:h\u0013\t\u00017L\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003%9W\r\u001e+bE2,7\u000fF\u0001e!\ryRmZ\u0005\u0003M\u0002\u0012a!Q2uS>t\u0007CA\u0010i\u0013\tI\u0007E\u0001\u0006B]f\u001cuN\u001c;f]R\f\u0001cZ3u)\u0006\u0014G.Z'fi\u0006$\u0017\r^1\u0015\u0007\u0011d\u0017\u0010C\u0003n\u0013\u0001\u0007a.A\u0005uC\ndWMT1nKB\u0011qN\u001e\b\u0003aR\u0004\"!]!\u000e\u0003IT!a\u001d\u000f\u0002\rq\u0012xn\u001c;?\u0013\t)\u0018)\u0001\u0004Qe\u0016$WMZ\u0005\u0003ob\u0014aa\u0015;sS:<'BA;B\u0011\u0015Q\u0018\u00021\u0001|\u0003-\tX/\u001a:z!\u0006\u0014\u0018-\\:\u0011\u0007q\f\t!D\u0001~\u0015\tqx0\u0001\u0004n_\u0012,Gn\u001d\u0006\u0003+II1!a\u0001~\u0005=\tV/\u001a:z!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\u0001\u00024j]\u0012$R\u0001ZA\u0005\u0003\u0017AQ!\u001c\u0006A\u00029Da!!\u0004\u000b\u0001\u0004q\u0017a\u00049sS6\f'/_&fsZ\u000bG.^3\u0015\u000b\u0011\f\t\"a\u0005\t\u000b5\\\u0001\u0019\u00018\t\u000f\u0005U1\u00021\u0001\u0002\u0018\u0005\u0001\u0002O]5nCJL8*Z=WC2,Xm\u001d\t\u0006\u00033\t\u0019C\u001c\b\u0005\u00037\tyBD\u0002r\u0003;I\u0011AQ\u0005\u0004\u0003C\t\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003K\t9C\u0001\u0003MSN$(bAA\u0011\u0003\u000611M]3bi\u0016$B!!\f\u0002DA!q$ZA\u0018!\u0011\t\t$!\u0010\u000f\t\u0005M\u0012\u0011H\u0007\u0003\u0003kQ1A`A\u001c\u0015\t\u0019C#\u0003\u0003\u0002<\u0005U\u0012\u0001E!e[&t7I]3bi\u0016$\u0016M\u00197f\u0013\u0011\ty$!\u0011\u0003\u000fI+\u0017/^3ti*!\u00111HA\u001b\u0011\u0015iG\u00021\u0001o\u0003\u0019)\b\u000fZ1uKR1\u0011\u0011JA)\u0003'\u0002BaH3\u0002LA)q.!\u0014o]&\u0019\u0011q\n=\u0003\u00075\u000b\u0007\u000fC\u0003n\u001b\u0001\u0007a\u000e\u0003\u0004\u0002\u000e5\u0001\rA\\\u0001\u0007I\u0016dW\r^3\u0015\u000b\u0011\fI&a\u0017\t\u000b5t\u0001\u0019\u00018\t\r\u0005uc\u00021\u0001o\u0003\tIG\r")
public class AdminController
extends AbstractController {
    private final AdminService adminService;
    private final DataExplorerSettings settings;
    private final ExecutionContext ec;
    private final Logger logger;

    private Logger logger() {
        return this.logger;
    }

    public Action<AnyContent> getTables() {
        return package$.MODULE$.handleGET((Function1<Request<AnyContent>, Future<Result>>)(Function1 & Serializable)request -> package$.MODULE$.adminUser((Request<?>)request).map((Function1 & Serializable)x$1 -> {
            this.logger().info("Get database tables");
            BoxedUnit x$2 = BoxedUnit.UNIT;
            return new Tuple2(x$1, (Object)x$2);
        }, $this.ec).flatMap((Function1 & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Future future = $this.adminService.tables().map((Function1 & Serializable)response -> this.Ok().apply((Object)Json$.MODULE$.toJson(response, (Writes)AdminGetTables$.MODULE$.adminGetTablesResponseFormat()), Writeable$.MODULE$.writeableOf_JsValue()), $this.ec);
            return future;
        }, $this.ec), super.controllerComponents(), this.ec);
    }

    public Action<AnyContent> getTableMetadata(String tableName, QueryParameters queryParams) {
        return package$.MODULE$.handleGET((Function1<Request<AnyContent>, Future<Result>>)(Function1 & Serializable)request -> package$.MODULE$.adminUser((Request<?>)request).map((Function1 & Serializable)x$4 -> {
            this.logger().info(new StringBuilder(31).append("Get metadata for ").append(tableName).append(", parameters: ").append(queryParams).toString());
            BoxedUnit x$5 = BoxedUnit.UNIT;
            return new Tuple2(x$4, (Object)x$5);
        }, $this.ec).flatMap((Function1 & Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Future future = $this.adminService.tableMetadata(tableName, queryParams).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AdminController.$anonfun$getTableMetadata$4(check$ifrefutable$1)), $this.ec).map((Function1 & Serializable)x$6 -> {
                Tuple2 tuple2 = x$6;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                List response = (List)tuple2._1();
                String contentRange = (String)tuple2._2();
                Result result = this.Ok().apply((Object)Json$.MODULE$.toJson((Object)response, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.genericMapWrites((Writes)Writes$.MODULE$.StringWrites()))), Writeable$.MODULE$.writeableOf_JsValue()).withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Access-Control-Expose-Headers", (Object)"Content-Range"), new Tuple2((Object)"Content-Range", (Object)contentRange)}));
                return result;
            }, $this.ec);
            return future;
        }, $this.ec), super.controllerComponents(), this.ec);
    }

    public Action<AnyContent> find(String tableName, String primaryKeyValue) {
        return package$.MODULE$.handleGET((Function1<Request<AnyContent>, Future<Result>>)(Function1 & Serializable)request -> package$.MODULE$.adminUser((Request<?>)request).map((Function1 & Serializable)x$8 -> {
            this.logger().info(new StringBuilder(34).append("Get data from ").append(tableName).append(" where primaryKey = ").append(primaryKeyValue).toString());
            BoxedUnit x$9 = BoxedUnit.UNIT;
            return new Tuple2(x$8, (Object)x$9);
        }, $this.ec).flatMap((Function1 & Serializable)x$10 -> {
            Tuple2 tuple2 = x$10;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Future future = $this.adminService.find(tableName, primaryKeyValue).map((Function1 & Serializable)response -> this.Ok().apply((Object)Json$.MODULE$.toJson(response, (Writes)Writes$.MODULE$.genericMapWrites((Writes)Writes$.MODULE$.StringWrites())), Writeable$.MODULE$.writeableOf_JsValue()), $this.ec);
            return future;
        }, $this.ec), super.controllerComponents(), this.ec);
    }

    public Action<AnyContent> find(String tableName, List<String> primaryKeyValues) {
        return package$.MODULE$.handleGET((Function1<Request<AnyContent>, Future<Result>>)(Function1 & Serializable)request -> package$.MODULE$.adminUser((Request<?>)request).map((Function1 & Serializable)x$11 -> {
            this.logger().info(new StringBuilder(35).append("Get data from ").append(tableName).append(" where primaryKeys = ").append(primaryKeyValues.mkString(",")).toString());
            BoxedUnit x$12 = BoxedUnit.UNIT;
            return new Tuple2(x$11, (Object)x$12);
        }, $this.ec).flatMap((Function1 & Serializable)x$13 -> {
            Tuple2 tuple2 = x$13;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Future future = $this.adminService.find(tableName, primaryKeyValues).map((Function1 & Serializable)response -> this.Ok().apply((Object)Json$.MODULE$.toJson(response, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.genericMapWrites((Writes)Writes$.MODULE$.StringWrites()))), Writeable$.MODULE$.writeableOf_JsValue()), $this.ec);
            return future;
        }, $this.ec), super.controllerComponents(), this.ec);
    }

    public Action<AdminCreateTable.Request> create(String tableName) {
        return package$.MODULE$.handleJsonBody((Function1 & Serializable)request -> {
            AdminCreateTable.Request body = (AdminCreateTable.Request)request.body();
            return package$.MODULE$.adminUser((Request<?>)request).map((Function1 & Serializable)x$14 -> {
                this.logger().info(new StringBuilder(16).append("Create row in ").append(tableName).append(": ").append(body.data()).toString());
                BoxedUnit x$15 = BoxedUnit.UNIT;
                return new Tuple2(x$14, (Object)x$15);
            }, $this.ec).flatMap((Function1 & Serializable)x$18 -> {
                Tuple2 tuple2 = x$18;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Future future = $this.adminService.create(tableName, body).map((Function1 & Serializable)x$16 -> {
                    AdminCreateTable.Response response = new AdminCreateTable.Response(AdminCreateTable.Response$.MODULE$.apply$default$1());
                    return new Tuple2(x$16, (Object)response);
                }, $this.ec).map((Function1 & Serializable)x$17 -> {
                    Tuple2 tuple2 = x$17;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    AdminCreateTable.Response response = (AdminCreateTable.Response)tuple2._2();
                    Result result = this.Ok().apply((Object)Json$.MODULE$.toJson((Object)response, (Writes)AdminCreateTable$.MODULE$.adminCreateTableResponseFormat()), Writeable$.MODULE$.writeableOf_JsValue());
                    return result;
                }, $this.ec);
                return future;
            }, $this.ec);
        }, AdminCreateTable$.MODULE$.adminCreateTableRequestFormat(), super.controllerComponents(), this.ec);
    }

    public Action<Map<String, String>> update(String tableName, String primaryKeyValue) {
        return package$.MODULE$.handleJsonBody((Function1 & Serializable)request -> {
            String primaryKeyFieldName = $this.settings.unsafeFindByName(tableName).primaryKeyField();
            Map body = (Map)((MapOps)request.body()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) return tuple2;
                String string = (String)tuple2._1();
                String value = (String)tuple2._2();
                if (!"id".equals(string)) return tuple2;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)primaryKeyFieldName), (Object)value);
            });
            return package$.MODULE$.adminUser((Request<?>)request).map((Function1 & Serializable)x$19 -> {
                this.logger().info(new StringBuilder(45).append("Update row from ").append(tableName).append(" where primaryKey = ").append(primaryKeyValue).append(", body = ").append(body).toString());
                BoxedUnit x$20 = BoxedUnit.UNIT;
                return new Tuple2(x$19, (Object)x$20);
            }, $this.ec).flatMap((Function1 & Serializable)x$23 -> {
                Tuple2 tuple2 = x$23;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Future future = $this.adminService.update(tableName, primaryKeyValue, (Map<String, String>)body).map((Function1 & Serializable)x$21 -> {
                    AdminUpdateTable.Response response = new AdminUpdateTable.Response(primaryKeyValue);
                    return new Tuple2(x$21, (Object)response);
                }, $this.ec).map((Function1 & Serializable)x$22 -> {
                    Tuple2 tuple2 = x$22;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    AdminUpdateTable.Response response = (AdminUpdateTable.Response)tuple2._2();
                    Result result = this.Ok().apply((Object)Json$.MODULE$.toJson((Object)response, (Writes)AdminUpdateTable$.MODULE$.adminUpdateTableResponseFormat()), Writeable$.MODULE$.writeableOf_JsValue());
                    return result;
                }, $this.ec);
                return future;
            }, $this.ec);
        }, Reads$.MODULE$.mapReads((Reads)Reads$.MODULE$.StringReads()), super.controllerComponents(), this.ec);
    }

    public Action<AnyContent> delete(String tableName, String id) {
        return package$.MODULE$.handleGET((Function1<Request<AnyContent>, Future<Result>>)(Function1 & Serializable)request -> package$.MODULE$.adminUser((Request<?>)request).map((Function1 & Serializable)x$24 -> {
            this.logger().info(new StringBuilder(23).append("Delete row from ").append(tableName).append(", id = ").append(id).toString());
            BoxedUnit x$25 = BoxedUnit.UNIT;
            return new Tuple2(x$24, (Object)x$25);
        }, $this.ec).flatMap((Function1 & Serializable)x$28 -> {
            Tuple2 tuple2 = x$28;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Future future = $this.adminService.delete(tableName, id).map((Function1 & Serializable)x$26 -> {
                AdminDeleteTable.Response response = new AdminDeleteTable.Response(AdminDeleteTable.Response$.MODULE$.apply$default$1());
                return new Tuple2(x$26, (Object)response);
            }, $this.ec).map((Function1 & Serializable)x$27 -> {
                Tuple2 tuple2 = x$27;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                AdminDeleteTable.Response response = (AdminDeleteTable.Response)tuple2._2();
                Result result = this.Ok().apply((Object)Json$.MODULE$.toJson((Object)response, (Writes)AdminDeleteTable$.MODULE$.adminDeleteTableResponseFormat()), Writeable$.MODULE$.writeableOf_JsValue());
                return result;
            }, $this.ec);
            return future;
        }, $this.ec), super.controllerComponents(), this.ec);
    }

    public static final /* synthetic */ boolean $anonfun$getTableMetadata$4(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    @Inject
    public AdminController(AdminService adminService, DataExplorerSettings settings, ControllerComponents cc, ExecutionContext ec) {
        this.adminService = adminService;
        this.settings = settings;
        this.ec = ec;
        super(cc);
        this.logger = LoggerFactory.getLogger((Class)this.getClass());
    }
}

