/*
 * Decompiled with CFR 0.152.
 */
package net.wiringbits.webapp.utils.admin.repositories;

import java.io.Serializable;
import java.sql.Connection;
import javax.inject.Inject;
import net.wiringbits.webapp.utils.admin.config.DataExplorerSettings;
import net.wiringbits.webapp.utils.admin.config.TableSettings;
import net.wiringbits.webapp.utils.admin.executors.DatabaseExecutionContext;
import net.wiringbits.webapp.utils.admin.repositories.daos.DatabaseTablesDAO$;
import net.wiringbits.webapp.utils.admin.repositories.models.DatabaseTable;
import net.wiringbits.webapp.utils.admin.repositories.models.ForeignKey;
import net.wiringbits.webapp.utils.admin.repositories.models.TableColumn;
import net.wiringbits.webapp.utils.admin.repositories.models.TableData;
import net.wiringbits.webapp.utils.admin.repositories.models.TableRow;
import net.wiringbits.webapp.utils.admin.utils.models.QueryParameters;
import play.api.db.Database;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005=e\u0001\u0002\t\u0012\u0001yA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\ta\u0001\u0011\t\u0011)A\u0006c!Aq\u0007\u0001B\u0001B\u0003-\u0001\bC\u0003?\u0001\u0011\u0005q\bC\u0003P\u0001\u0011\u0005\u0001\u000bC\u0003j\u0001\u0011\u0005!\u000eC\u0003{\u0001\u0011\u00051\u0010C\u0004\u0002\u0006\u0001!\t!a\u0002\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e!9\u00111\u0006\u0001\u0005\n\u00055\u0002bBA#\u0001\u0011\u0005\u0011q\t\u0005\b\u0003/\u0002A\u0011AA-\u0011\u001d\ty\u0007\u0001C\u0001\u0003cBq!!\u001f\u0001\t\u0003\tY\bC\u0004\u0002\u0002\u0002!\t!a!\u00031\u0011\u000bG/\u00192bg\u0016$\u0016M\u00197fgJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u0013'\u0005a!/\u001a9pg&$xN]5fg*\u0011A#F\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003-]\tQ!\u001e;jYNT!\u0001G\r\u0002\r],'-\u00199q\u0015\tQ2$\u0001\u0006xSJLgn\u001a2jiNT\u0011\u0001H\u0001\u0004]\u0016$8\u0001A\n\u0003\u0001}\u0001\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0017\u0001\u00033bi\u0006\u0014\u0017m]3\u0011\u0005\u001drS\"\u0001\u0015\u000b\u0005%R\u0013A\u00013c\u0015\tYC&A\u0002ba&T\u0011!L\u0001\u0005a2\f\u00170\u0003\u00020Q\tAA)\u0019;bE\u0006\u001cX-\u0001\u0002fGB\u0011!'N\u0007\u0002g)\u0011AgE\u0001\nKb,7-\u001e;peNL!AN\u001a\u00031\u0011\u000bG/\u00192bg\u0016,\u00050Z2vi&|gnQ8oi\u0016DH/A\u0007uC\ndWmU3ui&twm\u001d\t\u0003sqj\u0011A\u000f\u0006\u0003wM\taaY8oM&<\u0017BA\u001f;\u0005Q!\u0015\r^1FqBdwN]3s'\u0016$H/\u001b8hg\u00061A(\u001b8jiz\"\"\u0001Q#\u0015\u0007\u0005\u001bE\t\u0005\u0002C\u00015\t\u0011\u0003C\u00031\t\u0001\u000f\u0011\u0007C\u00038\t\u0001\u000f\u0001\bC\u0003&\t\u0001\u0007a\u0005\u000b\u0002\u0005\u000fB\u0011\u0001*T\u0007\u0002\u0013*\u0011!jS\u0001\u0007S:TWm\u0019;\u000b\u00031\u000bQA[1wCbL!AT%\u0003\r%s'.Z2u\u0003\r\tG\u000e\u001c\u000b\u0002#B\u0019!+V,\u000e\u0003MS!\u0001V\u0011\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002W'\n1a)\u001e;ve\u0016\u00042\u0001\u00171d\u001d\tIfL\u0004\u0002[;6\t1L\u0003\u0002];\u00051AH]8pizJ\u0011AI\u0005\u0003?\u0006\nq\u0001]1dW\u0006<W-\u0003\u0002bE\n!A*[:u\u0015\ty\u0016\u0005\u0005\u0002eO6\tQM\u0003\u0002g#\u00051Qn\u001c3fYNL!\u0001[3\u0003\u001b\u0011\u000bG/\u00192bg\u0016$\u0016M\u00197f\u0003=9W\r\u001e+bE2,7i\u001c7v[:\u001cHCA6q!\r\u0011V\u000b\u001c\t\u00041\u0002l\u0007C\u00013o\u0013\tyWMA\u0006UC\ndWmQ8mk6t\u0007\"B9\u0007\u0001\u0004\u0011\u0018!\u0003;bE2,g*Y7f!\t\u0019xO\u0004\u0002ukB\u0011!,I\u0005\u0003m\u0006\na\u0001\u0015:fI\u00164\u0017B\u0001=z\u0005\u0019\u0019FO]5oO*\u0011a/I\u0001\u000fO\u0016$hi\u001c:fS\u001et7*Z=t)\ra\u00181\u0001\t\u0004%Vk\bc\u0001-a}B\u0011Am`\u0005\u0004\u0003\u0003)'A\u0003$pe\u0016LwM\\&fs\")\u0011o\u0002a\u0001e\u0006\u0011r-\u001a;NC:$\u0017\r^8ss\u001aKW\r\u001c3t)\rY\u0017\u0011\u0002\u0005\u0006c\"\u0001\rA]\u0001\u0011O\u0016$H+\u00192mK6+G/\u00193bi\u0006$b!a\u0004\u0002\u001a\u0005m\u0001\u0003\u0002*V\u0003#\u0001B\u0001\u00171\u0002\u0014A\u0019A-!\u0006\n\u0007\u0005]QMA\u0005UC\ndW\rR1uC\")\u0011/\u0003a\u0001e\"9\u0011QD\u0005A\u0002\u0005}\u0011aD9vKJL\b+\u0019:b[\u0016$XM]:\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1AZA\u0013\u0015\t12#\u0003\u0003\u0002*\u0005\r\"aD)vKJL\b+\u0019:b[\u0016$XM]:\u0002\u001d\u001d,GoQ8mk6tg*Y7fgR1\u0011qFA\u001f\u0003\u0003\u0002R!!\r\u0002<Il!!a\r\u000b\t\u0005U\u0012qG\u0001\nS6lW\u000f^1cY\u0016T1!!\u000f\"\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004C\u0006M\u0002BBA \u0015\u0001\u0007A.A\u0004d_2,XN\\:\t\r\u0005\r#\u00021\u0001s\u0003=\u0001(/[7bef\\U-\u001f$jK2$\u0017\u0001\u00024j]\u0012$b!!\u0013\u0002R\u0005M\u0003\u0003\u0002*V\u0003\u0017\u0002R\u0001IA'\u0003'I1!a\u0014\"\u0005\u0019y\u0005\u000f^5p]\")\u0011o\u0003a\u0001e\"1\u0011QK\u0006A\u0002I\fq\u0002\u001d:j[\u0006\u0014\u0018pS3z-\u0006dW/Z\u0001\u0007GJ,\u0017\r^3\u0015\r\u0005m\u00131MA3!\u0011\u0011V+!\u0018\u0011\u0007\u0001\ny&C\u0002\u0002b\u0005\u0012A!\u00168ji\")\u0011\u000f\u0004a\u0001e\"9\u0011q\r\u0007A\u0002\u0005%\u0014\u0001\u00022pIf\u0004Ra]A6eJL1!!\u001cz\u0005\ri\u0015\r]\u0001\u0007kB$\u0017\r^3\u0015\u0011\u0005m\u00131OA;\u0003oBQ!]\u0007A\u0002IDa!!\u0016\u000e\u0001\u0004\u0011\bbBA4\u001b\u0001\u0007\u0011\u0011N\u0001\u0007I\u0016dW\r^3\u0015\r\u0005m\u0013QPA@\u0011\u0015\th\u00021\u0001s\u0011\u0019\t)F\u0004a\u0001e\u0006ya.^7cKJ|eMU3d_J$7\u000f\u0006\u0003\u0002\u0006\u00065\u0005\u0003\u0002*V\u0003\u000f\u00032\u0001IAE\u0013\r\tY)\t\u0002\u0004\u0013:$\b\"B9\u0010\u0001\u0004\u0011\b")
public class DatabaseTablesRepository {
    private final Database database;
    private final DatabaseExecutionContext ec;
    private final DataExplorerSettings tableSettings;

    public Future<List<DatabaseTable>> all() {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (List)$this.database.withConnection((Function1 & Serializable)conn -> DatabaseTablesDAO$.MODULE$.all(DatabaseTablesDAO$.MODULE$.all$default$1(), (Connection)conn)), (ExecutionContext)this.ec);
    }

    public Future<List<TableColumn>> getTableColumns(String tableName) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (List)$this.database.withConnection((Function1 & Serializable)conn -> DatabaseTablesDAO$.MODULE$.getTableColumns(tableName, (Connection)conn)), (ExecutionContext)this.ec);
    }

    public Future<List<ForeignKey>> getForeignKeys(String tableName) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (List)$this.database.withConnection((Function1 & Serializable)conn -> DatabaseTablesDAO$.MODULE$.getForeignKeys(tableName, (Connection)conn)), (ExecutionContext)this.ec);
    }

    public Future<List<TableColumn>> getMandatoryFields(String tableName) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (List)$this.database.withConnection((Function1 & Serializable)conn -> {
            String primaryKeyField = $this.tableSettings.unsafeFindByName(tableName).primaryKeyField();
            return DatabaseTablesDAO$.MODULE$.getMandatoryFields(tableName, primaryKeyField, (Connection)conn);
        }), (ExecutionContext)this.ec);
    }

    public Future<List<TableData>> getTableMetadata(String tableName, QueryParameters queryParameters) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (List)$this.database.withTransaction((Function1 & Serializable)conn -> {
            TableSettings settings = $this.tableSettings.unsafeFindByName(tableName);
            List<TableColumn> columns = DatabaseTablesDAO$.MODULE$.getTableColumns(tableName, (Connection)conn);
            List<TableRow> rows = DatabaseTablesDAO$.MODULE$.getTableData(tableName, columns, queryParameters, settings, (Connection)conn);
            List<String> columnNames = this.getColumnNames(columns, settings.primaryKeyField());
            return rows.map((Function1 & Serializable)row -> {
                Map<String, String> tableRow = row.convertToMap(columnNames);
                return new TableData(tableRow);
            });
        }), (ExecutionContext)this.ec);
    }

    private List<String> getColumnNames(List<TableColumn> columns, String primaryKeyField) {
        List columnNames = columns.map((Function1 & Serializable)x$1 -> x$1.name());
        return columnNames.updated(columnNames.indexOf((Object)primaryKeyField), (Object)"id");
    }

    public Future<Option<TableData>> find(String tableName, String primaryKeyValue) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (Option)$this.database.withTransaction((Function1 & Serializable)conn -> {
            TableSettings settings = $this.tableSettings.unsafeFindByName(tableName);
            Option<TableRow> maybe = DatabaseTablesDAO$.MODULE$.find(tableName, settings.primaryKeyField(), primaryKeyValue, (Connection)conn);
            List<TableColumn> columns = DatabaseTablesDAO$.MODULE$.getTableColumns(tableName, (Connection)conn);
            List<String> columnNames = this.getColumnNames(columns, settings.primaryKeyField());
            return maybe.map((Function1 & Serializable)x -> new TableData(x.convertToMap(columnNames)));
        }), (ExecutionContext)this.ec);
    }

    public Future<BoxedUnit> create(String tableName, Map<String, String> body) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.database.withConnection((Function1 & Serializable)conn -> {
            DatabaseTablesRepository.$anonfun$create$2(this, tableName, body, conn);
            return BoxedUnit.UNIT;
        }), (ExecutionContext)this.ec);
    }

    public Future<BoxedUnit> update(String tableName, String primaryKeyValue, Map<String, String> body) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.database.withTransaction((Function1 & Serializable)conn -> {
            DatabaseTablesRepository.$anonfun$update$2(this, tableName, body, primaryKeyValue, conn);
            return BoxedUnit.UNIT;
        }), (ExecutionContext)this.ec);
    }

    public Future<BoxedUnit> delete(String tableName, String primaryKeyValue) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.database.withConnection((Function1 & Serializable)conn -> {
            DatabaseTablesRepository.$anonfun$delete$2(this, tableName, primaryKeyValue, conn);
            return BoxedUnit.UNIT;
        }), (ExecutionContext)this.ec);
    }

    public Future<Object> numberOfRecords(String tableName) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.database.withConnection((Function1 & Serializable)conn -> BoxesRunTime.boxToInteger((int)DatabaseTablesDAO$.MODULE$.countRecordsOnTable(tableName, conn)))), (ExecutionContext)this.ec);
    }

    public static final /* synthetic */ void $anonfun$create$2(DatabaseTablesRepository $this, String tableName$6, Map body$1, Connection conn) {
        String primaryKeyField = $this.tableSettings.unsafeFindByName(tableName$6).primaryKeyField();
        DatabaseTablesDAO$.MODULE$.create(tableName$6, (Map<String, String>)body$1, primaryKeyField, conn);
    }

    public static final /* synthetic */ boolean $anonfun$update$4(String key$1, TableColumn x$2) {
        String string = x$2.name();
        String string2 = key$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$update$2(DatabaseTablesRepository $this, String tableName$7, Map body$2, String primaryKeyValue$2, Connection conn) {
        String primaryKeyField = $this.tableSettings.unsafeFindByName(tableName$7).primaryKeyField();
        List<TableColumn> columns = DatabaseTablesDAO$.MODULE$.getTableColumns(tableName$7, conn);
        Map fieldsAndValues = (Map)body$2.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            TableColumn field = (TableColumn)columns.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DatabaseTablesRepository.$anonfun$update$4(key, x$2))).getOrElse((Function0 & Serializable)() -> {
                throw new RuntimeException(new StringBuilder(34).append("Invalid property in body request: ").append(key).toString());
            });
            Tuple2 tuple22 = new Tuple2((Object)field, (Object)value);
            return tuple22;
        });
        DatabaseTablesDAO$.MODULE$.update(tableName$7, (Map<TableColumn, String>)fieldsAndValues, primaryKeyField, primaryKeyValue$2, conn);
    }

    public static final /* synthetic */ void $anonfun$delete$2(DatabaseTablesRepository $this, String tableName$8, String primaryKeyValue$3, Connection conn) {
        String primaryKeyField = $this.tableSettings.unsafeFindByName(tableName$8).primaryKeyField();
        DatabaseTablesDAO$.MODULE$.delete(tableName$8, primaryKeyField, primaryKeyValue$3, conn);
    }

    @Inject
    public DatabaseTablesRepository(Database database, DatabaseExecutionContext ec, DataExplorerSettings tableSettings) {
        this.database = database;
        this.ec = ec;
        this.tableSettings = tableSettings;
    }
}

