/*
 * Decompiled with CFR 0.152.
 */
package net.wiringbits.webapp.utils.admin.tasks;

import java.io.Serializable;
import java.sql.Connection;
import javax.inject.Inject;
import net.wiringbits.webapp.utils.admin.config.DataExplorerSettings;
import net.wiringbits.webapp.utils.admin.config.TableSettings;
import net.wiringbits.webapp.utils.admin.repositories.daos.DatabaseTablesDAO$;
import net.wiringbits.webapp.utils.admin.repositories.models.DatabaseTable;
import net.wiringbits.webapp.utils.admin.repositories.models.TableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.db.Database;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005-a\u0001B\u0006\r\u0001eA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!)!\u0007\u0001C\u0001g!9\u0011\t\u0001b\u0001\n\u0013\u0011\u0005BB&\u0001A\u0003%1\tC\u0003M\u0001\u0011\u0005Q\nC\u0003R\u0001\u0011%Q\nC\u0003S\u0001\u0011%1\u000bC\u0003u\u0001\u0011%Q\u000fC\u0003\u007f\u0001\u0011%qPA\u0010ECR\fW\t\u001f9m_J,'oQ8oM&<g+\u00197jI\u0006$xN\u001d+bg.T!!\u0004\b\u0002\u000bQ\f7o[:\u000b\u0005=\u0001\u0012!B1e[&t'BA\t\u0013\u0003\u0015)H/\u001b7t\u0015\t\u0019B#\u0001\u0004xK\n\f\u0007\u000f\u001d\u0006\u0003+Y\t!b^5sS:<'-\u001b;t\u0015\u00059\u0012a\u00018fi\u000e\u00011C\u0001\u0001\u001b!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fM\u0006AA-\u0019;bE\u0006\u001cX\r\u0005\u0002#S5\t1E\u0003\u0002%K\u0005\u0011AM\u0019\u0006\u0003M\u001d\n1!\u00199j\u0015\u0005A\u0013\u0001\u00029mCfL!AK\u0012\u0003\u0011\u0011\u000bG/\u00192bg\u0016\f\u0001b]3ui&twm\u001d\t\u0003[Aj\u0011A\f\u0006\u0003_9\taaY8oM&<\u0017BA\u0019/\u0005Q!\u0015\r^1FqBdwN]3s'\u0016$H/\u001b8hg\u00061A(\u001b8jiz\"2\u0001\u000e\u001c8!\t)\u0004!D\u0001\r\u0011\u0015\u00013\u00011\u0001\"\u0011\u0015Y3\u00011\u0001-Q\t\u0019\u0011\b\u0005\u0002;\u007f5\t1H\u0003\u0002={\u00051\u0011N\u001c6fGRT\u0011AP\u0001\u0006U\u00064\u0018\r_\u0005\u0003\u0001n\u0012a!\u00138kK\u000e$\u0018A\u00027pO\u001e,'/F\u0001D!\t!\u0015*D\u0001F\u0015\t1u)A\u0003tY\u001a$$NC\u0001I\u0003\ry'oZ\u0005\u0003\u0015\u0016\u0013a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0006gR\f'\u000f\u001e\u000b\u0002\u001dB\u00111dT\u0005\u0003!r\u0011A!\u00168ji\u0006\u0019!/\u001e8\u0002#Y\fG.\u001b3bi\u0016$\u0016M\u00197f\u001d\u0006lW\rF\u0002O)\u0006DQ!\u0016\u0005A\u0002Y\u000b\u0011\u0002^1cY\u0016t\u0015-\\3\u0011\u0005]sfB\u0001-]!\tIF$D\u0001[\u0015\tY\u0006$\u0001\u0004=e>|GOP\u0005\u0003;r\ta\u0001\u0015:fI\u00164\u0017BA0a\u0005\u0019\u0019FO]5oO*\u0011Q\f\b\u0005\u0006E\"\u0001\raY\u0001\u000bi\u0006\u0014G.Z:J]\u0012\u0013\u0005c\u00013jY:\u0011Qm\u001a\b\u00033\u001aL\u0011!H\u0005\u0003Qr\tq\u0001]1dW\u0006<W-\u0003\u0002kW\n!A*[:u\u0015\tAG\u0004\u0005\u0002ne6\taN\u0003\u0002pa\u00061Qn\u001c3fYNT!!\u001d\b\u0002\u0019I,\u0007o\\:ji>\u0014\u0018.Z:\n\u0005Mt'!\u0004#bi\u0006\u0014\u0017m]3UC\ndW-A\u000ewC2LG-\u0019;f!JLW.\u0019:z\u0017\u0016Lh)[3mI:\u000bW.\u001a\u000b\u0004\u001dZD\b\"B<\n\u0001\u00041\u0016aC5e\r&,G\u000e\u001a(b[\u0016DQ!_\u0005A\u0002i\faAZ5fY\u0012\u001c\bc\u00013jwB\u0011Q\u000e`\u0005\u0003{:\u0014!\u0002V1cY\u00164\u0015.\u001a7e\u0003U1\u0018\r\\5eCR,\u0007*\u001b3eK:\u001cu\u000e\\;n]N$RATA\u0001\u0003\u000fAq!a\u0001\u000b\u0001\u0004\t)!A\u0004d_2,XN\\:\u0011\u0007\u0011Lg\u000b\u0003\u0004\u0002\n)\u0001\rA_\u0001\fi\u0006\u0014G.\u001a$jK2$7\u000f")
public class DataExplorerConfigValidatorTask {
    private final Database database;
    private final DataExplorerSettings settings;
    private final Logger logger;

    private Logger logger() {
        return this.logger;
    }

    public void start() {
        this.logger().info("Running task");
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.run());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.logger().error("Data explorer settings validation failed", exception);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            this.logger().info("Data explorer settings validated");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    private void run() {
        this.database.withConnection((Function1 & Serializable)conn -> {
            DataExplorerConfigValidatorTask.$anonfun$run$1(this, conn);
            return BoxedUnit.UNIT;
        });
    }

    private void validateTableName(String tableName, List<DatabaseTable> tablesInDB) {
        if (!tablesInDB.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DataExplorerConfigValidatorTask.$anonfun$validateTableName$1(tableName, x$1)))) {
            throw new RuntimeException(new StringBuilder(31).append(tableName).append(" not found, available tables = ").append(tablesInDB.mkString(", ")).toString());
        }
    }

    private void validatePrimaryKeyFieldName(String idFieldName, List<TableField> fields) {
        boolean exists = fields.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DataExplorerConfigValidatorTask.$anonfun$validatePrimaryKeyFieldName$1(idFieldName, x$2)));
        if (!exists) {
            throw new RuntimeException(new StringBuilder(57).append("The provided id on DataExplorer settings doesn't exists: ").append(idFieldName).toString());
        }
    }

    private void validateHiddenColumns(List<String> columns, List<TableField> tableFields) {
        List fieldNames = tableFields.map((Function1 & Serializable)x$3 -> x$3.name());
        boolean isValid = columns.forall((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)fieldNames.contains(elem)));
        if (!isValid) {
            throw new RuntimeException(new StringBuilder(69).append("The provided hidden columns on DataExplorer settings doesn't exists: ").append(columns).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$run$2(DataExplorerConfigValidatorTask $this, Connection conn$1, List tables$1, TableSettings settingsTable) {
        $this.logger().info(new StringBuilder(10).append("Verifying ").append(settingsTable.tableName()).toString());
        List<TableField> fields = DatabaseTablesDAO$.MODULE$.getTableFields(settingsTable.tableName(), conn$1);
        $this.validateTableName(settingsTable.tableName(), (List<DatabaseTable>)tables$1);
        $this.validatePrimaryKeyFieldName(settingsTable.primaryKeyField(), fields);
        $this.validateHiddenColumns(settingsTable.hiddenColumns(), fields);
    }

    public static final /* synthetic */ void $anonfun$run$1(DataExplorerConfigValidatorTask $this, Connection conn) {
        List<DatabaseTable> tables = DatabaseTablesDAO$.MODULE$.all(DatabaseTablesDAO$.MODULE$.all$default$1(), conn);
        $this.settings.tables().foreach((Function1 & Serializable)settingsTable -> {
            DataExplorerConfigValidatorTask.$anonfun$run$2($this, conn, tables, settingsTable);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$validateTableName$1(String tableName$1, DatabaseTable x$1) {
        String string = x$1.name();
        String string2 = tableName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validatePrimaryKeyFieldName$1(String idFieldName$1, TableField x$2) {
        String string = x$2.name();
        String string2 = idFieldName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Inject
    public DataExplorerConfigValidatorTask(Database database, DataExplorerSettings settings) {
        this.database = database;
        this.settings = settings;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.start();
    }
}

