/*
 * Decompiled with CFR 0.152.
 */
package net.wiringbits.webapp.utils.admin.services;

import java.io.Serializable;
import javax.inject.Inject;
import net.wiringbits.webapp.utils.admin.config.DataExplorerSettings;
import net.wiringbits.webapp.utils.admin.config.TableSettings;
import net.wiringbits.webapp.utils.admin.repositories.DatabaseTablesRepository;
import net.wiringbits.webapp.utils.admin.repositories.models.ForeignReference;
import net.wiringbits.webapp.utils.admin.utils.models.QueryParameters;
import net.wiringbits.webapp.utils.admin.utils.models.SortParameter;
import net.wiringbits.webapp.utils.admin.utils.package$;
import net.wiringbits.webapp.utils.admin.utils.package$MapStringHideExt$;
import net.wiringbits.webapp.utils.api.models.AdminCreateTable;
import net.wiringbits.webapp.utils.api.models.AdminGetTables;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005e\u0001B\t\u0013\u0001}A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!AA\u0007\u0001B\u0001B\u0003-Q\u0007C\u0003<\u0001\u0011\u0005A\bC\u0003M\u0001\u0011\u0005Q\nC\u0003^\u0001\u0011\u0005a\fC\u0004\u0002\n\u0001!I!a\u0003\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!9\u00111\u0004\u0001\u0005\u0002\u0005\u001d\u0002bBA\u001a\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003\u0017\u0002A\u0011BA'\u0011\u001d\t)\u0006\u0001C\u0001\u0003/Bq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002j\u0001!I!a\u001b\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r!9\u0011q\u000f\u0001\u0005\n\u0005e$\u0001D!e[&t7+\u001a:wS\u000e,'BA\n\u0015\u0003!\u0019XM\u001d<jG\u0016\u001c(BA\u000b\u0017\u0003\u0015\tG-\\5o\u0015\t9\u0002$A\u0003vi&d7O\u0003\u0002\u001a5\u00051q/\u001a2baBT!a\u0007\u000f\u0002\u0015]L'/\u001b8hE&$8OC\u0001\u001e\u0003\rqW\r^\u0002\u0001'\t\u0001\u0001\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VMZ\u0001\u0019I\u0006$\u0018MY1tKR\u000b'\r\\3t%\u0016\u0004xn]5u_JL\bC\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u0015\u00031\u0011X\r]8tSR|'/[3t\u0013\ta\u0013F\u0001\rECR\f'-Y:f)\u0006\u0014G.Z:SKB|7/\u001b;pef\fQ\u0002^1cY\u0016\u001cV\r\u001e;j]\u001e\u001c\bCA\u00183\u001b\u0005\u0001$BA\u0019\u0015\u0003\u0019\u0019wN\u001c4jO&\u00111\u0007\r\u0002\u0015\t\u0006$\u0018-\u0012=qY>\u0014XM]*fiRLgnZ:\u0002\u0005\u0015\u001c\u0007C\u0001\u001c:\u001b\u00059$B\u0001\u001d#\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003u]\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\ri\u0014I\u0011\u000b\u0003}\u0001\u0003\"a\u0010\u0001\u000e\u0003IAQ\u0001\u000e\u0003A\u0004UBQA\n\u0003A\u0002\u001dBQ!\f\u0003A\u00029B#\u0001\u0002#\u0011\u0005\u0015SU\"\u0001$\u000b\u0005\u001dC\u0015AB5oU\u0016\u001cGOC\u0001J\u0003\u0015Q\u0017M^1y\u0013\tYeI\u0001\u0004J]*,7\r^\u0001\u0007i\u0006\u0014G.Z:\u0015\u00039\u00032AN(R\u0013\t\u0001vG\u0001\u0004GkR,(/\u001a\t\u0003%js!a\u0015-\u000e\u0003QS!!\u0016,\u0002\r5|G-\u001a7t\u0015\t9f#A\u0002ba&L!!\u0017+\u0002\u001d\u0005#W.\u001b8HKR$\u0016M\u00197fg&\u00111\f\u0018\u0002\t%\u0016\u001c\bo\u001c8tK*\u0011\u0011\fV\u0001\u000ei\u0006\u0014G.Z'fi\u0006$\u0017\r^1\u0015\u0007}SH\u0010E\u00027\u001f\u0002\u0004B!I1do&\u0011!M\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007\u0011dwN\u0004\u0002fU:\u0011a-[\u0007\u0002O*\u0011\u0001NH\u0001\u0007yI|w\u000e\u001e \n\u0003\rJ!a\u001b\u0012\u0002\u000fA\f7m[1hK&\u0011QN\u001c\u0002\u0005\u0019&\u001cHO\u0003\u0002lEA!\u0001\u000f^<x\u001d\t\t(\u000f\u0005\u0002gE%\u00111OI\u0001\u0007!J,G-\u001a4\n\u0005U4(aA'ba*\u00111O\t\t\u0003abL!!\u001f<\u0003\rM#(/\u001b8h\u0011\u0015Yh\u00011\u0001x\u0003%!\u0018M\u00197f\u001d\u0006lW\rC\u0003~\r\u0001\u0007a0A\brk\u0016\u0014\u0018\u0010U1sC6,G/\u001a:t!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!VA\u0002\u0015\t9B#\u0003\u0003\u0002\b\u0005\u0005!aD)vKJL\b+\u0019:b[\u0016$XM]:\u0002/Y\fG.\u001b3bi\u0016\fV/\u001a:z!\u0006\u0014\u0018-\\3uKJ\u001cHCBA\u0007\u0003+\t9\u0002\u0005\u00037\u001f\u0006=\u0001cA\u0011\u0002\u0012%\u0019\u00111\u0003\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0006w\u001e\u0001\ra\u001e\u0005\u0007\u000339\u0001\u0019\u0001@\u0002\rA\f'/Y7t\u0003\u00111\u0017N\u001c3\u0015\r\u0005}\u0011\u0011EA\u0012!\r1tj\u001c\u0005\u0006w\"\u0001\ra\u001e\u0005\u0007\u0003KA\u0001\u0019A<\u0002\u001fA\u0014\u0018.\\1ss.+\u0017PV1mk\u0016$b!!\u000b\u0002,\u00055\u0002c\u0001\u001cPG\")10\u0003a\u0001o\"9\u0011qF\u0005A\u0002\u0005E\u0012\u0001\u00059sS6\f'/_&fsZ\u000bG.^3t!\r!Gn^\u0001\u0007GJ,\u0017\r^3\u0015\r\u00055\u0011qGA\u001d\u0011\u0015Y(\u00021\u0001x\u0011\u001d\tYD\u0003a\u0001\u0003{\tqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002@\u0005\u0015cbA*\u0002B%\u0019\u00111\t+\u0002!\u0005#W.\u001b8De\u0016\fG/\u001a+bE2,\u0017\u0002BA$\u0003\u0013\u0012qAU3rk\u0016\u001cHOC\u0002\u0002DQ\u000bQC^1mS\u0012\fG/Z'jgNLgn\u001a$jK2$7\u000f\u0006\u0004\u0002\u000e\u0005=\u0013\u0011\u000b\u0005\u0006w.\u0001\ra\u001e\u0005\u0007\u0003'Z\u0001\u0019A8\u0002\t\u0011\fG/Y\u0001\u0007kB$\u0017\r^3\u0015\u0011\u00055\u0011\u0011LA.\u0003;BQa\u001f\u0007A\u0002]Da!!\n\r\u0001\u00049\bBBA0\u0019\u0001\u0007q.\u0001\u0003c_\u0012L\u0018A\u00023fY\u0016$X\r\u0006\u0004\u0002\u000e\u0005\u0015\u0014q\r\u0005\u0006w6\u0001\ra\u001e\u0005\u0007\u0003Ki\u0001\u0019A<\u0002#Y\fG.\u001b3bi\u0016$\u0016M\u00197f\u001d\u0006lW\r\u0006\u0003\u0002\u0010\u00055\u0004\"B>\u000f\u0001\u00049\u0018a\u0005<bY&$\u0017\r^3UC\ndWMR5fY\u0012\u001cHCBA\u0007\u0003g\n)\bC\u0003|\u001f\u0001\u0007q\u000f\u0003\u0004\u0002`=\u0001\ra\\\u0001\u0013m\u0006d\u0017\u000eZ1uKR\u000b'\r\\3GS\u0016dG\r\u0006\u0004\u0002\u000e\u0005m\u0014Q\u0010\u0005\u0006wB\u0001\ra\u001e\u0005\u0007\u0003\u007f\u0002\u0002\u0019A<\u0002\u0013\u0019LW\r\u001c3OC6,\u0007")
public class AdminService {
    private final DatabaseTablesRepository databaseTablesRepository;
    private final DataExplorerSettings tableSettings;
    private final ExecutionContext ec;

    public Future<AdminGetTables.Response> tables() {
        return Future$.MODULE$.sequence((IterableOnce)this.tableSettings.tables().map((Function1 & Serializable)settings -> {
            List<String> hiddenColumns = settings.hiddenColumns();
            return $this.databaseTablesRepository.getTableFields(settings.tableName()).flatMap((Function1 & Serializable)tableFields -> $this.databaseTablesRepository.getTableReferences(settings.tableName()).map((Function1 & Serializable)tableReferences -> {
                List visibleFields = tableFields.filterNot((Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)hiddenColumns.contains((Object)field.name())));
                List fields = visibleFields.map((Function1 & Serializable)field -> {
                    String fieldName = AdminService.getFieldName$1(field.name(), settings.primaryKeyField());
                    Option reference = AdminService.getColumnReference$1(tableReferences, field.name());
                    return new AdminGetTables.Response.TableField(fieldName, field.type(), reference);
                });
                return new Tuple3(tableReferences, (Object)visibleFields, (Object)fields);
            }, $this.ec).map((Function1 & Serializable)x$3 -> {
                Tuple3 tuple3 = x$3;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                List fields = (List)tuple3._3();
                AdminGetTables.Response.DatabaseTable databaseTable = new AdminGetTables.Response.DatabaseTable(settings.tableName(), fields, settings.primaryKeyField());
                return databaseTable;
            }, $this.ec), $this.ec);
        }), BuildFrom$.MODULE$.buildFromIterableOps(), this.ec).map((Function1 & Serializable)items -> new AdminGetTables.Response(items), this.ec);
    }

    public Future<Tuple2<List<Map<String, String>>, String>> tableMetadata(String tableName, QueryParameters queryParameters) {
        this.validateTableName(tableName);
        TableSettings settings = this.tableSettings.unsafeFindByName(tableName);
        SortParameter sortParam = queryParameters.sort().fromPrimaryKeyField(settings.primaryKeyField());
        QueryParameters queryParams = queryParameters.copy(sortParam, queryParameters.copy$default$2(), queryParameters.copy$default$3());
        return this.validateQueryParameters(tableName, queryParams).flatMap((Function1 & Serializable)x$6 -> {
            BoxedUnit boxedUnit = x$6;
            Future future = $this.databaseTablesRepository.getTableMetadata(tableName, queryParams).flatMap((Function1 & Serializable)tableRows -> $this.databaseTablesRepository.numberOfRecords(tableName).map((Function1 & Serializable)numberOfRecords -> AdminService.$anonfun$tableMetadata$3(tableRows, settings, tableName, queryParams, BoxesRunTime.unboxToInt((Object)numberOfRecords)), $this.ec).map((Function1 & Serializable)x$5 -> {
                Tuple4 tuple4 = x$5;
                if (tuple4 == null) {
                    throw new MatchError((Object)tuple4);
                }
                List hiddenTableData = (List)tuple4._3();
                String contentRange = (String)tuple4._4();
                Tuple2 tuple2 = new Tuple2((Object)hiddenTableData, (Object)contentRange);
                return tuple2;
            }, $this.ec), $this.ec);
            return future;
        }, this.ec);
    }

    private Future<BoxedUnit> validateQueryParameters(String tableName, QueryParameters params) {
        List validOrdering = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ASC", "DESC"}));
        if (!validOrdering.contains((Object)params.sort().ordering())) {
            throw new RuntimeException("Invalid ordering parameter");
        }
        if (params.pagination().start() < 0) {
            throw new RuntimeException("You can't query a table using negative numbers");
        }
        if (params.pagination().start() > params.pagination().end()) {
            throw new RuntimeException("The start parameter can't be bigger than the end");
        }
        return this.validateTableField(tableName, params.sort().field()).map((Function1 & Serializable)x$7 -> {
            AdminService.$anonfun$validateQueryParameters$1(x$7);
            return BoxedUnit.UNIT;
        }, this.ec);
    }

    public Future<Map<String, String>> find(String tableName, String primaryKeyValue) {
        Future validations = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.validateTableName(tableName), this.ec);
        return validations.flatMap((Function1 & Serializable)x$9 -> {
            BoxedUnit boxedUnit = x$9;
            Future future = $this.databaseTablesRepository.find(tableName, primaryKeyValue).map((Function1 & Serializable)tableRow -> {
                TableSettings settings = $this.tableSettings.unsafeFindByName(tableName);
                Map<String, String> tableData = tableRow.data();
                Map<String, String> hiddenData = package$MapStringHideExt$.MODULE$.hideData$extension(package$.MODULE$.MapStringHideExt(tableData), settings.hiddenColumns());
                return new Tuple4(tableRow, (Object)settings, tableData, hiddenData);
            }, $this.ec).map((Function1 & Serializable)x$8 -> {
                Map hiddenData;
                Tuple4 tuple4 = x$8;
                if (tuple4 == null) {
                    throw new MatchError((Object)tuple4);
                }
                Map map = hiddenData = (Map)tuple4._4();
                return map;
            }, $this.ec);
            return future;
        }, this.ec);
    }

    public Future<List<Map<String, String>>> find(String tableName, List<String> primaryKeyValues) {
        Future validations = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.validateTableName(tableName), this.ec);
        return validations.flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = x$12;
            Future future = Future$.MODULE$.sequence((IterableOnce)primaryKeyValues.map((Function1 & Serializable)primaryKeyValue -> $this.databaseTablesRepository.find(tableName, (String)primaryKeyValue)), BuildFrom$.MODULE$.buildFromIterableOps(), $this.ec).map((Function1 & Serializable)tableRows -> {
                TableSettings settings = $this.tableSettings.unsafeFindByName(tableName);
                List tableData = tableRows.map((Function1 & Serializable)x$10 -> x$10.data());
                List maskedTableData = tableData.map((Function1 & Serializable)data -> package$MapStringHideExt$.MODULE$.hideData$extension(package$.MODULE$.MapStringHideExt((Map<String, String>)data), settings.hiddenColumns()));
                return new Tuple4(tableRows, (Object)settings, (Object)tableData, (Object)maskedTableData);
            }, $this.ec).map((Function1 & Serializable)x$11 -> {
                List maskedTableData;
                Tuple4 tuple4 = x$11;
                if (tuple4 == null) {
                    throw new MatchError((Object)tuple4);
                }
                List list = maskedTableData = (List)tuple4._4();
                return list;
            }, $this.ec);
            return future;
        }, this.ec);
    }

    public Future<BoxedUnit> create(String tableName, AdminCreateTable.Request request) {
        Map body = request.data();
        this.validateTableName(tableName);
        Future validations = this.validateTableFields(tableName, (Map<String, String>)body).flatMap((Function1 & Serializable)x$14 -> {
            BoxedUnit boxedUnit = x$14;
            Future future = this.validateMissingFields(tableName, (Map<String, String>)body).map((Function1 & Serializable)x$13 -> {
                AdminService.$anonfun$create$2(x$13);
                return BoxedUnit.UNIT;
            }, $this.ec);
            return future;
        }, this.ec);
        return validations.flatMap((Function1 & Serializable)x$16 -> {
            BoxedUnit boxedUnit = x$16;
            Future future = $this.databaseTablesRepository.create(tableName, (Map<String, String>)body).map((Function1 & Serializable)x$15 -> {
                AdminService.$anonfun$create$4(x$15);
                return BoxedUnit.UNIT;
            }, $this.ec);
            return future;
        }, this.ec);
    }

    private Future<BoxedUnit> validateMissingFields(String tableName, Map<String, String> data) {
        return this.databaseTablesRepository.getMandatoryFields(tableName).map((Function1 & Serializable)mandatoryFields -> {
            List mandatoryFieldNames = mandatoryFields.map((Function1 & Serializable)x$17 -> x$17.name());
            boolean missingFields = mandatoryFieldNames.forall((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)data.contains((Object)key)));
            return new Tuple3(mandatoryFields, (Object)mandatoryFieldNames, (Object)BoxesRunTime.boxToBoolean((boolean)missingFields));
        }, this.ec).map((Function1 & Serializable)x$18 -> {
            AdminService.$anonfun$validateMissingFields$4(data, x$18);
            return BoxedUnit.UNIT;
        }, this.ec);
    }

    public Future<BoxedUnit> update(String tableName, String primaryKeyValue, Map<String, String> body) {
        if (body.isEmpty()) {
            throw new RuntimeException("You need to send data");
        }
        this.validateTableName(tableName);
        Future validations = this.validateTableFields(tableName, body).map((Function1 & Serializable)x$19 -> {
            AdminService.$anonfun$update$1(x$19);
            return BoxedUnit.UNIT;
        }, this.ec);
        return validations.flatMap((Function1 & Serializable)x$21 -> {
            BoxedUnit boxedUnit = x$21;
            Future future = $this.databaseTablesRepository.update(tableName, primaryKeyValue, body).map((Function1 & Serializable)x$20 -> {
                AdminService.$anonfun$update$3(x$20);
                return BoxedUnit.UNIT;
            }, $this.ec);
            return future;
        }, this.ec);
    }

    public Future<BoxedUnit> delete(String tableName, String primaryKeyValue) {
        Future validations = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.validateTableName(tableName), this.ec);
        return validations.flatMap((Function1 & Serializable)x$23 -> {
            BoxedUnit boxedUnit = x$23;
            Future future = $this.databaseTablesRepository.delete(tableName, primaryKeyValue).map((Function1 & Serializable)x$22 -> {
                AdminService.$anonfun$delete$3(x$22);
                return BoxedUnit.UNIT;
            }, $this.ec);
            return future;
        }, this.ec);
    }

    private void validateTableName(String tableName) {
        boolean exists = this.tableSettings.tables().exists((Function1 & Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)AdminService.$anonfun$validateTableName$1(tableName, x$24)));
        if (!exists) {
            throw new RuntimeException(new StringBuilder(52).append("Unexpected error because the DB table wasn't found: ").append(tableName).toString());
        }
    }

    private Future<BoxedUnit> validateTableFields(String tableName, Map<String, String> body) {
        return this.databaseTablesRepository.getTableFields(tableName).map((Function1 & Serializable)fields -> {
            List fieldsNames = fields.map((Function1 & Serializable)x$25 -> x$25.name());
            Iterable requestFields = body.keys();
            boolean exists = requestFields.forall((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)fieldsNames.contains(elem)));
            return new Tuple4(fields, (Object)fieldsNames, (Object)requestFields, (Object)BoxesRunTime.boxToBoolean((boolean)exists));
        }, this.ec).map((Function1 & Serializable)x$26 -> {
            AdminService.$anonfun$validateTableFields$4(x$26);
            return BoxedUnit.UNIT;
        }, this.ec);
    }

    private Future<BoxedUnit> validateTableField(String tableName, String fieldName) {
        return this.databaseTablesRepository.getTableFields(tableName).map((Function1 & Serializable)fields -> {
            List fieldNames = fields.map((Function1 & Serializable)x$27 -> x$27.name());
            boolean exists = fieldNames.contains((Object)fieldName);
            return new Tuple3(fields, (Object)fieldNames, (Object)BoxesRunTime.boxToBoolean((boolean)exists));
        }, this.ec).map((Function1 & Serializable)x$28 -> {
            AdminService.$anonfun$validateTableField$3(fieldName, tableName, x$28);
            return BoxedUnit.UNIT;
        }, this.ec);
    }

    private static final String getFieldName$1(String fieldName, String primaryKeyField) {
        String string = fieldName;
        String string2 = primaryKeyField;
        boolean isPrimaryField = !(string != null ? !string.equals(string2) : string2 != null);
        return isPrimaryField ? "id" : fieldName;
    }

    public static final /* synthetic */ boolean $anonfun$tables$1(String fieldName$1, ForeignReference x$1) {
        String string = x$1.columnName();
        String string2 = fieldName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final Option getColumnReference$1(List tableReferences, String fieldName) {
        List maybe = tableReferences.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminService.$anonfun$tables$1(fieldName, x$1)));
        return maybe.map((Function1 & Serializable)x$2 -> x$2.primaryTable().replace("public.", "")).headOption();
    }

    public static final /* synthetic */ Tuple4 $anonfun$tableMetadata$3(List tableRows$1, TableSettings settings$2, String tableName$1, QueryParameters queryParams$1, int numberOfRecords) {
        List tableData = tableRows$1.map((Function1 & Serializable)x$4 -> x$4.data());
        List hiddenTableData = tableData.map((Function1 & Serializable)data -> package$MapStringHideExt$.MODULE$.hideData$extension(package$.MODULE$.MapStringHideExt((Map<String, String>)data), settings$2.hiddenColumns()));
        String contentRange = package$.MODULE$.contentRangeHeader(tableName$1, queryParams$1, numberOfRecords);
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)numberOfRecords), (Object)tableData, (Object)hiddenTableData, (Object)contentRange);
    }

    public static final /* synthetic */ void $anonfun$validateQueryParameters$1(BoxedUnit x$7) {
        BoxedUnit boxedUnit = x$7;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$create$2(BoxedUnit x$13) {
        BoxedUnit boxedUnit = x$13;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$create$4(BoxedUnit x$15) {
        BoxedUnit boxedUnit = x$15;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$validateMissingFields$4(Map data$1, Tuple3 x$18) {
        Tuple3 tuple3 = x$18;
        if (tuple3 != null) {
            List mandatoryFieldNames = (List)tuple3._2();
            boolean missingFields = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            if (!missingFields) {
                throw new RuntimeException(new StringBuilder(26).append("There are missing fields: ").append(mandatoryFieldNames.filterNot((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)data$1.contains((Object)key))).mkString(", ")).toString());
            }
        } else {
            throw new MatchError((Object)tuple3);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$update$1(BoxedUnit x$19) {
        BoxedUnit boxedUnit = x$19;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$update$3(BoxedUnit x$20) {
        BoxedUnit boxedUnit = x$20;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$delete$3(BoxedUnit x$22) {
        BoxedUnit boxedUnit = x$22;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$validateTableName$1(String tableName$7, TableSettings x$24) {
        String string = x$24.tableName();
        String string2 = tableName$7;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$validateTableFields$4(Tuple4 x$26) {
        Tuple4 tuple4 = x$26;
        if (tuple4 != null) {
            boolean exists = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
            if (!exists) {
                throw new RuntimeException("A field doesn't correspond to this table schema");
            }
        } else {
            throw new MatchError((Object)tuple4);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$validateTableField$3(String fieldName$2, String tableName$8, Tuple3 x$28) {
        Tuple3 tuple3 = x$28;
        if (tuple3 != null) {
            boolean exists = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            if (!exists) {
                throw new RuntimeException(new StringBuilder(25).append("Field ").append(fieldName$2).append(" doesn't exists in ").append(tableName$8).toString());
            }
        } else {
            throw new MatchError((Object)tuple3);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Inject
    public AdminService(DatabaseTablesRepository databaseTablesRepository, DataExplorerSettings tableSettings, ExecutionContext ec) {
        this.databaseTablesRepository = databaseTablesRepository;
        this.tableSettings = tableSettings;
        this.ec = ec;
    }
}

