/*
 * Decompiled with CFR 0.152.
 */
package net.wiringbits.webapp.utils.admin.repositories.daos;

import anorm.Column$;
import anorm.ParameterValue;
import anorm.ParameterValue$;
import anorm.SqlParser$;
import anorm.ToParameterValue$;
import anorm.ToStatement;
import anorm.ToStatement$;
import anorm.ToStatementPriority0;
import anorm.package;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.UUID;
import net.wiringbits.webapp.utils.admin.repositories.daos.package$;
import net.wiringbits.webapp.utils.admin.repositories.models.Cell;
import net.wiringbits.webapp.utils.admin.repositories.models.DatabaseTable;
import net.wiringbits.webapp.utils.admin.repositories.models.ForeignReference;
import net.wiringbits.webapp.utils.admin.repositories.models.TableField;
import net.wiringbits.webapp.utils.admin.repositories.models.TableRow;
import net.wiringbits.webapp.utils.admin.utils.QueryBuilder$;
import net.wiringbits.webapp.utils.admin.utils.models.QueryParameters;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

public final class DatabaseTablesDAO$ {
    public static final DatabaseTablesDAO$ MODULE$ = new DatabaseTablesDAO$();

    public List<DatabaseTable> all(String schema, Connection conn) {
        ParameterValue[] parameterValueArray = new ParameterValue[1];
        ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)schema, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        return (List)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    SELECT table_name\n    FROM information_schema.tables\n    WHERE table_schema = ", "\n      AND table_type = 'BASE TABLE'\n    ORDER BY table_name\n    "}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(package$.MODULE$.tableParser().$times(), conn);
    }

    public String all$default$1() {
        return "public";
    }

    public List<TableField> getTableFields(String tableName, Connection conn) {
        List list;
        String sql = new StringBuilder(22).append("SELECT * FROM ").append(tableName).append(" LIMIT 0").toString();
        try (PreparedStatement preparedStatement = conn.prepareStatement(sql);){
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetMetaData metadata = resultSet.getMetaData();
            int numberOfColumns = metadata.getColumnCount();
            try {
                IndexedSeq fields = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numberOfColumns).map((Function1 & Serializable)columnNumber -> DatabaseTablesDAO$.$anonfun$getTableFields$1(metadata, BoxesRunTime.unboxToInt((Object)columnNumber))).map((Function1 & Serializable)x$1 -> {
                    Tuple3 tuple3 = x$1;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    String columnName = (String)tuple3._2();
                    String columnType = (String)tuple3._3();
                    TableField tableField = new TableField(columnName, columnType);
                    return tableField;
                });
                list = fields.toList();
            }
            finally {
                resultSet.close();
            }
        }
        return list;
    }

    public List<ForeignReference> getTableReferences(String tableName, Connection conn) {
        ParameterValue[] parameterValueArray = new ParameterValue[1];
        ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)tableName, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        return (List)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    SELECT kcu.table_schema || '.' || kcu.table_name AS foreign_table, \n      rel_tco.table_schema || '.' || rel_tco.table_name AS primary_table, \n      string_agg(kcu.column_name, ', ') AS fk_columns\n    FROM information_schema.table_constraints tco\n    JOIN information_schema.key_column_usage kcu\n      ON tco.constraint_schema = kcu.constraint_schema\n      AND tco.constraint_name = kcu.constraint_name\n    JOIN information_schema.referential_constraints rco\n      ON tco.constraint_schema = rco.constraint_schema\n      AND tco.constraint_name = rco.constraint_name\n    JOIN information_schema.table_constraints rel_tco\n      ON rco.unique_constraint_schema = rel_tco.constraint_schema\n      AND rco.unique_constraint_name = rel_tco.constraint_name\n    WHERE tco.constraint_type = 'FOREIGN KEY'\n      AND kcu.table_name = ", "\n    GROUP BY kcu.table_schema, kcu.table_name, rel_tco.table_name, rel_tco.table_schema\n    ORDER BY kcu.table_schema, kcu.table_name\n    "}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(package$.MODULE$.tableReferencesParser().$times(), conn);
    }

    public List<TableRow> getTableData(String tableName, List<TableField> fields, QueryParameters queryParameters, Connection conn) {
        List list;
        ListBuffer tableData = new ListBuffer();
        String sql = new StringBuilder(86).append("\n      SELECT * FROM ").append(tableName).append("\n      WHERE ? = ?\n      ORDER BY ").append(queryParameters.sort().field()).append(" ").append(queryParameters.sort().ordering()).append("\n      LIMIT ? OFFSET ?\n      ").toString();
        PreparedStatement preparedStatement = conn.prepareStatement(sql);
        int limit = queryParameters.pagination().end() - queryParameters.pagination().start();
        int offset = queryParameters.pagination().start();
        preparedStatement.setString(1, queryParameters.filter().field());
        preparedStatement.setString(2, queryParameters.filter().value());
        preparedStatement.setInt(3, limit);
        preparedStatement.setInt(4, offset);
        ResultSet resultSet = preparedStatement.executeQuery();
        try {
            while (resultSet.next()) {
                List rowData = fields.map((Function1 & Serializable)field -> {
                    String fieldName = field.name();
                    String data = resultSet.getString(fieldName);
                    return new Tuple3(field, (Object)fieldName, (Object)data);
                }).map((Function1 & Serializable)x$2 -> {
                    Tuple3 tuple3 = x$2;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    String data = (String)tuple3._3();
                    Cell cell = new Cell((String)Option$.MODULE$.apply((Object)data).getOrElse((Function0 & Serializable)() -> "null"));
                    return cell;
                });
                tableData.$plus$eq((Object)new TableRow((List<Cell>)rowData));
            }
            list = tableData.toList();
        }
        finally {
            resultSet.close();
            preparedStatement.close();
        }
        return list;
    }

    public List<TableField> getMandatoryFields(String tableName, String primaryKeyField, Connection conn) {
        ListBuffer mandatoryFields = new ListBuffer();
        String SQL = "\n      SELECT column_name, is_nullable, \n        column_default, data_type\n      FROM information_schema.columns\n      WHERE table_schema = 'public'\n        AND table_name = ?\n      ORDER BY column_name\n      ";
        PreparedStatement preparedStatement = conn.prepareStatement(SQL);
        preparedStatement.setObject(1, tableName);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            BoxedUnit boxedUnit;
            boolean isObligatory;
            String columnName = resultSet.getString("column_name");
            String columnType = resultSet.getString("data_type");
            Option defaultValue = Option$.MODULE$.apply((Object)resultSet.getString("column_default"));
            String string = resultSet.getString("is_nullable");
            String string2 = "YES";
            boolean isNullable = !(string != null ? !string.equals(string2) : string2 != null);
            boolean bl = isObligatory = !isNullable && defaultValue.isEmpty();
            if (isObligatory) {
                String string3 = columnName;
                String string4 = primaryKeyField;
                if (string3 == null ? string4 != null : !string3.equals(string4)) {
                    boxedUnit = mandatoryFields.$plus$eq((Object)new TableField(columnName, columnType));
                    continue;
                }
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return mandatoryFields.toList();
    }

    public Option<TableRow> find(String tableName, String primaryKeyField, String primaryKeyValue, Connection conn) {
        String sql = new StringBuilder(45).append("\n    SELECT *\n      FROM ").append(tableName).append("\n    WHERE ").append(primaryKeyField).append(" = ?\n    ").toString();
        PreparedStatement preparedStatement = conn.prepareStatement(sql);
        preparedStatement.setObject(1, UUID.fromString(primaryKeyValue));
        ResultSet resultSet = preparedStatement.executeQuery();
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            resultSet.next();
            int numberOfColumns = resultSet.getMetaData().getColumnCount();
            IndexedSeq row = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numberOfColumns).map((Function1 & Serializable)columnNumber -> DatabaseTablesDAO$.$anonfun$find$2(resultSet, BoxesRunTime.unboxToInt((Object)columnNumber))).map((Function1 & Serializable)x$3 -> {
                Tuple2 tuple2 = x$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String cellData = (String)tuple2._2();
                Cell cell = new Cell((String)Option$.MODULE$.apply((Object)cellData).getOrElse((Function0 & Serializable)() -> "null"));
                return cell;
            });
            return new TableRow((List<Cell>)row.toList());
        }).toOption();
    }

    public void create(String tableName, Map<String, String> body, String primaryKeyField, Connection conn) {
        String sql = QueryBuilder$.MODULE$.create(tableName, body, primaryKeyField);
        PreparedStatement preparedStatement = conn.prepareStatement(sql);
        preparedStatement.setObject(1, UUID.randomUUID());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), body.size() + 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            String value = (String)body.apply(body.keys().toList().apply(i - 2));
            preparedStatement.setObject(i, value);
        });
        int n = preparedStatement.executeUpdate();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public void update(String tableName, Map<TableField, String> fieldsAndValues, String primaryKeyField, String primaryKeyValue, Connection conn) {
        String sql = QueryBuilder$.MODULE$.update(tableName, fieldsAndValues, primaryKeyField);
        PreparedStatement preparedStatement = conn.prepareStatement(sql);
        Map notNullData = (Map)fieldsAndValues.filterNot((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DatabaseTablesDAO$.$anonfun$update$1(x$5)));
        ((IterableOnceOps)notNullData.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            DatabaseTablesDAO$.$anonfun$update$2(preparedStatement, x0$1);
            return BoxedUnit.UNIT;
        });
        preparedStatement.setObject(notNullData.size() + 1, UUID.fromString(primaryKeyValue));
        int n = preparedStatement.executeUpdate();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public void delete(String tableName, String primaryKeyField, String primaryKeyValue, Connection conn) {
        String sql = new StringBuilder(43).append("\n      DELETE FROM ").append(tableName).append("\n      WHERE ").append(primaryKeyField).append(" = ?\n      ").toString();
        PreparedStatement preparedStatement = conn.prepareStatement(sql);
        preparedStatement.setObject(1, UUID.fromString(primaryKeyValue));
        int n = preparedStatement.executeUpdate();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public int countRecordsOnTable(String tableName, Connection conn) {
        ParameterValue[] parameterValueArray = new ParameterValue[1];
        ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)tableName, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        return BoxesRunTime.unboxToInt((Object)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      SELECT COUNT(*)\n      FROM #", "\n      "}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.int("count", Column$.MODULE$.columnToInt()).single(), conn));
    }

    public static final /* synthetic */ Tuple3 $anonfun$getTableFields$1(ResultSetMetaData metadata$1, int columnNumber) {
        String columnName = metadata$1.getColumnName(columnNumber);
        String columnType = metadata$1.getColumnTypeName(columnNumber);
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)columnNumber), (Object)columnName, (Object)columnType);
    }

    public static final /* synthetic */ Tuple2 $anonfun$find$2(ResultSet resultSet$2, int columnNumber) {
        String cellData = resultSet$2.getString(columnNumber);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)columnNumber), (Object)cellData);
    }

    public static final /* synthetic */ boolean $anonfun$update$1(Tuple2 x$5) {
        Object object = x$5._2();
        String string = "null";
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$update$2(PreparedStatement preparedStatement$2, Tuple2 x0$1) {
        int i;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x0$1;
                if (tuple22 == null) break block2;
                tuple2 = (Tuple2)tuple22._1();
                i = tuple22._2$mcI$sp();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        String value = (String)tuple2._2();
        preparedStatement$2.setObject(i + 1, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private DatabaseTablesDAO$() {
    }
}

