/*
 * Decompiled with CFR 0.152.
 */
package net.wiringbits.webapp.utils.admin.repositories;

import java.io.Serializable;
import java.sql.Connection;
import javax.inject.Inject;
import net.wiringbits.webapp.utils.admin.config.DataExplorerSettings;
import net.wiringbits.webapp.utils.admin.executors.DatabaseExecutionContext;
import net.wiringbits.webapp.utils.admin.repositories.daos.DatabaseTablesDAO$;
import net.wiringbits.webapp.utils.admin.repositories.models.DatabaseTable;
import net.wiringbits.webapp.utils.admin.repositories.models.ForeignReference;
import net.wiringbits.webapp.utils.admin.repositories.models.TableData;
import net.wiringbits.webapp.utils.admin.repositories.models.TableField;
import net.wiringbits.webapp.utils.admin.repositories.models.TableRow;
import net.wiringbits.webapp.utils.admin.utils.models.QueryParameters;
import play.api.db.Database;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001B\b\u0011\u0001uA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\t_\u0001\u0011\t\u0011)A\u0006a!Aa\u0007\u0001B\u0001B\u0003-q\u0007C\u0003>\u0001\u0011\u0005a\bC\u0003O\u0001\u0011\u0005q\nC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003z\u0001\u0011\u0005!\u0010C\u0004\u0002\u0004\u0001!\t!!\u0002\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0002bBA\u001b\u0001\u0011\u0005\u0011q\u0007\u0005\b\u0003\u001b\u0002A\u0011AA(\u0011\u001d\t9\u0006\u0001C\u0001\u00033Bq!a\u0018\u0001\t\u0003\t\tG\u0001\rECR\f'-Y:f)\u0006\u0014G.Z:SKB|7/\u001b;pefT!!\u0005\n\u0002\u0019I,\u0007o\\:ji>\u0014\u0018.Z:\u000b\u0005M!\u0012!B1e[&t'BA\u000b\u0017\u0003\u0015)H/\u001b7t\u0015\t9\u0002$\u0001\u0004xK\n\f\u0007\u000f\u001d\u0006\u00033i\t!b^5sS:<'-\u001b;t\u0015\u0005Y\u0012a\u00018fi\u000e\u00011C\u0001\u0001\u001f!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fM\u0006AA-\u0019;bE\u0006\u001cX\r\u0005\u0002'[5\tqE\u0003\u0002)S\u0005\u0011AM\u0019\u0006\u0003U-\n1!\u00199j\u0015\u0005a\u0013\u0001\u00029mCfL!AL\u0014\u0003\u0011\u0011\u000bG/\u00192bg\u0016\f!!Z2\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005M\u0012\u0012!C3yK\u000e,Ho\u001c:t\u0013\t)$G\u0001\rECR\f'-Y:f\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fQ\u0002^1cY\u0016\u001cV\r\u001e;j]\u001e\u001c\bC\u0001\u001d<\u001b\u0005I$B\u0001\u001e\u0013\u0003\u0019\u0019wN\u001c4jO&\u0011A(\u000f\u0002\u0015\t\u0006$\u0018-\u0012=qY>\u0014XM]*fiRLgnZ:\u0002\rqJg.\u001b;?)\tyD\tF\u0002A\u0005\u000e\u0003\"!\u0011\u0001\u000e\u0003AAQa\f\u0003A\u0004ABQA\u000e\u0003A\u0004]BQ\u0001\n\u0003A\u0002\u0015B#\u0001\u0002$\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015AB5oU\u0016\u001cGOC\u0001L\u0003\u0015Q\u0017M^1y\u0013\ti\u0005J\u0001\u0004J]*,7\r^\u0001\u0004C2dG#\u0001)\u0011\u0007E#f+D\u0001S\u0015\t\u0019\u0006%\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u0016*\u0003\r\u0019+H/\u001e:f!\r9vL\u0019\b\u00031vs!!\u0017/\u000e\u0003iS!a\u0017\u000f\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0013B\u00010!\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Y1\u0003\t1K7\u000f\u001e\u0006\u0003=\u0002\u0002\"a\u00194\u000e\u0003\u0011T!!\u001a\t\u0002\r5|G-\u001a7t\u0013\t9GMA\u0007ECR\f'-Y:f)\u0006\u0014G.Z\u0001\u000fO\u0016$H+\u00192mK\u001aKW\r\u001c3t)\tQw\u000eE\u0002R).\u00042aV0m!\t\u0019W.\u0003\u0002oI\nQA+\u00192mK\u001aKW\r\u001c3\t\u000bA4\u0001\u0019A9\u0002\u0013Q\f'\r\\3OC6,\u0007C\u0001:w\u001d\t\u0019H\u000f\u0005\u0002ZA%\u0011Q\u000fI\u0001\u0007!J,G-\u001a4\n\u0005]D(AB*ue&twM\u0003\u0002vA\u0005\u0011r-\u001a;UC\ndWMU3gKJ,gnY3t)\rY\u0018\u0011\u0001\t\u0004#Rc\bcA,`{B\u00111M`\u0005\u0003\u007f\u0012\u0014\u0001CR8sK&<gNU3gKJ,gnY3\t\u000bA<\u0001\u0019A9\u0002%\u001d,G/T1oI\u0006$xN]=GS\u0016dGm\u001d\u000b\u0004U\u0006\u001d\u0001\"\u00029\t\u0001\u0004\t\u0018\u0001E4fiR\u000b'\r\\3NKR\fG-\u0019;b)\u0019\ti!a\u0006\u0002\u001aA!\u0011\u000bVA\b!\u00119v,!\u0005\u0011\u0007\r\f\u0019\"C\u0002\u0002\u0016\u0011\u0014\u0011\u0002V1cY\u0016$\u0015\r^1\t\u000bAL\u0001\u0019A9\t\u000f\u0005m\u0011\u00021\u0001\u0002\u001e\u0005y\u0011/^3ssB\u000b'/Y7fi\u0016\u00148\u000f\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r)\u00171\u0005\u0006\u0003+IIA!a\n\u0002\"\ty\u0011+^3ssB\u000b'/Y7fi\u0016\u00148/\u0001\u0003gS:$GCBA\u0017\u0003_\t\t\u0004\u0005\u0003R)\u0006E\u0001\"\u00029\u000b\u0001\u0004\t\bBBA\u001a\u0015\u0001\u0007\u0011/A\bqe&l\u0017M]=LKf4\u0016\r\\;f\u0003\u0019\u0019'/Z1uKR1\u0011\u0011HA!\u0003\u0007\u0002B!\u0015+\u0002<A\u0019q$!\u0010\n\u0007\u0005}\u0002E\u0001\u0003V]&$\b\"\u00029\f\u0001\u0004\t\bbBA#\u0017\u0001\u0007\u0011qI\u0001\u0005E>$\u0017\u0010E\u0003s\u0003\u0013\n\u0018/C\u0002\u0002La\u00141!T1q\u0003\u0019)\b\u000fZ1uKRA\u0011\u0011HA)\u0003'\n)\u0006C\u0003q\u0019\u0001\u0007\u0011\u000f\u0003\u0004\u000241\u0001\r!\u001d\u0005\b\u0003\u000bb\u0001\u0019AA$\u0003\u0019!W\r\\3uKR1\u0011\u0011HA.\u0003;BQ\u0001]\u0007A\u0002EDa!a\r\u000e\u0001\u0004\t\u0018a\u00048v[\n,'o\u00144SK\u000e|'\u000fZ:\u0015\t\u0005\r\u00141\u000e\t\u0005#R\u000b)\u0007E\u0002 \u0003OJ1!!\u001b!\u0005\rIe\u000e\u001e\u0005\u0006a:\u0001\r!\u001d")
public class DatabaseTablesRepository {
    private final Database database;
    private final DatabaseExecutionContext ec;
    private final DataExplorerSettings tableSettings;

    public Future<List<DatabaseTable>> all() {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (List)$this.database.withConnection((Function1 & Serializable)conn -> DatabaseTablesDAO$.MODULE$.all(DatabaseTablesDAO$.MODULE$.all$default$1(), (Connection)conn)), (ExecutionContext)this.ec);
    }

    public Future<List<TableField>> getTableFields(String tableName) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (List)$this.database.withConnection((Function1 & Serializable)conn -> DatabaseTablesDAO$.MODULE$.getTableFields(tableName, (Connection)conn)), (ExecutionContext)this.ec);
    }

    public Future<List<ForeignReference>> getTableReferences(String tableName) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (List)$this.database.withConnection((Function1 & Serializable)conn -> DatabaseTablesDAO$.MODULE$.getTableReferences(tableName, (Connection)conn)), (ExecutionContext)this.ec);
    }

    public Future<List<TableField>> getMandatoryFields(String tableName) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (List)$this.database.withConnection((Function1 & Serializable)conn -> {
            String primaryKeyField = $this.tableSettings.unsafeFindByName(tableName).primaryKeyField();
            return DatabaseTablesDAO$.MODULE$.getMandatoryFields(tableName, primaryKeyField, (Connection)conn);
        }), (ExecutionContext)this.ec);
    }

    public Future<List<TableData>> getTableMetadata(String tableName, QueryParameters queryParameters) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (List)$this.database.withTransaction((Function1 & Serializable)conn -> {
            List<TableField> fields = DatabaseTablesDAO$.MODULE$.getTableFields(tableName, (Connection)conn);
            List<TableRow> rows = DatabaseTablesDAO$.MODULE$.getTableData(tableName, fields, queryParameters, (Connection)conn);
            String primaryKeyField = $this.tableSettings.unsafeFindByName(tableName).primaryKeyField();
            List fieldNames = fields.map((Function1 & Serializable)x$1 -> x$1.name());
            List updatedNames = fieldNames.updated(fieldNames.indexOf((Object)primaryKeyField), (Object)"id");
            return rows.map((Function1 & Serializable)row -> {
                Map<String, String> tableRow = row.convertToMap((List<String>)updatedNames);
                return new TableData(tableRow);
            });
        }), (ExecutionContext)this.ec);
    }

    public Future<TableData> find(String tableName, String primaryKeyValue) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (TableData)$this.database.withTransaction((Function1 & Serializable)conn -> {
            String primaryKeyField = $this.tableSettings.unsafeFindByName(tableName).primaryKeyField();
            Option<TableRow> maybe = DatabaseTablesDAO$.MODULE$.find(tableName, primaryKeyField, primaryKeyValue, (Connection)conn);
            TableRow row = (TableRow)maybe.getOrElse((Function0 & Serializable)() -> {
                throw new RuntimeException(new StringBuilder(29).append("Cannot find item in ").append(tableName).append(" with id ").append(primaryKeyValue).toString());
            });
            List<TableField> fields = DatabaseTablesDAO$.MODULE$.getTableFields(tableName, (Connection)conn);
            List fieldNames = fields.map((Function1 & Serializable)x$2 -> x$2.name());
            List updatedNames = fieldNames.updated(fieldNames.indexOf((Object)primaryKeyField), (Object)"id");
            Map<String, String> tableRow = row.convertToMap((List<String>)updatedNames);
            return new TableData(tableRow);
        }), (ExecutionContext)this.ec);
    }

    public Future<BoxedUnit> create(String tableName, Map<String, String> body) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.database.withConnection((Function1 & Serializable)conn -> {
            DatabaseTablesRepository.$anonfun$create$2(this, tableName, body, conn);
            return BoxedUnit.UNIT;
        }), (ExecutionContext)this.ec);
    }

    public Future<BoxedUnit> update(String tableName, String primaryKeyValue, Map<String, String> body) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.database.withTransaction((Function1 & Serializable)conn -> {
            DatabaseTablesRepository.$anonfun$update$2(this, tableName, body, primaryKeyValue, conn);
            return BoxedUnit.UNIT;
        }), (ExecutionContext)this.ec);
    }

    public Future<BoxedUnit> delete(String tableName, String primaryKeyValue) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.database.withConnection((Function1 & Serializable)conn -> {
            DatabaseTablesRepository.$anonfun$delete$2(this, tableName, primaryKeyValue, conn);
            return BoxedUnit.UNIT;
        }), (ExecutionContext)this.ec);
    }

    public Future<Object> numberOfRecords(String tableName) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.database.withConnection((Function1 & Serializable)conn -> BoxesRunTime.boxToInteger((int)DatabaseTablesDAO$.MODULE$.countRecordsOnTable(tableName, conn)))), (ExecutionContext)this.ec);
    }

    public static final /* synthetic */ void $anonfun$create$2(DatabaseTablesRepository $this, String tableName$6, Map body$1, Connection conn) {
        String primaryKeyField = $this.tableSettings.unsafeFindByName(tableName$6).primaryKeyField();
        DatabaseTablesDAO$.MODULE$.create(tableName$6, (Map<String, String>)body$1, primaryKeyField, conn);
    }

    public static final /* synthetic */ boolean $anonfun$update$4(String key$1, TableField x$3) {
        String string = x$3.name();
        String string2 = key$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$update$2(DatabaseTablesRepository $this, String tableName$7, Map body$2, String primaryKeyValue$2, Connection conn) {
        String primaryKeyField = $this.tableSettings.unsafeFindByName(tableName$7).primaryKeyField();
        List<TableField> fields = DatabaseTablesDAO$.MODULE$.getTableFields(tableName$7, conn);
        Map fieldsAndValues = (Map)body$2.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            TableField field = (TableField)fields.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DatabaseTablesRepository.$anonfun$update$4(key, x$3))).getOrElse((Function0 & Serializable)() -> {
                throw new RuntimeException(new StringBuilder(34).append("Invalid property in body request: ").append(key).toString());
            });
            Tuple2 tuple22 = new Tuple2((Object)field, (Object)value);
            return tuple22;
        });
        DatabaseTablesDAO$.MODULE$.update(tableName$7, (Map<TableField, String>)fieldsAndValues, primaryKeyField, primaryKeyValue$2, conn);
    }

    public static final /* synthetic */ void $anonfun$delete$2(DatabaseTablesRepository $this, String tableName$8, String primaryKeyValue$3, Connection conn) {
        String primaryKeyField = $this.tableSettings.unsafeFindByName(tableName$8).primaryKeyField();
        DatabaseTablesDAO$.MODULE$.delete(tableName$8, primaryKeyField, primaryKeyValue$3, conn);
    }

    @Inject
    public DatabaseTablesRepository(Database database, DatabaseExecutionContext ec, DataExplorerSettings tableSettings) {
        this.database = database;
        this.ec = ec;
        this.tableSettings = tableSettings;
    }
}

