/*
 * Decompiled with CFR 0.152.
 */
package net.wiringbits.webapp.utils.admin.repositories.daos;

import anorm.Column$;
import anorm.ParameterValue;
import anorm.ParameterValue$;
import anorm.SqlParser$;
import anorm.ToParameterValue$;
import anorm.ToStatement;
import anorm.ToStatement$;
import anorm.ToStatementPriority0;
import anorm.package;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.UUID;
import net.wiringbits.webapp.utils.admin.config.PrimaryKeyDataType;
import net.wiringbits.webapp.utils.admin.config.PrimaryKeyDataType$BigSerial$;
import net.wiringbits.webapp.utils.admin.config.PrimaryKeyDataType$Serial$;
import net.wiringbits.webapp.utils.admin.config.PrimaryKeyDataType$UUID$;
import net.wiringbits.webapp.utils.admin.config.TableSettings;
import net.wiringbits.webapp.utils.admin.repositories.daos.package$;
import net.wiringbits.webapp.utils.admin.repositories.models.Cell;
import net.wiringbits.webapp.utils.admin.repositories.models.DatabaseTable;
import net.wiringbits.webapp.utils.admin.repositories.models.ForeignKey;
import net.wiringbits.webapp.utils.admin.repositories.models.TableColumn;
import net.wiringbits.webapp.utils.admin.repositories.models.TableRow;
import net.wiringbits.webapp.utils.admin.utils.QueryBuilder$;
import net.wiringbits.webapp.utils.admin.utils.models.QueryParameters;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

public final class DatabaseTablesDAO$ {
    public static final DatabaseTablesDAO$ MODULE$ = new DatabaseTablesDAO$();

    public List<DatabaseTable> all(String schema, Connection conn) {
        ParameterValue[] parameterValueArray = new ParameterValue[1];
        ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)schema, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        return (List)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    SELECT table_name\n    FROM information_schema.tables\n    WHERE table_schema = ", "\n      AND table_type = 'BASE TABLE'\n    ORDER BY table_name\n    "}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(package$.MODULE$.tableParser().$times(), conn);
    }

    public String all$default$1() {
        return "public";
    }

    public List<TableColumn> getTableColumns(String tableName, Connection conn) {
        List list;
        String sql = new StringBuilder(22).append("SELECT * FROM ").append(tableName).append(" LIMIT 0").toString();
        try (PreparedStatement preparedStatement = conn.prepareStatement(sql);){
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetMetaData metadata = resultSet.getMetaData();
            int numberOfColumns = metadata.getColumnCount();
            try {
                IndexedSeq fields = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numberOfColumns).map((Function1 & Serializable)columnNumber -> DatabaseTablesDAO$.$anonfun$getTableColumns$1(metadata, BoxesRunTime.unboxToInt((Object)columnNumber))).map((Function1 & Serializable)x$1 -> {
                    Tuple3 tuple3 = x$1;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    String columnName = (String)tuple3._2();
                    String columnType = (String)tuple3._3();
                    TableColumn tableColumn = new TableColumn(columnName, columnType);
                    return tableColumn;
                });
                list = fields.toList();
            }
            finally {
                resultSet.close();
            }
        }
        return list;
    }

    public List<ForeignKey> getForeignKeys(String tableName, Connection conn) {
        ParameterValue[] parameterValueArray = new ParameterValue[1];
        ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)tableName, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        return (List)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    SELECT kcu.table_name AS foreign_table, \n      rel_tco.table_name AS primary_table, \n      kcu.column_name AS fk_column\n    FROM information_schema.table_constraints tco\n    JOIN information_schema.key_column_usage kcu\n      ON tco.constraint_schema = kcu.constraint_schema\n      AND tco.constraint_name = kcu.constraint_name\n    JOIN information_schema.referential_constraints rco\n      ON tco.constraint_schema = rco.constraint_schema\n      AND tco.constraint_name = rco.constraint_name\n    JOIN information_schema.table_constraints rel_tco\n      ON rco.unique_constraint_schema = rel_tco.constraint_schema\n      AND rco.unique_constraint_name = rel_tco.constraint_name\n    WHERE tco.constraint_type = 'FOREIGN KEY'\n      AND kcu.table_name = ", "\n    GROUP BY kcu.table_schema, kcu.table_name, kcu.column_name, rel_tco.table_name, rel_tco.table_schema\n    ORDER BY kcu.table_schema, kcu.table_name\n    "}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(package$.MODULE$.foreignKeyParser().$times(), conn);
    }

    public List<TableRow> getTableData(String tableName, List<TableColumn> fields, QueryParameters queryParameters, TableSettings settings, Connection conn) {
        List list;
        int limit = queryParameters.pagination().end() - queryParameters.pagination().start();
        int offset = queryParameters.pagination().start();
        String string = queryParameters.sort().field();
        String string2 = "id";
        String sortBy = !(string != null ? !string.equals(string2) : string2 != null) ? settings.primaryKeyField() : queryParameters.sort().field();
        PreparedStatement preparedStatement = (PreparedStatement)queryParameters.filter().field().map((Function1 & Serializable)field -> {
            String string = field;
            String string2 = "id";
            String primaryKey = !(string != null ? !string.equals(string2) : string2 != null) ? settings.primaryKeyField() : field;
            String sql = new StringBuilder(85).append("\n      SELECT * FROM ").append(tableName).append("\n      WHERE ").append(primaryKey).append(" = ?\n      ORDER BY ").append(sortBy).append(" ").append(queryParameters.sort().ordering()).append("\n      LIMIT ? OFFSET ?\n      ").toString();
            PreparedStatement preparedStatement = conn.prepareStatement(sql);
            preparedStatement.setString(1, queryParameters.filter().value());
            preparedStatement.setInt(2, limit);
            preparedStatement.setInt(3, offset);
            return preparedStatement;
        }).getOrElse((Function0 & Serializable)() -> {
            String sql = new StringBuilder(68).append("\n      SELECT * FROM ").append(tableName).append("\n      ORDER BY ").append(sortBy).append(" ").append(queryParameters.sort().ordering()).append("\n      LIMIT ? OFFSET ?\n      ").toString();
            PreparedStatement preparedStatement = conn.prepareStatement(sql);
            preparedStatement.setInt(1, limit);
            preparedStatement.setInt(2, offset);
            return preparedStatement;
        });
        ResultSet resultSet = preparedStatement.executeQuery();
        ListBuffer tableData = new ListBuffer();
        try {
            while (resultSet.next()) {
                List rowData = fields.map((Function1 & Serializable)field -> {
                    String fieldName = field.name();
                    String data = resultSet.getString(fieldName);
                    return new Tuple3(field, (Object)fieldName, (Object)data);
                }).map((Function1 & Serializable)x$2 -> {
                    Tuple3 tuple3 = x$2;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    String data = (String)tuple3._3();
                    Cell cell = new Cell((String)Option$.MODULE$.apply((Object)data).getOrElse((Function0 & Serializable)() -> ""));
                    return cell;
                });
                tableData.$plus$eq((Object)new TableRow((List<Cell>)rowData));
            }
            list = tableData.toList();
        }
        finally {
            resultSet.close();
            preparedStatement.close();
        }
        return list;
    }

    public List<TableColumn> getMandatoryFields(String tableName, String primaryKeyField, Connection conn) {
        ParameterValue[] parameterValueArray = new ParameterValue[2];
        ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)tableName, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        ToStatementPriority0.stringToStatement$ x$7 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[1] = ParameterValue$.MODULE$.from((Object)primaryKeyField, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
        return (List)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      SELECT column_name, data_type\n      FROM information_schema.columns\n      WHERE table_schema = 'public'\n        AND is_nullable = 'NO'\n        AND column_default IS NULL\n        AND table_name = ", "\n        AND column_name != ", "\n      ORDER BY column_name\n      "}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(package$.MODULE$.tableColumnParser().$times(), conn);
    }

    public Option<TableRow> find(String tableName, String primaryKeyField, String primaryKeyValue, PrimaryKeyDataType primaryKeyType, Connection conn) {
        String sql = new StringBuilder(45).append("\n    SELECT *\n      FROM ").append(tableName).append("\n    WHERE ").append(primaryKeyField).append(" = ?\n    ").toString();
        PreparedStatement preparedStatement = conn.prepareStatement(sql);
        this.setPreparedStatementKey(preparedStatement, primaryKeyValue, primaryKeyType, this.setPreparedStatementKey$default$4());
        ResultSet resultSet = preparedStatement.executeQuery();
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            resultSet.next();
            int numberOfColumns = resultSet.getMetaData().getColumnCount();
            IndexedSeq row = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numberOfColumns).map((Function1 & Serializable)columnNumber -> DatabaseTablesDAO$.$anonfun$find$2(resultSet, BoxesRunTime.unboxToInt((Object)columnNumber))).map((Function1 & Serializable)x$3 -> {
                Tuple2 tuple2 = x$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String cellData = (String)tuple2._2();
                Cell cell = new Cell((String)Option$.MODULE$.apply((Object)cellData).getOrElse((Function0 & Serializable)() -> ""));
                return cell;
            });
            return new TableRow((List<Cell>)row.toList());
        }).toOption();
    }

    public PrimaryKeyDataType find$default$4() {
        return PrimaryKeyDataType$UUID$.MODULE$;
    }

    private void setPreparedStatementKey(PreparedStatement preparedStatement, String primaryKeyValue, PrimaryKeyDataType primaryKeyType, int parameterIndex) {
        PrimaryKeyDataType primaryKeyDataType = primaryKeyType;
        if (PrimaryKeyDataType$UUID$.MODULE$.equals(primaryKeyDataType)) {
            preparedStatement.setObject(parameterIndex, UUID.fromString(primaryKeyValue));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (PrimaryKeyDataType$Serial$.MODULE$.equals(primaryKeyDataType)) {
            preparedStatement.setInt(parameterIndex, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(primaryKeyValue)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (PrimaryKeyDataType$BigSerial$.MODULE$.equals(primaryKeyDataType)) {
            preparedStatement.setLong(parameterIndex, StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(primaryKeyValue)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)primaryKeyDataType);
        }
    }

    private int setPreparedStatementKey$default$4() {
        return 1;
    }

    public void create(String tableName, Map<String, String> body, String primaryKeyField, PrimaryKeyDataType primaryKeyType, Connection conn) {
        String sql = QueryBuilder$.MODULE$.create(tableName, body, primaryKeyField, primaryKeyType);
        PreparedStatement preparedStatement = conn.prepareStatement(sql);
        IntRef i = IntRef.create((int)0);
        PrimaryKeyDataType primaryKeyDataType = primaryKeyType;
        PrimaryKeyDataType$UUID$ primaryKeyDataType$UUID$ = PrimaryKeyDataType$UUID$.MODULE$;
        if (!(primaryKeyDataType != null ? !primaryKeyDataType.equals(primaryKeyDataType$UUID$) : primaryKeyDataType$UUID$ != null)) {
            ++i.elem;
            preparedStatement.setObject(i.elem, UUID.randomUUID());
        }
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(i.elem + 1), body.size() + i.elem).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            String value = (String)body.apply(body.keys().toList().apply(j - i$1.elem - 1));
            preparedStatement.setObject(j, value);
        });
        int n = preparedStatement.executeUpdate();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public PrimaryKeyDataType create$default$4() {
        return PrimaryKeyDataType$UUID$.MODULE$;
    }

    public void update(String tableName, Map<TableColumn, String> fieldsAndValues, String primaryKeyField, String primaryKeyValue, PrimaryKeyDataType primaryKeyType, Connection conn) {
        String sql = QueryBuilder$.MODULE$.update(tableName, fieldsAndValues, primaryKeyField);
        PreparedStatement preparedStatement = conn.prepareStatement(sql);
        Map notNullData = (Map)fieldsAndValues.filterNot((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DatabaseTablesDAO$.$anonfun$update$1(x0$1)));
        ((IterableOnceOps)notNullData.zipWithIndex()).foreach((Function1 & Serializable)x0$2 -> {
            DatabaseTablesDAO$.$anonfun$update$2(preparedStatement, x0$2);
            return BoxedUnit.UNIT;
        });
        this.setPreparedStatementKey(preparedStatement, primaryKeyValue, primaryKeyType, notNullData.size() + 1);
        int n = preparedStatement.executeUpdate();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public PrimaryKeyDataType update$default$5() {
        return PrimaryKeyDataType$UUID$.MODULE$;
    }

    public void delete(String tableName, String primaryKeyField, String primaryKeyValue, PrimaryKeyDataType primaryKeyType, Connection conn) {
        String sql = new StringBuilder(43).append("\n      DELETE FROM ").append(tableName).append("\n      WHERE ").append(primaryKeyField).append(" = ?\n      ").toString();
        PreparedStatement preparedStatement = conn.prepareStatement(sql);
        this.setPreparedStatementKey(preparedStatement, primaryKeyValue, primaryKeyType, this.setPreparedStatementKey$default$4());
        int n = preparedStatement.executeUpdate();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public PrimaryKeyDataType delete$default$4() {
        return PrimaryKeyDataType$UUID$.MODULE$;
    }

    public int countRecordsOnTable(String tableName, Connection conn) {
        ParameterValue[] parameterValueArray = new ParameterValue[1];
        ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)tableName, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        return BoxesRunTime.unboxToInt((Object)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      SELECT COUNT(*)\n      FROM #", "\n      "}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.int("count", Column$.MODULE$.columnToInt()).single(), conn));
    }

    public static final /* synthetic */ Tuple3 $anonfun$getTableColumns$1(ResultSetMetaData metadata$1, int columnNumber) {
        String columnName = metadata$1.getColumnName(columnNumber);
        String columnType = metadata$1.getColumnTypeName(columnNumber);
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)columnNumber), (Object)columnName, (Object)columnType);
    }

    public static final /* synthetic */ Tuple2 $anonfun$find$2(ResultSet resultSet$2, int columnNumber) {
        String cellData = resultSet$2.getString(columnNumber);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)columnNumber), (Object)cellData);
    }

    public static final /* synthetic */ boolean $anonfun$update$1(Tuple2 x0$1) {
        String value;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String string = value = (String)tuple2._2();
        String string2 = "null";
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$update$2(PreparedStatement preparedStatement$2, Tuple2 x0$2) {
        int i;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x0$2;
                if (tuple22 == null) break block2;
                tuple2 = (Tuple2)tuple22._1();
                i = tuple22._2$mcI$sp();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        String value = (String)tuple2._2();
        preparedStatement$2.setObject(i + 1, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private DatabaseTablesDAO$() {
    }
}

