/*
 * Decompiled with CFR 0.152.
 */
package net.wiringbits.webapp.utils.admin.services;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import javax.inject.Inject;
import net.wiringbits.webapp.utils.admin.config.DataExplorerSettings;
import net.wiringbits.webapp.utils.admin.config.TableSettings;
import net.wiringbits.webapp.utils.admin.repositories.DatabaseTablesRepository;
import net.wiringbits.webapp.utils.admin.repositories.models.ForeignKey;
import net.wiringbits.webapp.utils.admin.repositories.models.TableColumn;
import net.wiringbits.webapp.utils.admin.repositories.models.TableData;
import net.wiringbits.webapp.utils.admin.utils.models.QueryParameters;
import net.wiringbits.webapp.utils.admin.utils.package$;
import net.wiringbits.webapp.utils.admin.utils.package$MapStringHideExt$;
import net.wiringbits.webapp.utils.api.models.AdminCreateTable;
import net.wiringbits.webapp.utils.api.models.AdminGetTables;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005g\u0001B\n\u0015\u0001\u0005B\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!Aa\u0007\u0001B\u0001B\u0003-q\u0007C\u0003>\u0001\u0011\u0005a\bC\u0003O\u0001\u0011%q\nC\u0004\u0002\u0002\u0001!\t!a\u0001\t\u000f\u0005E\u0001\u0001\"\u0003\u0002\u0014!9\u00111\u0006\u0001\u0005\u0002\u00055\u0002bBA'\u0001\u0011%\u0011q\n\u0005\b\u0003?\u0002A\u0011AA1\u0011\u001d\ty\u0006\u0001C\u0001\u0003WBq!!\u001e\u0001\t\u0003\t9\bC\u0004\u0002\u000e\u0002!I!a$\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\"9\u00111\u0015\u0001\u0005\u0002\u0005\u0015\u0006bBAV\u0001\u0011%\u0011Q\u0016\u0005\b\u0003c\u0003A\u0011BAZ\u0011\u001d\tI\f\u0001C\u0005\u0003w\u0013A\"\u00113nS:\u001cVM\u001d<jG\u0016T!!\u0006\f\u0002\u0011M,'O^5dKNT!a\u0006\r\u0002\u000b\u0005$W.\u001b8\u000b\u0005eQ\u0012!B;uS2\u001c(BA\u000e\u001d\u0003\u00199XMY1qa*\u0011QDH\u0001\u000bo&\u0014\u0018N\\4cSR\u001c(\"A\u0010\u0002\u00079,Go\u0001\u0001\u0014\u0005\u0001\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g-\u0001\reCR\f'-Y:f)\u0006\u0014G.Z:SKB|7/\u001b;pef\u0004\"AK\u0017\u000e\u0003-R!\u0001\f\f\u0002\u0019I,\u0007o\\:ji>\u0014\u0018.Z:\n\u00059Z#\u0001\u0007#bi\u0006\u0014\u0017m]3UC\ndWm\u001d*fa>\u001c\u0018\u000e^8ss\u0006iA/\u00192mKN+G\u000f^5oON\u0004\"!\r\u001b\u000e\u0003IR!a\r\f\u0002\r\r|gNZ5h\u0013\t)$G\u0001\u000bECR\fW\t\u001f9m_J,'oU3ui&twm]\u0001\u0003K\u000e\u0004\"\u0001O\u001e\u000e\u0003eR!A\u000f\u0013\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002=s\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007}\u001aE\t\u0006\u0002A\u0005B\u0011\u0011\tA\u0007\u0002)!)a\u0007\u0002a\u0002o!)\u0001\u0006\u0002a\u0001S!)q\u0006\u0002a\u0001a!\u0012AA\u0012\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000ba!\u001b8kK\u000e$(\"A&\u0002\u000b)\fg/\u0019=\n\u00055C%AB%oU\u0016\u001cG/\u0001\nhKR\u001cu\u000e\\;n]J+g-\u001a:f]\u000e,Gc\u0001)dmB\u00191%U*\n\u0005I##AB(qi&|g\u000e\u0005\u0002UA:\u0011Q+\u0018\b\u0003-nk\u0011a\u0016\u0006\u00031f\u000ba!\\8eK2\u001c(B\u0001.\u0019\u0003\r\t\u0007/[\u0005\u00039^\u000ba\"\u00113nS:<U\r\u001e+bE2,7/\u0003\u0002_?\u0006A!+Z:q_:\u001cXM\u0003\u0002]/&\u0011\u0011M\u0019\u0002\u000f)\u0006\u0014G.\u001a*fM\u0016\u0014XM\\2f\u0015\tqv\fC\u0003e\u000b\u0001\u0007Q-A\u0006g_J,\u0017n\u001a8LKf\u001c\bc\u00014oc:\u0011q\r\u001c\b\u0003Q.l\u0011!\u001b\u0006\u0003U\u0002\na\u0001\u0010:p_Rt\u0014\"A\u0013\n\u00055$\u0013a\u00029bG.\fw-Z\u0005\u0003_B\u0014A\u0001T5ti*\u0011Q\u000e\n\t\u0003eRl\u0011a\u001d\u0006\u00031.J!!^:\u0003\u0015\u0019{'/Z5h].+\u0017\u0010C\u0003x\u000b\u0001\u0007\u00010\u0001\u0006d_2,XN\u001c(b[\u0016\u0004\"!_?\u000f\u0005i\\\bC\u00015%\u0013\taH%\u0001\u0004Qe\u0016$WMZ\u0005\u0003}~\u0014aa\u0015;sS:<'B\u0001?%\u0003\u0019!\u0018M\u00197fgR\u0011\u0011Q\u0001\t\u0006q\u0005\u001d\u00111B\u0005\u0004\u0003\u0013I$A\u0002$viV\u0014X\rE\u0002V\u0003\u001bI1!a\u0004`\u0005!\u0011Vm\u001d9p]N,\u0017\u0001\u00035jI\u0016$\u0015\r^1\u0015\r\u0005U\u00111DA\u0013!\u0015I\u0018q\u0003=y\u0013\r\tIb \u0002\u0004\u001b\u0006\u0004\bbBA\u000f\u000f\u0001\u0007\u0011qD\u0001\ni\u0006\u0014G.\u001a#bi\u0006\u00042A]A\u0011\u0013\r\t\u0019c\u001d\u0002\n)\u0006\u0014G.\u001a#bi\u0006Dq!a\n\b\u0001\u0004\tI#A\u0007iS\u0012$WM\\\"pYVlgn\u001d\t\u0004M:D\u0018!\u0004;bE2,W*\u001a;bI\u0006$\u0018\r\u0006\u0004\u00020\u0005e\u0012Q\b\t\u0006q\u0005\u001d\u0011\u0011\u0007\t\u0007G\u0005M\u0012q\u0007=\n\u0007\u0005UBE\u0001\u0004UkBdWM\r\t\u0005M:\f)\u0002\u0003\u0004\u0002<!\u0001\r\u0001_\u0001\ni\u0006\u0014G.\u001a(b[\u0016Dq!a\u0010\t\u0001\u0004\t\t%A\u0006rk\u0016\u0014\u0018\u0010U1sC6\u001c\b\u0003BA\"\u0003\u0013j!!!\u0012\u000b\u0007a\u000b9E\u0003\u0002\u001a-%!\u00111JA#\u0005=\tV/\u001a:z!\u0006\u0014\u0018-\\3uKJ\u001c\u0018a\u0006<bY&$\u0017\r^3Rk\u0016\u0014\u0018\u0010U1sC6,G/\u001a:t)\u0019\t\t&!\u0017\u0002\\A)\u0001(a\u0002\u0002TA\u00191%!\u0016\n\u0007\u0005]CE\u0001\u0003V]&$\bBBA\u001e\u0013\u0001\u0007\u0001\u0010C\u0004\u0002^%\u0001\r!!\u0011\u0002\rA\f'/Y7t\u0003\u00111\u0017N\u001c3\u0015\r\u0005\r\u0014QMA4!\u0015A\u0014qAA\u000b\u0011\u0019\tYD\u0003a\u0001q\"1\u0011\u0011\u000e\u0006A\u0002a\fq\u0002\u001d:j[\u0006\u0014\u0018pS3z-\u0006dW/\u001a\u000b\u0007\u0003[\ny'!\u001d\u0011\u000ba\n9!a\u000e\t\r\u0005m2\u00021\u0001y\u0011\u001d\t\u0019h\u0003a\u0001\u0003S\t\u0001\u0003\u001d:j[\u0006\u0014\u0018pS3z-\u0006dW/Z:\u0002\r\r\u0014X-\u0019;f)\u0019\t\t&!\u001f\u0002|!1\u00111\b\u0007A\u0002aDq!! \r\u0001\u0004\ty(A\u0004sKF,Xm\u001d;\u0011\t\u0005\u0005\u0015q\u0011\b\u0004-\u0006\r\u0015bAAC/\u0006\u0001\u0012\tZ7j]\u000e\u0013X-\u0019;f)\u0006\u0014G.Z\u0005\u0005\u0003\u0013\u000bYIA\u0004SKF,Xm\u001d;\u000b\u0007\u0005\u0015u+A\u000bwC2LG-\u0019;f\u001b&\u001c8/\u001b8h\r&,G\u000eZ:\u0015\r\u0005E\u0013\u0011SAJ\u0011\u0019\tY$\u0004a\u0001q\"9\u0011QS\u0007A\u0002\u0005U\u0011\u0001\u00023bi\u0006\fa!\u001e9eCR,G\u0003CA)\u00037\u000bi*a(\t\r\u0005mb\u00021\u0001y\u0011\u0019\tIG\u0004a\u0001q\"9\u0011\u0011\u0015\bA\u0002\u0005U\u0011\u0001\u00022pIf\fa\u0001Z3mKR,GCBA)\u0003O\u000bI\u000b\u0003\u0004\u0002<=\u0001\r\u0001\u001f\u0005\u0007\u0003Sz\u0001\u0019\u0001=\u0002#Y\fG.\u001b3bi\u0016$\u0016M\u00197f\u001d\u0006lW\r\u0006\u0003\u0002T\u0005=\u0006BBA\u001e!\u0001\u0007\u00010A\nwC2LG-\u0019;f%\u0016\fX/Z:u\t\u0006$\u0018\r\u0006\u0004\u0002R\u0005U\u0016q\u0017\u0005\u0007\u0003w\t\u0002\u0019\u0001=\t\u000f\u0005\u0005\u0016\u00031\u0001\u0002\u0016\u0005\u0011b/\u00197jI\u0006$XmQ8mk6tg*Y7f)\u0019\t\t&!0\u0002@\"1\u00111\b\nA\u0002aDQa\u001e\nA\u0002a\u0004")
public class AdminService {
    private final DatabaseTablesRepository databaseTablesRepository;
    private final DataExplorerSettings tableSettings;
    private final ExecutionContext ec;

    private Option<AdminGetTables.Response.TableReference> getColumnReference(List<ForeignKey> foreignKeys, String columnName) {
        List filteredForeignKeys = foreignKeys.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminService.$anonfun$getColumnReference$1(columnName, x$1)));
        Option maybe = filteredForeignKeys.map((Function1 & Serializable)x$2 -> x$2.primaryTable()).headOption();
        return maybe.map((Function1 & Serializable)tableName -> {
            Option<String> maybe = $this.tableSettings.unsafeFindByName((String)tableName).referenceField();
            String referenceField = (String)maybe.getOrElse((Function0 & Serializable)() -> "id");
            return new AdminGetTables.Response.TableReference(tableName, referenceField);
        });
    }

    public Future<AdminGetTables.Response> tables() {
        return Future$.MODULE$.sequence((IterableOnce)this.tableSettings.tables().map((Function1 & Serializable)settings -> {
            List<String> hiddenColumns = settings.hiddenColumns();
            return $this.databaseTablesRepository.getTableColumns(settings.tableName()).flatMap((Function1 & Serializable)tableColumns -> $this.databaseTablesRepository.getForeignKeys(settings.tableName()).map((Function1 & Serializable)foreignKeys -> {
                List visibleColumns = tableColumns.filterNot((Function1 & Serializable)column -> BoxesRunTime.boxToBoolean((boolean)hiddenColumns.contains((Object)column.name())));
                List columns = visibleColumns.map((Function1 & Serializable)column -> {
                    String fieldName = AdminService.getColumnName$1(column.name(), settings.primaryKeyField());
                    boolean isEditable = !settings.nonEditableColumns().contains((Object)column.name());
                    Option<AdminGetTables.Response.TableReference> reference = this.getColumnReference((List<ForeignKey>)foreignKeys, column.name());
                    return new AdminGetTables.Response.TableColumn(fieldName, column.type(), isEditable, reference);
                });
                return new Tuple3(foreignKeys, (Object)visibleColumns, (Object)columns);
            }, $this.ec).map((Function1 & Serializable)x$3 -> {
                Tuple3 tuple3 = x$3;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                List columns = (List)tuple3._3();
                AdminGetTables.Response.DatabaseTable databaseTable = new AdminGetTables.Response.DatabaseTable(settings.tableName(), columns, settings.primaryKeyField(), settings.canBeDeleted());
                return databaseTable;
            }, $this.ec), $this.ec);
        }), BuildFrom$.MODULE$.buildFromIterableOps(), this.ec).map((Function1 & Serializable)items -> new AdminGetTables.Response(items), this.ec);
    }

    private Map<String, String> hideData(TableData tableData, List<String> hiddenColumns) {
        return package$MapStringHideExt$.MODULE$.hideData$extension(package$.MODULE$.MapStringHideExt(tableData.data()), hiddenColumns);
    }

    public Future<Tuple2<List<Map<String, String>>, String>> tableMetadata(String tableName, QueryParameters queryParams) {
        Future validations = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.validateTableName(tableName), this.ec).map((Function1 & Serializable)x$4 -> {
            AdminService.$anonfun$tableMetadata$2(x$4);
            return BoxedUnit.UNIT;
        }, this.ec);
        return validations.map((Function1 & Serializable)x$5 -> {
            TableSettings settings = $this.tableSettings.unsafeFindByName(tableName);
            return new Tuple2(x$5, (Object)settings);
        }, this.ec).flatMap((Function1 & Serializable)x$8 -> {
            Tuple2 tuple2 = x$8;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TableSettings settings = (TableSettings)tuple2._2();
            Future future = this.validateQueryParameters(tableName, queryParams).flatMap((Function1 & Serializable)x$7 -> {
                BoxedUnit boxedUnit = x$7;
                Future future = $this.databaseTablesRepository.getTableMetadata(tableName, queryParams).flatMap((Function1 & Serializable)tableRows -> $this.databaseTablesRepository.numberOfRecords(tableName).map((Function1 & Serializable)numberOfRecords -> AdminService.$anonfun$tableMetadata$7(this, tableRows, settings, tableName, queryParams, BoxesRunTime.unboxToInt((Object)numberOfRecords)), $this.ec).map((Function1 & Serializable)x$6 -> {
                    Tuple3 tuple3 = x$6;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    List hiddenTableData = (List)tuple3._2();
                    String contentRange = (String)tuple3._3();
                    Tuple2 tuple2 = new Tuple2((Object)hiddenTableData, (Object)contentRange);
                    return tuple2;
                }, $this.ec), $this.ec);
                return future;
            }, $this.ec);
            return future;
        }, this.ec);
    }

    private Future<BoxedUnit> validateQueryParameters(String tableName, QueryParameters params) {
        List validOrdering = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ASC", "DESC"}));
        if (!validOrdering.contains((Object)params.sort().ordering())) {
            throw new RuntimeException("Invalid ordering parameter");
        }
        if (params.pagination().start() < 0) {
            throw new RuntimeException("You can't query a table using negative numbers");
        }
        if (params.pagination().start() > params.pagination().end()) {
            throw new RuntimeException("The start parameter can't be bigger than the end");
        }
        return this.validateColumnName(tableName, params.sort().field()).map((Function1 & Serializable)x$9 -> {
            AdminService.$anonfun$validateQueryParameters$1(x$9);
            return BoxedUnit.UNIT;
        }, this.ec);
    }

    public Future<Map<String, String>> find(String tableName, String primaryKeyValue) {
        Future validations = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.validateTableName(tableName), this.ec);
        return validations.flatMap((Function1 & Serializable)x$11 -> {
            BoxedUnit boxedUnit = x$11;
            Future future = $this.databaseTablesRepository.find(tableName, primaryKeyValue).map((Function1 & Serializable)maybe -> {
                TableData tableRow = (TableData)maybe.getOrElse((Function0 & Serializable)() -> {
                    throw new RuntimeException(new StringBuilder(29).append("Cannot find item in ").append(tableName).append(" with id ").append(primaryKeyValue).toString());
                });
                TableSettings settings = $this.tableSettings.unsafeFindByName(tableName);
                Map<String, String> hiddenData = this.hideData(tableRow, settings.hiddenColumns());
                return new Tuple4(maybe, (Object)tableRow, (Object)settings, hiddenData);
            }, $this.ec).map((Function1 & Serializable)x$10 -> {
                Map hiddenData;
                Tuple4 tuple4 = x$10;
                if (tuple4 == null) {
                    throw new MatchError((Object)tuple4);
                }
                Map map = hiddenData = (Map)tuple4._4();
                return map;
            }, $this.ec);
            return future;
        }, this.ec);
    }

    public Future<List<Map<String, String>>> find(String tableName, List<String> primaryKeyValues) {
        Future validations = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.validateTableName(tableName), this.ec);
        return validations.map((Function1 & Serializable)x$13 -> {
            TableSettings settings = $this.tableSettings.unsafeFindByName(tableName);
            return new Tuple2(x$13, (Object)settings);
        }, this.ec).flatMap((Function1 & Serializable)x$15 -> {
            Tuple2 tuple2 = x$15;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TableSettings settings = (TableSettings)tuple2._2();
            Future future = Future$.MODULE$.sequence((IterableOnce)primaryKeyValues.map((Function1 & Serializable)primaryKeyValue -> $this.databaseTablesRepository.find(tableName, (String)primaryKeyValue).map((Function1 & Serializable)maybe -> {
                TableData tableData = (TableData)maybe.getOrElse((Function0 & Serializable)() -> {
                    throw new RuntimeException(new StringBuilder(29).append("Cannot find item in ").append(tableName).append(" with id ").append((String)primaryKeyValue).toString());
                });
                return new Tuple2(maybe, (Object)tableData);
            }, $this.ec).map((Function1 & Serializable)x$12 -> {
                TableData tableData;
                Tuple2 tuple2 = x$12;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TableData tableData2 = tableData = (TableData)tuple2._2();
                return tableData2;
            }, $this.ec)), BuildFrom$.MODULE$.buildFromIterableOps(), $this.ec).map((Function1 & Serializable)tableRows -> {
                List maskedTableData = tableRows.map((Function1 & Serializable)x -> this.hideData((TableData)x, settings.hiddenColumns()));
                return new Tuple2(tableRows, (Object)maskedTableData);
            }, $this.ec).map((Function1 & Serializable)x$14 -> {
                List maskedTableData;
                Tuple2 tuple2 = x$14;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                List list = maskedTableData = (List)tuple2._2();
                return list;
            }, $this.ec);
            return future;
        }, this.ec);
    }

    public Future<BoxedUnit> create(String tableName, AdminCreateTable.Request request) {
        Map body = request.data();
        this.validateTableName(tableName);
        Future validations = this.validateRequestData(tableName, (Map<String, String>)body).flatMap((Function1 & Serializable)x$17 -> {
            BoxedUnit boxedUnit = x$17;
            Future future = this.validateMissingFields(tableName, (Map<String, String>)body).map((Function1 & Serializable)x$16 -> {
                AdminService.$anonfun$create$2(x$16);
                return BoxedUnit.UNIT;
            }, $this.ec);
            return future;
        }, this.ec);
        return validations.flatMap((Function1 & Serializable)x$19 -> {
            BoxedUnit boxedUnit = x$19;
            Future future = $this.databaseTablesRepository.create(tableName, (Map<String, String>)body).map((Function1 & Serializable)x$18 -> {
                AdminService.$anonfun$create$4(x$18);
                return BoxedUnit.UNIT;
            }, $this.ec);
            return future;
        }, this.ec);
    }

    private Future<BoxedUnit> validateMissingFields(String tableName, Map<String, String> data) {
        return this.databaseTablesRepository.getMandatoryFields(tableName).map((Function1 & Serializable)mandatoryFields -> {
            List mandatoryFieldNames = mandatoryFields.map((Function1 & Serializable)x$20 -> x$20.name());
            boolean missingFields = mandatoryFieldNames.forall((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)data.contains((Object)key)));
            return new Tuple3(mandatoryFields, (Object)mandatoryFieldNames, (Object)BoxesRunTime.boxToBoolean((boolean)missingFields));
        }, this.ec).map((Function1 & Serializable)x$21 -> {
            AdminService.$anonfun$validateMissingFields$4(data, x$21);
            return BoxedUnit.UNIT;
        }, this.ec);
    }

    public Future<BoxedUnit> update(String tableName, String primaryKeyValue, Map<String, String> body) {
        if (body.isEmpty()) {
            throw new RuntimeException("You need to send data");
        }
        this.validateTableName(tableName);
        Future validations = this.validateRequestData(tableName, body).map((Function1 & Serializable)x$22 -> {
            AdminService.$anonfun$update$1(x$22);
            return BoxedUnit.UNIT;
        }, this.ec);
        return validations.flatMap((Function1 & Serializable)x$24 -> {
            BoxedUnit boxedUnit = x$24;
            Future future = $this.databaseTablesRepository.update(tableName, primaryKeyValue, body).map((Function1 & Serializable)x$23 -> {
                AdminService.$anonfun$update$3(x$23);
                return BoxedUnit.UNIT;
            }, $this.ec);
            return future;
        }, this.ec);
    }

    public Future<BoxedUnit> delete(String tableName, String primaryKeyValue) {
        Future validations = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.validateTableName(tableName), this.ec).map((Function1 & Serializable)x$25 -> {
            TableSettings settings = $this.tableSettings.unsafeFindByName(tableName);
            if (!settings.canBeDeleted()) {
                throw new RuntimeException(new StringBuilder(34).append("Table ").append(tableName).append(" resources cannot be deleted").toString());
            }
            BoxedUnit x$26 = BoxedUnit.UNIT;
            return new Tuple3(x$25, (Object)settings, (Object)x$26);
        }, this.ec).map((Function1 & Serializable)x$27 -> {
            AdminService.$anonfun$delete$3(x$27);
            return BoxedUnit.UNIT;
        }, this.ec);
        return validations.flatMap((Function1 & Serializable)x$29 -> {
            BoxedUnit boxedUnit = x$29;
            Future future = $this.databaseTablesRepository.delete(tableName, primaryKeyValue).map((Function1 & Serializable)x$28 -> {
                AdminService.$anonfun$delete$5(x$28);
                return BoxedUnit.UNIT;
            }, $this.ec);
            return future;
        }, this.ec);
    }

    private void validateTableName(String tableName) {
        boolean exists = this.tableSettings.tables().exists((Function1 & Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)AdminService.$anonfun$validateTableName$1(tableName, x$30)));
        if (!exists) {
            throw new RuntimeException(new StringBuilder(52).append("Unexpected error because the DB table wasn't found: ").append(tableName).toString());
        }
    }

    private Future<BoxedUnit> validateRequestData(String tableName, Map<String, String> body) {
        return this.databaseTablesRepository.getTableColumns(tableName).map((Function1 & Serializable)tableColumns -> {
            List columnNames = tableColumns.map((Function1 & Serializable)x$31 -> x$31.name());
            Iterable requestFields = body.keys();
            boolean exists = requestFields.forall((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)columnNames.contains(elem)));
            return new Tuple4(tableColumns, (Object)columnNames, (Object)requestFields, (Object)BoxesRunTime.boxToBoolean((boolean)exists));
        }, this.ec).map((Function1 & Serializable)x$32 -> {
            AdminService.$anonfun$validateRequestData$4(x$32);
            return BoxedUnit.UNIT;
        }, this.ec);
    }

    private Future<BoxedUnit> validateColumnName(String tableName, String columnName) {
        return this.databaseTablesRepository.getTableColumns(tableName).map(arg_0 -> AdminService.$anonfun$validateColumnName$1(columnName, arg_0), this.ec).map((Function1 & Serializable)x$34 -> {
            AdminService.$anonfun$validateColumnName$3(columnName, tableName, x$34);
            return BoxedUnit.UNIT;
        }, this.ec);
    }

    public static final /* synthetic */ boolean $anonfun$getColumnReference$1(String columnName$1, ForeignKey x$1) {
        String string = x$1.foreignColumnName();
        String string2 = columnName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final String getColumnName$1(String fieldName, String primaryKeyField) {
        String string = fieldName;
        String string2 = primaryKeyField;
        boolean isPrimaryField = !(string != null ? !string.equals(string2) : string2 != null);
        return isPrimaryField ? "id" : fieldName;
    }

    public static final /* synthetic */ void $anonfun$tableMetadata$2(BoxedUnit x$4) {
        BoxedUnit boxedUnit = x$4;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Tuple3 $anonfun$tableMetadata$7(AdminService $this, List tableRows$1, TableSettings settings$2, String tableName$1, QueryParameters queryParams$1, int numberOfRecords) {
        List hiddenTableData = tableRows$1.map((Function1 & Serializable)data -> $this.hideData((TableData)data, settings$2.hiddenColumns()));
        String contentRange = package$.MODULE$.contentRangeHeader(tableName$1, queryParams$1, numberOfRecords);
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)numberOfRecords), (Object)hiddenTableData, (Object)contentRange);
    }

    public static final /* synthetic */ void $anonfun$validateQueryParameters$1(BoxedUnit x$9) {
        BoxedUnit boxedUnit = x$9;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$create$2(BoxedUnit x$16) {
        BoxedUnit boxedUnit = x$16;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$create$4(BoxedUnit x$18) {
        BoxedUnit boxedUnit = x$18;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$validateMissingFields$4(Map data$1, Tuple3 x$21) {
        Tuple3 tuple3 = x$21;
        if (tuple3 != null) {
            List mandatoryFieldNames = (List)tuple3._2();
            boolean missingFields = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            if (!missingFields) {
                throw new RuntimeException(new StringBuilder(26).append("There are missing fields: ").append(mandatoryFieldNames.filterNot((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)data$1.contains((Object)key))).mkString(", ")).toString());
            }
        } else {
            throw new MatchError((Object)tuple3);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$update$1(BoxedUnit x$22) {
        BoxedUnit boxedUnit = x$22;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$update$3(BoxedUnit x$23) {
        BoxedUnit boxedUnit = x$23;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$delete$3(Tuple3 x$27) {
        Tuple3 tuple3 = x$27;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$delete$5(BoxedUnit x$28) {
        BoxedUnit boxedUnit = x$28;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$validateTableName$1(String tableName$7, TableSettings x$30) {
        String string = x$30.tableName();
        String string2 = tableName$7;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$validateRequestData$4(Tuple4 x$32) {
        Tuple4 tuple4 = x$32;
        if (tuple4 != null) {
            boolean exists = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
            if (!exists) {
                throw new RuntimeException("A field doesn't correspond to this table schema");
            }
        } else {
            throw new MatchError((Object)tuple4);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ String $anonfun$validateColumnName$2(TableColumn x$33) {
        return x$33.name();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Tuple3 $anonfun$validateColumnName$1(String columnName$2, List tableColumns) {
        columnNames = tableColumns.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$validateColumnName$2(net.wiringbits.webapp.utils.admin.repositories.models.TableColumn ), (Lnet/wiringbits/webapp/utils/admin/repositories/models/TableColumn;)Ljava/lang/String;)());
        if (columnNames.contains((Object)columnName$2)) ** GOTO lbl-1000
        v0 = columnName$2;
        var4_3 = "id";
        if (!(v0 != null ? v0.equals(var4_3) == false : var4_3 != null)) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        exists = v1;
        return new Tuple3((Object)tableColumns, (Object)columnNames, (Object)BoxesRunTime.boxToBoolean((boolean)exists));
    }

    public static final /* synthetic */ void $anonfun$validateColumnName$3(String columnName$2, String tableName$8, Tuple3 x$34) {
        Tuple3 tuple3 = x$34;
        if (tuple3 != null) {
            boolean exists = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            if (!exists) {
                throw new RuntimeException(new StringBuilder(26).append("Column ").append(columnName$2).append(" doesn't exists in ").append(tableName$8).toString());
            }
        } else {
            throw new MatchError((Object)tuple3);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Inject
    public AdminService(DatabaseTablesRepository databaseTablesRepository, DataExplorerSettings tableSettings, ExecutionContext ec) {
        this.databaseTablesRepository = databaseTablesRepository;
        this.tableSettings = tableSettings;
        this.ec = ec;
    }
}

