/*
 * Decompiled with CFR 0.152.
 */
package net.wiringbits.webapp.utils.admin.repositories.daos;

import anorm.Column$;
import anorm.ParameterValue;
import anorm.ParameterValue$;
import anorm.SqlParser$;
import anorm.ToParameterValue$;
import anorm.ToStatement;
import anorm.ToStatement$;
import anorm.ToStatementPriority0;
import anorm.package;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.UUID;
import net.wiringbits.webapp.utils.admin.config.DataExplorerSettings;
import net.wiringbits.webapp.utils.admin.config.TableSettings;
import net.wiringbits.webapp.utils.admin.repositories.daos.package$;
import net.wiringbits.webapp.utils.admin.repositories.models.Cell;
import net.wiringbits.webapp.utils.admin.repositories.models.DatabaseTable;
import net.wiringbits.webapp.utils.admin.repositories.models.TableField;
import net.wiringbits.webapp.utils.admin.repositories.models.TableMetadata;
import net.wiringbits.webapp.utils.admin.repositories.models.TableRow;
import net.wiringbits.webapp.utils.admin.utils.models.ordering.package;
import net.wiringbits.webapp.utils.admin.utils.models.pagination.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class DatabaseTablesDAO$ {
    public static final DatabaseTablesDAO$ MODULE$ = new DatabaseTablesDAO$();

    public List<DatabaseTable> all(String schema, Connection conn) {
        ParameterValue[] parameterValueArray = new ParameterValue[1];
        ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)schema, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        return (List)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    SELECT table_name\n    FROM information_schema.tables\n    WHERE table_schema = ", "\n      AND table_type = 'BASE TABLE'\n    ORDER BY table_name\n    "}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(package$.MODULE$.tableParser().$times(), conn);
    }

    public String all$default$1() {
        return "public";
    }

    public List<DatabaseTable> getTablesInSettings(DataExplorerSettings tableSettings) {
        return tableSettings.tables().map((Function1 & Serializable)table -> {
            String tableName = table.tableName();
            return new Tuple2(table, (Object)tableName);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String tableName = (String)tuple2._2();
            DatabaseTable databaseTable = new DatabaseTable(tableName);
            return databaseTable;
        });
    }

    public List<TableField> getTableFields(String tableName, Connection conn) {
        List list;
        String arg$macro$1 = tableName;
        String sql = StringOps$.MODULE$.format$extension("SELECT * FROM %s LIMIT 0", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1}));
        try (PreparedStatement preparedStatement = conn.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            ResultSetMetaData metadata = resultSet.getMetaData();
            int numberOfColumns = metadata.getColumnCount();
            int columnNullable = 1;
            IndexedSeq fields = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numberOfColumns).map((Function1 & Serializable)columnNumber -> DatabaseTablesDAO$.$anonfun$getTableFields$1(metadata, columnNullable, BoxesRunTime.unboxToInt((Object)columnNumber))).map((Function1 & Serializable)x$2 -> {
                Tuple4 tuple4 = x$2;
                if (tuple4 == null) {
                    throw new MatchError((Object)tuple4);
                }
                String columnName = (String)tuple4._2();
                String columnType = (String)tuple4._3();
                boolean isNullable = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
                TableField tableField = new TableField(columnName, columnType, isNullable);
                return tableField;
            });
            list = fields.toList();
        }
        return list;
    }

    public package.PaginatedResult<TableMetadata> getTableData(String tableName, List<TableField> fields, package.PaginatedQuery pagination, DataExplorerSettings tableSettings, Connection conn) {
        package.PaginatedResult<TableMetadata> paginatedResult;
        ListBuffer tableData = new ListBuffer();
        int indexOfTable = tableSettings.tables().indexWhere((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DatabaseTablesDAO$.$anonfun$getTableData$1(tableName, x$3)));
        package.OrderingCondition defaultOrderBy = ((TableSettings)tableSettings.tables().apply(indexOfTable)).defaultOrderByClause();
        int numberOfRecords = this.countRecordsOnTable(tableName, conn);
        String SQL = new java.lang.StringBuilder(76).append("\n        SELECT * FROM ").append(tableName).append("\n        ORDER BY ?\n        LIMIT ? OFFSET ?\n        ").toString();
        PreparedStatement preparedStatement = conn.prepareStatement(SQL);
        preparedStatement.setString(1, defaultOrderBy.string());
        preparedStatement.setInt(2, pagination.limit().int());
        preparedStatement.setInt(3, pagination.offset().int());
        ResultSet resultSet = preparedStatement.executeQuery();
        try {
            while (resultSet.next()) {
                List rowData = fields.map((Function1 & Serializable)field -> {
                    String fieldName = field.name();
                    String data = resultSet.getString(fieldName);
                    return new Tuple3(field, (Object)fieldName, (Object)data);
                }).map((Function1 & Serializable)x$4 -> {
                    Tuple3 tuple3 = x$4;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    String data = (String)tuple3._3();
                    Cell cell = new Cell((String)Option$.MODULE$.apply((Object)data).getOrElse((Function0 & Serializable)() -> "null"));
                    return cell;
                });
                tableData.$plus$eq((Object)new TableRow((List<Cell>)rowData));
            }
            TableMetadata table = new TableMetadata(tableName, fields, (List<TableRow>)tableData.toList());
            paginatedResult = new package.PaginatedResult<TableMetadata>(table, new package.Offset(pagination.offset().int()), new package.Limit(pagination.limit().int()), new package.Count(numberOfRecords));
        }
        finally {
            resultSet.close();
            preparedStatement.close();
        }
        return paginatedResult;
    }

    public List<TableField> getMandatoryFields(String tableName, DataExplorerSettings tableSettings, Connection conn) {
        ListBuffer mandatoryFields = new ListBuffer();
        String idFieldName = ((TableSettings)tableSettings.tables().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DatabaseTablesDAO$.$anonfun$getMandatoryFields$1(tableName, x$5))).get()).idFieldName();
        String SQL = "\n      SELECT column_name, is_nullable, \n        column_default, data_type\n      FROM information_schema.columns\n      WHERE table_schema = 'public'\n        AND table_name = ?\n      ORDER BY column_name\n      ";
        PreparedStatement preparedStatement = conn.prepareStatement(SQL);
        preparedStatement.setObject(1, tableName);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            BoxedUnit boxedUnit;
            boolean isObligatory;
            String columnName = resultSet.getString("column_name");
            String columnType = resultSet.getString("data_type");
            Option defaultValue = Option$.MODULE$.apply((Object)resultSet.getString("column_default"));
            String string = resultSet.getString("is_nullable");
            String string2 = "YES";
            boolean isNullable = !(string != null ? !string.equals(string2) : string2 != null);
            boolean bl = isObligatory = !isNullable && defaultValue.isEmpty();
            if (isObligatory) {
                String string3 = columnName;
                String string4 = idFieldName;
                if (string3 == null ? string4 != null : !string3.equals(string4)) {
                    boxedUnit = mandatoryFields.$plus$eq((Object)new TableField(columnName, columnType, isNullable));
                    continue;
                }
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return mandatoryFields.toList();
    }

    public TableRow find(String tableName, String ID, DataExplorerSettings tableSettings, Connection conn) {
        String idFieldName = ((TableSettings)tableSettings.tables().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DatabaseTablesDAO$.$anonfun$find$1(tableName, x$6))).get()).idFieldName();
        String SQL = new java.lang.StringBuilder(51).append("\n      SELECT *\n      FROM ").append(tableName).append("\n      WHERE ").append(idFieldName).append(" = ?\n      ").toString();
        PreparedStatement preparedStatement = conn.prepareStatement(SQL);
        preparedStatement.setObject(1, UUID.fromString(ID));
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        int numberOfColumns = resultSet.getMetaData().getColumnCount();
        IndexedSeq row = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numberOfColumns).map((Function1 & Serializable)columnNumber -> DatabaseTablesDAO$.$anonfun$find$2(resultSet, BoxesRunTime.unboxToInt((Object)columnNumber))).map((Function1 & Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String cellData = (String)tuple2._2();
            Cell cell = new Cell((String)Option$.MODULE$.apply((Object)cellData).getOrElse((Function0 & Serializable)() -> "null"));
            return cell;
        });
        return new TableRow((List<Cell>)row.toList());
    }

    public void create(String tableName, Map<String, String> body, DataExplorerSettings tableSettings, Connection conn) {
        String idFieldName = ((TableSettings)tableSettings.tables().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DatabaseTablesDAO$.$anonfun$create$1(tableName, x$8))).get()).idFieldName();
        StringBuilder sqlFields = new StringBuilder(idFieldName);
        StringBuilder sqlValues = new StringBuilder("?");
        body.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DatabaseTablesDAO$.$anonfun$create$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$9 -> {
            Tuple2 tuple2 = x$9;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            sqlFields.append(new java.lang.StringBuilder(2).append(", ").append(key).toString());
            StringBuilder stringBuilder = sqlValues.append(", ?");
            return stringBuilder;
        });
        String SQL = new java.lang.StringBuilder(69).append("\n      INSERT INTO ").append(tableName).append("\n        (").append((CharSequence)sqlFields).append(")\n      VALUES (\n        ").append(sqlValues.toString()).append("\n      )\n      ").toString();
        PreparedStatement preparedStatement = conn.prepareStatement(SQL);
        preparedStatement.setObject(1, UUID.randomUUID());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), body.size() + 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            String value = (String)body.apply(body.keys().toList().apply(i - 2));
            preparedStatement.setObject(i, value);
        });
        int n = preparedStatement.executeUpdate();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public void update(String tableName, String id, DataExplorerSettings tableSettings, Map<String, String> body, Connection conn) {
        String idFieldName = ((TableSettings)tableSettings.tables().find((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)DatabaseTablesDAO$.$anonfun$update$1(tableName, x$11))).get()).idFieldName();
        StringBuilder updateStatement = new StringBuilder("SET");
        body.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)DatabaseTablesDAO$.$anonfun$update$2(check$ifrefutable$2))).foreach((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            StringBuilder stringBuilder = updateStatement.append(new java.lang.StringBuilder(6).append(" ").append(name).append(" = ?,").toString());
            return stringBuilder;
        });
        updateStatement.deleteCharAt(updateStatement.length() - 1);
        String SQL = new java.lang.StringBuilder(45).append("\n      UPDATE ").append(tableName).append("\n      ").append((CharSequence)updateStatement).append("\n      WHERE ").append(idFieldName).append(" = ?\n      ").toString();
        PreparedStatement preparedStatement = conn.prepareStatement(SQL);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), body.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            String value = (String)body.apply(body.keys().toList().apply(i - 1));
            preparedStatement.setObject(i, value);
        });
        preparedStatement.setObject(body.size() + 1, UUID.fromString(id));
        int n = preparedStatement.executeUpdate();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public void delete(String tableName, String id, DataExplorerSettings tableSettings, Connection conn) {
        String idFieldName = ((TableSettings)tableSettings.tables().find((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)DatabaseTablesDAO$.$anonfun$delete$1(tableName, x$14))).get()).idFieldName();
        String sql = new java.lang.StringBuilder(43).append("\n      DELETE FROM ").append(tableName).append("\n      WHERE ").append(idFieldName).append(" = ?\n      ").toString();
        PreparedStatement preparedStatement = conn.prepareStatement(sql);
        preparedStatement.setObject(1, UUID.fromString(id));
        int n = preparedStatement.executeUpdate();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public int countRecordsOnTable(String tableName, Connection conn) {
        ParameterValue[] parameterValueArray = new ParameterValue[1];
        ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)tableName, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        return BoxesRunTime.unboxToInt((Object)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      SELECT COUNT(*)\n      FROM #", "\n       "}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.int("count", Column$.MODULE$.columnToInt()).single(), conn));
    }

    public static final /* synthetic */ Tuple4 $anonfun$getTableFields$1(ResultSetMetaData metadata$1, int columnNullable$1, int columnNumber) {
        String columnName = metadata$1.getColumnName(columnNumber);
        String columnType = metadata$1.getColumnTypeName(columnNumber);
        boolean isNullable = metadata$1.isNullable(columnNumber) == columnNullable$1;
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)columnNumber), (Object)columnName, (Object)columnType, (Object)BoxesRunTime.boxToBoolean((boolean)isNullable));
    }

    public static final /* synthetic */ boolean $anonfun$getTableData$1(String tableName$1, TableSettings x$3) {
        String string = x$3.tableName();
        String string2 = tableName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getMandatoryFields$1(String tableName$2, TableSettings x$5) {
        String string = x$5.tableName();
        String string2 = tableName$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$find$1(String tableName$3, TableSettings x$6) {
        String string = x$6.tableName();
        String string2 = tableName$3;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ Tuple2 $anonfun$find$2(ResultSet resultSet$2, int columnNumber) {
        String cellData = resultSet$2.getString(columnNumber);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)columnNumber), (Object)cellData);
    }

    public static final /* synthetic */ boolean $anonfun$create$1(String tableName$4, TableSettings x$8) {
        String string = x$8.tableName();
        String string2 = tableName$4;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$create$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$update$1(String tableName$5, TableSettings x$11) {
        String string = x$11.tableName();
        String string2 = tableName$5;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$update$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$delete$1(String tableName$6, TableSettings x$14) {
        String string = x$14.tableName();
        String string2 = tableName$6;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private DatabaseTablesDAO$() {
    }
}

