/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.example.components;

import com.topografix.gpx.x1.x1.GpxDocument;
import com.topografix.gpx.x1.x1.TrkType;
import com.topografix.gpx.x1.x1.TrksegType;
import com.topografix.gpx.x1.x1.WptType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.wirelabs.jmaps.map.geo.Coordinate;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPXParser {
    private static final Logger log = LoggerFactory.getLogger(GPXParser.class);

    public List<Coordinate> parseToGeoPosition(File file) {
        return this.parseGpxFile(file).stream().map(this::trackPointToCoordinate).collect(Collectors.toList());
    }

    private Coordinate trackPointToCoordinate(WptType trackPoint) {
        Coordinate coordinate = trackPoint.getEle() == null ? new Coordinate(trackPoint.getLon().doubleValue(), trackPoint.getLat().doubleValue()) : new Coordinate(trackPoint.getLon().doubleValue(), trackPoint.getLat().doubleValue(), trackPoint.getEle().doubleValue());
        return coordinate;
    }

    public List<WptType> parseGpxFile(File file) {
        try {
            GpxDocument gpxDocument = (GpxDocument)GpxDocument.Factory.parse(file);
            List<TrkType> tracks = gpxDocument.getGpx().getTrkList();
            ArrayList<WptType> result = new ArrayList<WptType>();
            if (!tracks.isEmpty()) {
                for (TrkType track : tracks) {
                    track.getTrksegList().stream().map(TrksegType::getTrkptList).forEach(result::addAll);
                }
                return result;
            }
        }
        catch (IOException | XmlException e) {
            log.warn("File does not contain a gpx track");
        }
        return Collections.emptyList();
    }
}

