/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map.readers;

import java.io.File;
import java.io.IOException;
import net.wirelabs.jmaps.map.exceptions.CriticalMapException;
import net.wirelabs.jmaps.model.map.MapDocument;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapReader {
    private static final Logger log = LoggerFactory.getLogger(MapReader.class);

    public static MapDocument loadMapDefinitionFile(File mapDefinitionFile) {
        try {
            return (MapDocument)MapDocument.Factory.parse(mapDefinitionFile);
        }
        catch (IOException | XmlException e) {
            log.error("Could not load map definition: {}", (Object)e.getMessage());
            throw new CriticalMapException("Could not load map definition!\nDetails: check logs");
        }
    }

    private MapReader() {
    }
}

