/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map.geo;

import net.wirelabs.jmaps.map.geo.Coordinate;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.ProjCoordinate;

public class ProjectionEngine {
    private CoordinateReferenceSystem crs;
    private final ProjCoordinate projectionResult = new ProjCoordinate();
    private final ProjCoordinate projectionSource = new ProjCoordinate();
    private final CRSFactory csFactory = new CRSFactory();

    public void setCrs(String crsName) {
        this.crs = this.csFactory.createFromName(crsName);
    }

    public Coordinate project(Coordinate coord) {
        this.projectionSource.setValue(coord.getLongitude(), coord.getLatitude(), coord.getAltitude());
        this.crs.getProjection().project(this.projectionSource, this.projectionResult);
        return new Coordinate(this.projectionResult.x, this.projectionResult.y, this.projectionResult.z);
    }

    public Coordinate unproject(Coordinate coord) {
        this.projectionSource.setValue(coord.getLongitude(), coord.getLatitude(), coord.getAltitude());
        this.crs.getProjection().inverseProject(this.projectionSource, this.projectionResult);
        return new Coordinate(this.projectionResult.x, this.projectionResult.y, this.projectionResult.z);
    }

    public double getEquatorLength() {
        return this.crs.getProjection().getEllipsoid().equatorRadius * (Math.PI * 2);
    }

    public double getPolarLength() {
        return this.crs.getProjection().getEllipsoid().poleRadius * (Math.PI * 2);
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    public ProjCoordinate getProjectionResult() {
        return this.projectionResult;
    }

    public ProjCoordinate getProjectionSource() {
        return this.projectionSource;
    }

    public CRSFactory getCsFactory() {
        return this.csFactory;
    }
}

