/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map.downloader;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import net.wirelabs.jmaps.map.MapViewer;
import net.wirelabs.jmaps.map.downloader.TileProvider;
import net.wirelabs.jmaps.map.downloader.TileProviderThreadFactory;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadingTileProvider
implements TileProvider {
    private static final Logger log = LoggerFactory.getLogger(DownloadingTileProvider.class);
    private final OkHttpClient httpClient = new OkHttpClient();
    private final List<String> tilesLoading = new CopyOnWriteArrayList<String>();
    private final MapViewer mapViewer;
    private ExecutorService executorService;

    public DownloadingTileProvider(MapViewer mapViewer) {
        this.mapViewer = mapViewer;
    }

    private ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = Executors.newFixedThreadPool(this.mapViewer.getTilerThreads(), new TileProviderThreadFactory());
        }
        return this.executorService;
    }

    void download(String tileUrl) {
        log.debug("Getting from: {}", (Object)tileUrl);
        Request r = new Request.Builder().url(tileUrl).header("User-Agent", this.mapViewer.getUserAgent()).get().build();
        try {
            Response response = this.httpClient.newCall(r).execute();
            if (response.isSuccessful()) {
                this.readAndCacheImage(tileUrl, response);
            }
            response.close();
        }
        catch (Exception e) {
            log.debug("Could not download {} - {} : {}", tileUrl, e.getClass().getSimpleName(), e.getMessage());
        }
        catch (OutOfMemoryError e) {
            log.error("DANG! Local memory cache run out of memory");
            log.error("Prunning memory cache...");
            this.mapViewer.getPrimaryTileCache().clear();
        }
        this.tilesLoading.remove(tileUrl);
    }

    private void readAndCacheImage(String tileUrl, Response response) throws IOException {
        try (ResponseBody body = response.body();){
            InputStream inputStream2 = body.byteStream();
            Optional<BufferedImage> image = Optional.ofNullable(ImageIO.read(inputStream2));
            if (image.isPresent()) {
                this.mapViewer.getPrimaryTileCache().put(tileUrl, image.get());
                if (this.secondaryCacheEnabled()) {
                    this.mapViewer.getSecondaryTileCache().put(tileUrl, image.get());
                }
                this.tilesLoading.remove(tileUrl);
                this.mapViewer.repaint();
            }
        }
    }

    @Override
    public BufferedImage getTile(String url) {
        Optional<BufferedImage> image;
        Optional<BufferedImage> img = Optional.ofNullable(this.mapViewer.getPrimaryTileCache().get(url));
        if (img.isPresent()) {
            return img.get();
        }
        if (this.secondaryCacheEnabled() && (image = Optional.ofNullable(this.mapViewer.getSecondaryTileCache().get(url))).isPresent()) {
            this.mapViewer.getPrimaryTileCache().put(url, image.get());
            return image.get();
        }
        if (!this.tilesLoading.contains(url)) {
            this.tilesLoading.add(url);
            this.getExecutorService().submit(() -> this.download(url));
        }
        return null;
    }

    private boolean secondaryCacheEnabled() {
        return this.mapViewer.getSecondaryTileCache() != null;
    }
}

