/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import net.wirelabs.jmaps.map.layer.Layer;

public class MapObject {
    private String mapName = "[no name defined]";
    private String mapCopyrightAttribution = "[no attribution in definition]";
    private final List<Layer> layers = new CopyOnWriteArrayList<Layer>();

    public Layer getBaseLayer() {
        return this.layers.get(0);
    }

    public boolean layersPresent() {
        return !this.layers.isEmpty();
    }

    public List<Layer> getEnabledLayers() {
        return this.layers.stream().filter(Layer::isEnabled).collect(Collectors.toList());
    }

    public int getMaxZoom() {
        return this.layers.stream().map(layer -> layer.getMaxZoom() - layer.getZoomOffset()).mapToInt(v -> v).min().orElse(0);
    }

    public int getMinZoom() {
        return this.layers.stream().map(Layer::getMinZoom).mapToInt(val2 -> val2).max().orElse(0);
    }

    public boolean isMultilayer() {
        return this.layers.size() > 1;
    }

    public void addLayer(Layer layer) {
        this.layers.add(layer);
    }

    public String getMapName() {
        return this.mapName;
    }

    public String getMapCopyrightAttribution() {
        return this.mapCopyrightAttribution;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public void setMapName(String mapName) {
        this.mapName = mapName;
    }

    public void setMapCopyrightAttribution(String mapCopyrightAttribution) {
        this.mapCopyrightAttribution = mapCopyrightAttribution;
    }
}

