/*
 * Decompiled with CFR 0.152.
 */
package net.wirelabs.jmaps.map;

import java.io.File;
import net.wirelabs.jmaps.map.MapObject;
import net.wirelabs.jmaps.map.exceptions.CriticalMapException;
import net.wirelabs.jmaps.map.layer.Layer;
import net.wirelabs.jmaps.map.layer.LayerType;
import net.wirelabs.jmaps.map.readers.MapReader;
import net.wirelabs.jmaps.model.map.LayerDocument;
import net.wirelabs.jmaps.model.map.MapDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapCreator {
    private static final Logger log = LoggerFactory.getLogger(MapCreator.class);

    public MapObject createMap(File xmlMapFile) {
        MapObject map = new MapObject();
        MapDocument mapDefinition = MapReader.loadMapDefinitionFile(xmlMapFile);
        log.info("Creating map: [{}]", (Object)mapDefinition.getMap().getName());
        map.setMapName(mapDefinition.getMap().getName());
        map.setMapCopyrightAttribution(mapDefinition.getMap().getCopyright());
        for (LayerDocument.Layer layerDefinition : mapDefinition.getMap().getLayerList()) {
            Layer mapLayer = this.createMapLayer(layerDefinition);
            if (this.layerMatchesExistingLayers(map, mapLayer)) {
                map.addLayer(mapLayer);
                log.info("Added layer {}, CRS:{}, TileSize:{}", mapLayer.getName(), mapLayer.getProjectionEngine().getCrs(), mapLayer.getTileSize());
                continue;
            }
            log.error("Layer not added!");
        }
        return map;
    }

    private Layer createMapLayer(LayerDocument.Layer layerDefinition) {
        try {
            LayerType type = LayerType.valueOf(layerDefinition.getType());
            return type.layer.getDeclaredConstructor(LayerDocument.Layer.class).newInstance(layerDefinition);
        }
        catch (Exception e) {
            log.info("Layer type not given or unknown");
            throw new CriticalMapException("Layer type not given or unknown");
        }
    }

    private boolean layerMatchesExistingLayers(MapObject map, Layer layerAdded) {
        for (Layer existingLayer : map.getLayers()) {
            if (layerAdded.getName().equals(existingLayer.getName())) {
                log.warn("Layer mismatch: layer named {} already exists", (Object)layerAdded.getName());
                return false;
            }
            if (layerAdded.getTileSize() != existingLayer.getTileSize()) {
                log.warn("Layer mismatch: {} [tilesize]", (Object)layerAdded.getName());
                return false;
            }
            if (layerAdded.getProjectionEngine().getCrs().equals(existingLayer.getProjectionEngine().getCrs())) continue;
            log.warn("Layer mismatch: {} [crs]", (Object)layerAdded.getName());
            return false;
        }
        return true;
    }
}

