/*
 * Decompiled with CFR 0.152.
 */
package net.winroad.htmldoclet4jdk8;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.doclets.internal.toolkit.util.ClassTree;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.javadoc.Main;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.winroad.htmldoclet4jdk8.ConfigurationImpl;
import net.winroad.wrdoclet.AbstractDoclet;
import net.winroad.wrdoclet.data.OpenAPI;
import net.winroad.wrdoclet.data.WRDoc;
import net.winroad.wrdoclet.doc.API;
import net.winroad.wrdoclet.doc.Doc;
import net.winroad.wrdoclet.doc.DocData;
import net.winroad.wrdoclet.taglets.WRMemoTaglet;
import net.winroad.wrdoclet.taglets.WRReturnCodeTaglet;
import net.winroad.wrdoclet.taglets.WRTagTaglet;
import net.winroad.wrdoclet.utils.Logger;
import net.winroad.wrdoclet.utils.LoggerFactory;
import net.winroad.wrdoclet.utils.Util;
import org.apache.commons.lang.StringUtils;
import org.pegdown.PegDownProcessor;

public class HtmlDoclet
extends AbstractDoclet {
    public ConfigurationImpl configurationEx;
    private PegDownProcessor pegDownProcessor;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public HtmlDoclet() {
        this.configurationEx = (ConfigurationImpl)this.configuration();
        this.pegDownProcessor = new PegDownProcessor();
    }

    public static boolean start(RootDoc root) {
        try {
            HtmlDoclet doclet = new HtmlDoclet();
            boolean bl = doclet.start(doclet, root);
            return bl;
        }
        finally {
            ConfigurationImpl.reset();
        }
    }

    public void resetConfiguration() {
        ConfigurationImpl.reset();
    }

    public Configuration configuration() {
        return ConfigurationImpl.getInstance();
    }

    protected DocData generateDocData(WRDoc wrDoc) {
        DocData result = new DocData();
        ArrayList tagList = new ArrayList(wrDoc.getWRTags());
        Collator cmp = Collator.getInstance(Locale.CHINA);
        Collections.sort(tagList, cmp);
        for (String tag : tagList) {
            result.getFacet_counts().getFacet_fields().addTagField(tag, ((List)wrDoc.getTaggedOpenAPIs().get(tag)).size());
            Doc doc = new Doc();
            doc.setTag(tag);
            for (OpenAPI openAPI : (List)wrDoc.getTaggedOpenAPIs().get(tag)) {
                API api = new API();
                api.setUrl(openAPI.getRequestMapping().getUrl());
                api.setTooltip(openAPI.getRequestMapping().getTooltip());
                api.setMethodType(openAPI.getRequestMapping().getMethodType());
                String filename = this.generateWRAPIFileName(openAPI.getRequestMapping());
                api.setFilepath(filename);
                api.setBrief(openAPI.getBrief());
                doc.getAPIs().add(api);
            }
            result.addDoc(doc);
        }
        return result;
    }

    public void generateWRDocFiles(RootDoc root, WRDoc wrDoc) throws Exception {
        if (this.configurationEx.noframe) {
            this.generateWRNoFrameFile(root, wrDoc);
        } else {
            this.generateWRFrameFiles(root, wrDoc);
        }
        this.generatePackageFiles(root, wrDoc);
    }

    protected void generatePackageFiles(RootDoc root, WRDoc wrDoc) {
        PackageDoc[] packageDocs;
        for (PackageDoc pdoc : packageDocs = root.specifiedPackages()) {
            Tag[] ts;
            if (!StringUtils.isNotBlank((String)pdoc.commentText())) continue;
            String html = this.pegDownProcessor.markdownToHtml(pdoc.commentText());
            HashMap<String, String> tagMap = new HashMap<String, String>();
            tagMap.put("branchName", this.configurationEx.branchname);
            tagMap.put("systemName", this.configurationEx.systemname);
            String tags = WRTagTaglet.concatToString((Tag[])pdoc.tags("tag"));
            if (StringUtils.isBlank((String)tags)) {
                tagMap.put("tags", pdoc.name());
            } else {
                tagMap.put("tags", tags);
            }
            tagMap.put("APIUrl", pdoc.name());
            if (StringUtils.isWhitespace((String)this.configurationEx.buildid) || this.configurationEx.buildid.equalsIgnoreCase("time")) {
                tagMap.put("buildID", wrDoc.getDocGeneratedTime());
            } else {
                tagMap.put("buildID", this.configurationEx.buildid);
            }
            this.logger.info((CharSequence)("buildid:" + (String)tagMap.get("buildID")));
            tagMap.put("bodyContent", html);
            for (Tag t : ts = pdoc.tags("tag")) {
                if (wrDoc.getTaggedOpenAPIs().containsKey(t.name())) continue;
                wrDoc.getTaggedOpenAPIs().put(t.name(), new LinkedList());
            }
            this.configurationEx.getWriterFactory().getFreemarkerWriter().generateHtmlFile("packageInfo.ftl", tagMap, this.configurationEx.destDirName, pdoc.name() + ".html");
        }
    }

    protected void generateWRNoFrameFile(RootDoc root, WRDoc wrDoc) throws Exception {
        HashMap<String, Map> tagMap = new HashMap<String, Map>();
        tagMap.put("tagedOpenAPIs", wrDoc.getTaggedOpenAPIs());
        this.configurationEx.getWriterFactory().getFreemarkerWriter().generateHtmlFile("wrNoFrame.ftl", tagMap, this.configurationEx.destDirName, "index.html");
        this.generateCommonFiles(root);
    }

    protected void generateWRFrameFiles(RootDoc root, WRDoc wrDoc) throws Exception {
        this.generateIndexFile(root, wrDoc);
        this.generateWRAPIDetailFiles(root, wrDoc);
        this.generateCommonFiles(root);
    }

    protected void generateIndexFile(RootDoc root, WRDoc wrDoc) throws Exception {
        ArrayList tagList = new ArrayList(wrDoc.getWRTags());
        Collator cmp = Collator.getInstance(Locale.CHINA);
        Collections.sort(tagList, cmp);
        HashMap<String, String> tagMap = new HashMap<String, String>();
        DocData bean = this.generateDocData(wrDoc);
        Gson gson = new Gson();
        tagMap.put("response", gson.toJson((Object)bean));
        tagMap.put("searchengine", this.configurationEx.searchengine);
        this.configurationEx.getWriterFactory().getFreemarkerWriter().generateHtmlFile("index.ftl", tagMap, this.configurationEx.destDirName, null);
    }

    protected void generateCommonFiles(RootDoc root) throws Exception {
        Util.copyResourceFolder((String)"/css/", (String)Util.combineFilePath((String)this.configurationEx.destDirName, (String)"css"));
        Util.copyResourceFolder((String)"/js/", (String)Util.combineFilePath((String)this.configurationEx.destDirName, (String)"js"));
        Util.copyResourceFolder((String)"/img/", (String)Util.combineFilePath((String)this.configurationEx.destDirName, (String)"img"));
    }

    protected void generateWRAPIDetailFiles(RootDoc root, WRDoc wrDoc) {
        ArrayList tagList = new ArrayList(wrDoc.getWRTags());
        for (String tag : tagList) {
            List openAPIList = (List)wrDoc.getTaggedOpenAPIs().get(tag);
            HashSet<String> filesGenerated = new HashSet<String>();
            for (OpenAPI openAPI : openAPIList) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("openAPI", openAPI);
                ObjectMapper mapper = new ObjectMapper();
                mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
                String oasJSONStr = null;
                try {
                    oasJSONStr = mapper.writeValueAsString((Object)this.convertToOAS(openAPI, this.configurationEx.branchname));
                }
                catch (JsonProcessingException e) {
                    this.logger.error((Throwable)e);
                }
                hashMap.put("OASV3", oasJSONStr);
                String tagsStr = openAPI.getTags().toString();
                hashMap.put("tags", tagsStr.substring(1, tagsStr.length() - 1));
                hashMap.put("generatedTime", wrDoc.getDocGeneratedTime());
                hashMap.put("branchName", this.configurationEx.branchname);
                hashMap.put("systemName", this.configurationEx.systemname);
                if (StringUtils.isWhitespace((String)this.configurationEx.buildid) || this.configurationEx.buildid.equalsIgnoreCase("time")) {
                    hashMap.put("buildID", wrDoc.getDocGeneratedTime());
                } else {
                    hashMap.put("buildID", this.configurationEx.buildid);
                }
                this.logger.info((CharSequence)("buildid:" + hashMap.get("buildID")));
                String filename = this.generateWRAPIFileName(openAPI.getRequestMapping());
                hashMap.put("filePath", filename);
                if (filesGenerated.contains(filename)) continue;
                this.configurationEx.getWriterFactory().getFreemarkerWriter().generateHtmlFile("wrAPIDetail.ftl", hashMap, this.configurationEx.destDirName, filename);
                filesGenerated.add(filename);
            }
        }
    }

    protected void generateClassFiles(ClassDoc[] arr, ClassTree classtree) {
        Arrays.sort(arr);
        for (int i = 0; i < arr.length; ++i) {
            if (!this.configurationEx.isGeneratedDoc(arr[i]) || !arr[i].isIncluded()) continue;
            ClassDoc prev = i == 0 ? null : arr[i - 1];
            ClassDoc curr = arr[i];
            ClassDoc next = i + 1 == arr.length ? null : arr[i + 1];
            try {
                if (curr.isAnnotationType()) {
                    AbstractBuilder annotationTypeBuilder = this.configurationEx.getBuilderFactory().getAnnotationTypeBuilder((AnnotationTypeDoc)curr, (Type)prev, (Type)next);
                    annotationTypeBuilder.build();
                    continue;
                }
                AbstractBuilder classBuilder = this.configurationEx.getBuilderFactory().getClassBuilder(curr, prev, next, classtree);
                classBuilder.build();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DocletAbortException(e.getMessage());
            }
        }
    }

    protected void generatePackageFiles(ClassTree arg0) throws Exception {
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        return ConfigurationImpl.getInstance().validOptions(options, reporter);
    }

    public static int optionLength(String option) {
        return ConfigurationImpl.getInstance().optionLength(option);
    }

    public static void main(String[] args) {
        String[] docArgs = new String[]{"-doclet", HtmlDoclet.class.getName(), "-docletpath", new File(System.getProperty("user.dir"), "target/classes").getAbsolutePath(), "-taglet", WRTagTaglet.class.getName(), WRMemoTaglet.class.getName(), WRReturnCodeTaglet.class.getName(), "-tagletpath", new File(System.getProperty("user.dir"), "target/classes").getAbsolutePath(), "-encoding", "utf-8", "-charset", "utf-8", "-sourcepath", "D:/Git/wrdoclet/wrdoclet-demosite/src/main/java", "net.winroad.Controller", "net.winroad.Models", "org.springframework.web.bind.annotation", "-classpath", new File(System.getProperty("user.home"), ".m2/repository/org/springframework/spring-web/3.2.3.RELEASE/spring-web-3.2.3.RELEASE.jar").getAbsolutePath(), "-d", new File(System.getProperty("user.dir"), "target/doc").getAbsolutePath()};
        Main.execute((String[])docArgs);
        System.out.println("Doc generated to: " + new File(System.getProperty("user.dir"), "target/doc").getAbsolutePath());
    }
}

