/*
 * Decompiled with CFR 0.152.
 */
package net.wildfyre.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class LazyMap<K, V>
implements Map<K, V> {
    private Map<K, V> map;

    public LazyMap() {
    }

    public LazyMap(int size) {
        this.map = new HashMap(size);
    }

    public LazyMap(Map<K, V> map) {
        if (map == null) {
            throw new NullPointerException("The parameter 'map' cannot be null.");
        }
        this.map = map;
    }

    public LazyMap(Collection<V> objects, Function<V, K> IDMapper) {
        this(objects.stream().collect(Collectors.toMap(IDMapper, o -> o)));
    }

    protected boolean isInitialized() {
        return this.map != null;
    }

    protected void requireInitialized() {
        if (!this.isInitialized()) {
            this.map = new HashMap();
        }
    }

    @Override
    public int size() {
        return this.isInitialized() ? this.map.size() : 0;
    }

    @Override
    public boolean isEmpty() {
        return !this.isInitialized() || this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.isInitialized() && this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.isInitialized() && this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.isInitialized() ? (V)this.map.get(key) : null;
    }

    @Override
    public V put(K key, V value) {
        this.requireInitialized();
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        if (this.isInitialized()) {
            V value = this.map.remove(key);
            if (this.map.isEmpty()) {
                this.map = null;
            }
            return value;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (!this.isInitialized()) {
            this.map = new HashMap<K, V>(m);
        } else {
            this.map.putAll(m);
        }
    }

    @Override
    public void clear() {
        this.map = null;
    }

    @Override
    public Set<K> keySet() {
        return this.isInitialized() ? this.map.keySet() : Collections.emptySet();
    }

    @Override
    public Collection<V> values() {
        return this.isInitialized() ? this.map.values() : Collections.emptyList();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.isInitialized() ? this.map.entrySet() : Collections.emptySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LazyMap lazyMap = (LazyMap)o;
        return Objects.equals(this.map, lazyMap.map);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.map);
    }
}

