/*
 * Decompiled with CFR 0.152.
 */
package net.wildfyre.utils;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.WriterConfig;
import java.util.Optional;

public class InvalidJsonException
extends Exception {
    private InvalidJsonException(String message) {
        super(message);
    }

    public static InvalidJsonException missingField(String field, JsonValue json) {
        return new InvalidJsonException("Missing field: '" + field + "' in JSON.\n" + json.toString(WriterConfig.PRETTY_PRINT));
    }

    public static JsonValue requireField(JsonObject json, String name) throws InvalidJsonException {
        JsonValue ret = json.get(name);
        if (ret != null && !ret.isNull()) {
            return ret;
        }
        throw InvalidJsonException.missingField(name, (JsonValue)json);
    }

    public static Optional<JsonValue> optionalField(JsonObject json, String name) {
        JsonValue ret = json.get(name);
        if (ret != null && !ret.isNull()) {
            return Optional.of(ret);
        }
        return Optional.empty();
    }
}

