/*
 * Decompiled with CFR 0.152.
 */
package net.wildfyre.users;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.WriterConfig;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import net.wildfyre.api.Internal;
import net.wildfyre.descriptors.CacheManager;
import net.wildfyre.descriptors.NoSuchEntityException;
import net.wildfyre.http.IssueInTransferException;
import net.wildfyre.http.Method;
import net.wildfyre.http.Request;
import net.wildfyre.users.LoggedUser;
import net.wildfyre.users.User;
import net.wildfyre.utils.LazyMap;

public class Users {
    static Map<Integer, User> users = Collections.emptyMap();
    private static int userId;
    private static final CacheManager manager;

    private Users() {
    }

    public static Optional<User> get(int id) {
        User user = Users.getCached(id).orElseGet(() -> User.create(id));
        try {
            if (user.isNew()) {
                users.put(id, user);
                user.update();
            }
        }
        catch (NoSuchEntityException e) {
            return Optional.empty();
        }
        catch (Request.CantConnectException e) {
            Internal.throwCantConnect(e);
            return Optional.empty();
        }
        if (!user.isValid()) {
            Internal.submitUpdate(user);
        }
        user.use();
        return Optional.of(user);
    }

    public static Optional<User> getCached(int id) {
        return Optional.ofNullable(users.get(id));
    }

    public static LoggedUser me() {
        return Users.get(userId).orElseThrow(RuntimeException::new).asLogged();
    }

    public static void clear() {
        users.clear();
    }

    public static void clean() {
        long time = System.currentTimeMillis();
        users.values().removeIf(u -> !u.isValid(time));
    }

    public static void reset() {
        userId = -1;
        users.clear();
    }

    public static void init() throws Request.CantConnectException {
        try {
            JsonObject json = new Request(Method.GET, "/users/").addToken(Internal.token()).getJson().asObject();
            userId = json.getInt("user", -1);
            if (userId == -1) {
                throw new RuntimeException("Couldn't find the ID of the logged-in user!\n" + json.toString(WriterConfig.PRETTY_PRINT));
            }
            users = new LazyMap<Integer, User>();
        }
        catch (IssueInTransferException e) {
            throw new RuntimeException("Couldn't find the ID of the logged-in user.", e);
        }
    }

    public static boolean isMyID(int id) {
        if (userId == -1) {
            System.err.println("Warning: calling Users#isMyID without initializing. Call Users#init or Internal#init.");
        }
        return userId == id;
    }

    public static OptionalInt myID() {
        return userId != -1 ? OptionalInt.of(userId) : OptionalInt.empty();
    }

    public static CacheManager cacheManager() {
        return manager;
    }

    static {
        manager = new CacheManager().setExpirationTime(1800000L);
    }
}

