/*
 * Decompiled with CFR 0.152.
 */
package net.wildfyre.users;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import net.wildfyre.descriptors.CacheManager;
import net.wildfyre.descriptors.Descriptor;
import net.wildfyre.descriptors.NoSuchEntityException;
import net.wildfyre.http.IssueInTransferException;
import net.wildfyre.http.Method;
import net.wildfyre.http.Request;
import net.wildfyre.users.LoggedUser;
import net.wildfyre.users.Users;

public class User
extends Descriptor {
    protected final int ID;
    protected String name = "";
    protected String avatar = "";
    protected String bio = "";
    protected boolean isBanned;

    User(int id) {
        this.ID = id;
    }

    @Override
    public void update() throws NoSuchEntityException, Request.CantConnectException {
        block4: {
            if (!Users.getCached(this.ID).isPresent()) {
                System.err.println("The user " + this.ID + " is not even in the cache, aborting update early.");
                return;
            }
            try {
                JsonObject values = new Request(Method.GET, "/users/" + this.ID + "/").getJson().asObject();
                this.name = values.getString("name", this.name);
                this.avatar = values.get("avatar").isString() ? values.getString("avatar", this.avatar) : null;
                this.bio = values.getString("bio", this.bio);
                this.isBanned = values.getBoolean("banned", this.isBanned);
                int user = values.getInt("user", this.ID);
                if (user != this.ID) {
                    throw new RuntimeException("The ID has changed! " + this.ID + " -> " + user);
                }
                this.use();
            }
            catch (IssueInTransferException e) {
                JsonValue j = e.getJson();
                if (j == null || !j.asObject().getString("detail", null).equals("Not found.")) break block4;
                Users.users.remove(this.ID);
                throw new NoSuchEntityException("The requested user does not exist!", this);
            }
        }
    }

    static User create(int id) {
        return Users.isMyID(id) ? new LoggedUser(id) : new User(id);
    }

    @Override
    public CacheManager cacheManager() {
        return Users.cacheManager();
    }

    public boolean canEdit() {
        return false;
    }

    public final LoggedUser asLogged() throws ClassCastException {
        this.use();
        return (LoggedUser)this;
    }

    public int getID() {
        this.use();
        return this.ID;
    }

    public Optional<String> avatar() {
        this.use();
        return Optional.ofNullable(this.avatar);
    }

    public Optional<URL> avatarUrl() {
        this.use();
        try {
            if (this.avatar != null) {
                return Optional.of(new URL(this.avatar));
            }
            return Optional.empty();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Since URLs are sent by the server, they shouldn't be malformed...", e);
        }
    }

    public String bio() {
        this.use();
        return this.bio;
    }

    public boolean isBanned() {
        this.use();
        return this.isBanned;
    }

    public String name() {
        this.use();
        return this.name;
    }

    public String toString() {
        return "User{ID=" + this.ID + ", name='" + this.name + '\'' + ", avatar='" + this.avatar + '\'' + ", bio='" + this.bio + '\'' + ", isBanned=" + this.isBanned + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.ID == user.ID && this.isBanned == user.isBanned && Objects.equals(this.name, user.name) && Objects.equals(this.avatar, user.avatar) && Objects.equals(this.bio, user.bio);
    }

    public int hashCode() {
        return Objects.hash(this.ID);
    }
}

