/*
 * Decompiled with CFR 0.152.
 */
package net.wildfyre.users;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.wildfyre.api.Internal;
import net.wildfyre.areas.Areas;
import net.wildfyre.descriptors.NoSuchEntityException;
import net.wildfyre.http.IssueInTransferException;
import net.wildfyre.http.Method;
import net.wildfyre.http.Request;
import net.wildfyre.posts.Post;
import net.wildfyre.users.User;

public class LoggedUser
extends User {
    LoggedUser(int id) {
        super(id);
    }

    @Override
    public boolean canEdit() {
        return true;
    }

    public void setBio(String bio) {
        this.set(null, bio, null);
    }

    public void setUsername(String username) {
        this.set(username, null, null);
    }

    public void setAvatar(String avatar) {
        this.set(null, null, avatar);
    }

    public void set(String username, String bio, String avatar) {
        JsonObject json = new JsonObject();
        if (username != null) {
            this.name = username;
            json.add("name", username);
        }
        if (bio != null) {
            this.bio = bio;
            json.add("bio", bio);
        }
        if (avatar != null) {
            this.avatar = avatar;
            json.add("avatar", avatar);
        }
        if (json.isEmpty()) {
            throw new NullPointerException("Every provided parameter was null, at least one should not be!");
        }
        Internal.submit(() -> {
            try {
                new Request(Method.PATCH, "/users/").addToken(Internal.token()).addJson((JsonValue)json).getJson();
                this.update();
            }
            catch (IssueInTransferException e) {
                throw new RuntimeException("Something unforeseen happened during the edition of the user.", e);
            }
            catch (NoSuchEntityException e) {
                throw new RuntimeException("Trying to edit a client that does not exist... this should not happen.", e);
            }
            catch (Request.CantConnectException e) {
                Internal.throwCantConnect(e);
            }
        });
    }

    public Stream<Post> posts() {
        return Areas.INSTANCE.collection().stream().flatMap(a -> a.ownPosts().stream());
    }

    public List<Post> postsList() {
        return this.posts().collect(Collectors.toList());
    }
}

