/*
 * Decompiled with CFR 0.152.
 */
package net.wildfyre.posts;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.wildfyre.areas.Area;
import net.wildfyre.areas.Areas;
import net.wildfyre.descriptors.Descriptor;
import net.wildfyre.posts.Comment;
import net.wildfyre.posts.Post;
import net.wildfyre.users.User;
import net.wildfyre.users.Users;
import net.wildfyre.utils.InvalidJsonException;

abstract class PostData
extends Descriptor {
    boolean isAnonymous;
    boolean hasSubscribed;
    ZonedDateTime created;
    boolean isActive;
    String text;
    String imageURL;
    String[] additionalImages;
    int authorID;
    String areaID;
    long postID;
    List<Comment> comments;

    PostData() {
        this.isAnonymous = false;
        this.hasSubscribed = true;
        this.created = ZonedDateTime.now(ZoneId.ofOffset("UTC", ZoneOffset.UTC));
        this.isActive = true;
        this.text = null;
        this.imageURL = null;
        this.additionalImages = new String[0];
        this.authorID = Users.myID().orElseThrow(() -> new NullPointerException("The creation of this objectrequires that the library is initialized, and that the ID of the user is known."));
        this.areaID = null;
        this.postID = -1L;
        this.comments = Collections.emptyList();
    }

    PostData(PostData other) {
        this.update(other);
    }

    void update(JsonObject json) throws InvalidJsonException {
        this.postID = Long.parseLong(InvalidJsonException.requireField(json, "id").asString());
        this.authorID = !json.get("author").isNull() ? InvalidJsonException.requireField(InvalidJsonException.requireField(json, "author").asObject(), "user").asInt() : -1;
        this.isAnonymous = InvalidJsonException.requireField(json, "anonym").asBoolean();
        this.hasSubscribed = InvalidJsonException.requireField(json, "subscribed").asBoolean();
        this.created = ZonedDateTime.parse(InvalidJsonException.requireField(json, "created").asString());
        this.isActive = InvalidJsonException.requireField(json, "active").asBoolean();
        this.text = InvalidJsonException.requireField(json, "text").asString();
        this.imageURL = InvalidJsonException.optionalField(json, "image").orElse(Json.value((String)"")).asString();
        JsonArray imgs = InvalidJsonException.requireField(json, "additional_images").asArray();
        this.additionalImages = new String[imgs.size()];
        for (int i = 0; i < imgs.size(); ++i) {
            this.additionalImages[i] = imgs.get(i).asString();
        }
        if (Post.class.isAssignableFrom(this.getClass())) {
            JsonArray cmts = InvalidJsonException.requireField(json, "comments").asArray();
            this.comments = cmts.values().stream().map(j -> new Comment((Post)this, j.asObject())).collect(Collectors.toList());
        } else {
            this.comments = Collections.emptyList();
        }
    }

    private void update(PostData other) {
        this.isAnonymous = other.isAnonymous;
        this.hasSubscribed = other.hasSubscribed;
        this.created = other.created;
        this.isActive = other.isActive;
        this.text = other.text;
        this.imageURL = other.imageURL;
        this.additionalImages = other.additionalImages;
        this.authorID = other.authorID;
        this.areaID = other.areaID;
        this.postID = other.postID;
        this.comments = new ArrayList<Comment>(this.comments);
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public boolean hasSubscribed() {
        return this.hasSubscribed;
    }

    public boolean isAuthorDeleted() {
        return !Users.get(this.authorID).isPresent() && !this.isAnonymous;
    }

    public ZonedDateTime created() {
        return this.created;
    }

    public ZonedDateTime createdLocalTime() {
        return this.created.withZoneSameInstant(ZoneId.systemDefault());
    }

    public boolean isActive() {
        return this.isActive;
    }

    public String text() {
        return this.text;
    }

    public Optional<User> author() {
        return this.authorID == -1 ? Optional.empty() : Optional.of(Users.get(this.authorID).orElseThrow(() -> new RuntimeException("Couldn't find the author of this post!\n" + this.toString())));
    }

    public Area area() {
        return Areas.INSTANCE.get(this.areaID).orElseThrow(() -> new RuntimeException("Couldn't find the area in which this post was created!\n" + this.toString()));
    }

    public long ID() {
        return this.postID;
    }

    public List<Comment> commentsList() {
        return Collections.unmodifiableList(this.comments);
    }

    public Stream<Comment> comments() {
        return this.comments.stream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostData postData = (PostData)o;
        return this.isAnonymous == postData.isAnonymous && this.hasSubscribed == postData.hasSubscribed && this.isActive == postData.isActive && this.authorID == postData.authorID && this.postID == postData.postID && Objects.equals(this.created, postData.created) && Objects.equals(this.text, postData.text) && Objects.equals(this.imageURL, postData.imageURL) && Arrays.equals(this.additionalImages, postData.additionalImages) && Objects.equals(this.areaID, postData.areaID) && Objects.equals(this.comments, postData.comments);
    }

    public int hashCode() {
        return Objects.hash(this.areaID, this.postID);
    }

    public String toString() {
        return "PostData{isAnonymous=" + this.isAnonymous + ", hasSubscribed=" + this.hasSubscribed + ", created=" + this.created + ", isActive=" + this.isActive + ", text='" + this.text + '\'' + ", imageURL='" + this.imageURL + '\'' + ", additionalImages=" + Arrays.toString(this.additionalImages) + ", authorID=" + this.authorID + ", areaID='" + this.areaID + '\'' + ", postID=" + this.postID + ", comments=" + this.comments + '}';
    }

    protected final JsonObject toJsonSimple() {
        JsonArray images = new JsonArray();
        for (String s : this.additionalImages) {
            images.add(s);
        }
        return new JsonObject().add("anonym", this.isAnonymous).add("subscribed", this.hasSubscribed).add("created", this.created.format(DateTimeFormatter.ISO_DATE_TIME)).add("text", this.text).add("image", this.imageURL).add("additional_images", (JsonValue)images);
    }

    static interface Setters<P extends PostData> {
        public P setIsAnonymous(boolean var1);

        public P subscribe();

        public P unsubscribe();

        public P setText(String var1);

        public void delete();
    }
}

