/*
 * Decompiled with CFR 0.152.
 */
package net.wildfyre.posts;

import com.eclipsesource.json.JsonObject;
import net.wildfyre.api.Internal;
import net.wildfyre.descriptors.CacheManager;
import net.wildfyre.descriptors.NoSuchEntityException;
import net.wildfyre.http.IssueInTransferException;
import net.wildfyre.http.Method;
import net.wildfyre.http.Request;
import net.wildfyre.posts.PostData;
import net.wildfyre.utils.InvalidJsonException;

public class Post
extends PostData {
    private static CacheManager cacheManager = new CacheManager().setExpirationTime(600000L);

    public Post(long ID, String areaID) {
        if (ID < 0L) {
            throw new IllegalArgumentException("The ID of a post cannot be negative: " + ID);
        }
        if (areaID == null || areaID.isEmpty()) {
            throw new IllegalArgumentException("The ID of the area cannot be 'null' or empty: '" + areaID + "'");
        }
        this.postID = ID;
        this.areaID = areaID;
    }

    Post(PostData p) {
        super(p);
    }

    @Override
    public CacheManager cacheManager() {
        return cacheManager;
    }

    public static CacheManager getCacheManager() {
        return cacheManager;
    }

    @Override
    public void update() throws NoSuchEntityException, Request.CantConnectException {
        try {
            JsonObject json = new Request(Method.GET, "/areas/" + this.areaID + "/" + this.postID + "/").addToken(Internal.token()).getJson().asObject();
            super.update(json);
        }
        catch (IssueInTransferException e) {
            e.ifDetailsAre("Not found.", () -> {
                throw new NoSuchEntityException("This object was deleted.", this);
            });
        }
        catch (InvalidJsonException e) {
            throw new RuntimeException(e);
        }
    }
}

