/*
 * Decompiled with CFR 0.152.
 */
package net.wildfyre.posts;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Optional;
import net.wildfyre.api.Internal;
import net.wildfyre.areas.Area;
import net.wildfyre.areas.Areas;
import net.wildfyre.descriptors.CacheManager;
import net.wildfyre.http.IssueInTransferException;
import net.wildfyre.http.Method;
import net.wildfyre.http.Request;
import net.wildfyre.posts.Post;
import net.wildfyre.posts.PostData;
import net.wildfyre.users.Users;
import net.wildfyre.utils.InvalidJsonException;

public class Draft
extends PostData
implements PostData.Setters<Draft> {
    private boolean isOnlyLocal;
    private static final CacheManager manager = new CacheManager().setExpirationTime(3600000L);

    public Draft(String areaID) {
        if (areaID == null || areaID.equals("")) {
            throw new IllegalArgumentException("The parameter areaID should not be null nor empty: '" + areaID + "'");
        }
        this.areaID = areaID;
        this.authorID = Users.myID().orElseThrow(RuntimeException::new);
        this.isOnlyLocal = true;
    }

    public Draft(long draftID, String areaID) {
        if (areaID == null || areaID.equals("")) {
            throw new IllegalArgumentException("The parameter areaID should not be null nor empty: '" + areaID + "'");
        }
        if (draftID <= 0L) {
            throw new IllegalArgumentException("The parameter draftID should be a positive integer: " + draftID);
        }
        this.areaID = areaID;
        this.postID = draftID;
        this.isOnlyLocal = false;
    }

    public Post publish() {
        JsonObject json = this.isOnlyLocal ? this.createAndPublish() : this.publishDraft();
        try {
            this.update(json);
        }
        catch (InvalidJsonException e) {
            throw new RuntimeException();
        }
        return new Post(this);
    }

    JsonObject createAndPublish() {
        try {
            return new Request(Method.POST, "/areas/" + this.areaID + "/").addToken(Internal.token()).addJson((JsonValue)this.toJsonSimple()).getJson().asObject();
        }
        catch (IssueInTransferException e) {
            throw new RuntimeException();
        }
        catch (Request.CantConnectException e) {
            throw new RuntimeException();
        }
    }

    JsonObject publishDraft() {
        try {
            return new Request(Method.POST, "/areas/" + this.areaID + "/drafts/" + this.postID + "/publish/").addToken(Internal.token()).getJson().asObject();
        }
        catch (IssueInTransferException e) {
            throw new RuntimeException();
        }
        catch (Request.CantConnectException e) {
            throw new RuntimeException();
        }
    }

    public Draft save() {
        if (this.isOnlyLocal) {
            this.saveFirstTime();
        } else {
            this.saveAsEdit();
            this.isOnlyLocal = false;
        }
        return this;
    }

    void saveFirstTime() {
        try {
            JsonObject json = new Request(Method.POST, "/areas/" + this.areaID + "/drafts/").addToken(Internal.token()).addJson((JsonValue)this.toJsonSimple()).getJson().asObject();
            this.update(json);
            this.area().cachedDraft(this);
        }
        catch (IssueInTransferException e) {
            e.printStackTrace();
        }
        catch (Request.CantConnectException e) {
            e.printStackTrace();
        }
        catch (InvalidJsonException e) {
            e.printStackTrace();
        }
    }

    void saveAsEdit() {
        try {
            new Request(Method.PATCH, "/areas/" + this.areaID + "/drafts/" + this.postID + "/").addToken(Internal.token()).addJson((JsonValue)this.toJsonSimple()).getJson();
        }
        catch (IssueInTransferException e) {
            e.printStackTrace();
        }
        catch (Request.CantConnectException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void delete() {
        if (this.isOnlyLocal) {
            this.deleteLocal();
        } else {
            this.deleteServerSide();
        }
    }

    void deleteLocal() {
        Optional<Area> area = Areas.INSTANCE.get(this.areaID);
        if (!area.isPresent()) {
            throw new RuntimeException("It looks like this Draft doesn't belong to any area... this should not happen. The area ID used is '" + this.areaID + "'");
        }
        area.get().removeCached(this);
    }

    void deleteServerSide() {
        this.deleteLocal();
        try {
            new Request(Method.DELETE, "/areas/" + this.areaID + "/drafts/" + this.postID).addToken(Internal.token()).getJson();
        }
        catch (IssueInTransferException e) {
            e.printStackTrace();
        }
        catch (Request.CantConnectException e) {
            e.printStackTrace();
        }
    }

    @Override
    public CacheManager cacheManager() {
        return manager;
    }

    public static CacheManager getCacheManager() {
        return manager;
    }

    @Override
    public void update() {
    }

    @Override
    public Draft setIsAnonymous(boolean isAnonymous) {
        this.isAnonymous = isAnonymous;
        return this;
    }

    @Override
    public Draft subscribe() {
        this.hasSubscribed = true;
        return this;
    }

    @Override
    public Draft unsubscribe() {
        this.hasSubscribed = false;
        return this;
    }

    @Override
    public Draft setText(String newText) {
        this.text = newText;
        return this;
    }
}

