/*
 * Decompiled with CFR 0.152.
 */
package net.wildfyre.posts;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import net.wildfyre.areas.Area;
import net.wildfyre.areas.Areas;
import net.wildfyre.posts.Post;
import net.wildfyre.users.User;
import net.wildfyre.users.Users;
import net.wildfyre.utils.InvalidJsonException;
import net.wildfyre.utils.ProgrammingException;

public class Comment {
    private int ID;
    private ZonedDateTime created;
    private String text;
    private String imageURL;
    private String areaID;
    private long postID;
    private int authorID;

    Comment(Post parent, JsonObject json) {
        if (parent == null) {
            throw new NullPointerException("The parent object should not be null.");
        }
        this.areaID = parent.areaID;
        this.postID = parent.postID;
        try {
            this.update(json);
        }
        catch (InvalidJsonException e) {
            throw new IllegalArgumentException("There was an issue in JSON data.", e);
        }
    }

    void update(JsonObject json) throws InvalidJsonException {
        this.ID = InvalidJsonException.requireField(json, "id").asInt();
        this.authorID = InvalidJsonException.requireField(InvalidJsonException.requireField(json, "author").asObject(), "user").asInt();
        this.created = ZonedDateTime.parse(InvalidJsonException.requireField(json, "created").asString());
        this.text = InvalidJsonException.requireField(json, "text").asString();
        this.imageURL = InvalidJsonException.optionalField(json, "image").orElse(Json.value((String)"")).asString();
    }

    public int ID() {
        return this.ID;
    }

    public ZonedDateTime created() {
        return this.created;
    }

    public String text() {
        return this.text;
    }

    public Optional<String> imageURL() {
        return Optional.ofNullable(this.imageURL);
    }

    public Area area() {
        return Areas.INSTANCE.get(this.areaID).orElseThrow(RuntimeException::new);
    }

    public Post post() {
        Post tmp = this.area().post(this.postID);
        if (tmp != null) {
            return tmp;
        }
        throw new ProgrammingException("The post must exist.");
    }

    public User author() {
        return Users.get(this.authorID).orElseThrow(RuntimeException::new);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Comment comment = (Comment)o;
        return this.ID == comment.ID && this.postID == comment.postID && this.authorID == comment.authorID && Objects.equals(this.created, comment.created) && Objects.equals(this.text, comment.text) && Objects.equals(this.imageURL, comment.imageURL) && Objects.equals(this.areaID, comment.areaID);
    }

    public int hashCode() {
        return this.ID;
    }

    public String toString() {
        return "Comment{ID=" + this.ID + ", created=" + this.created + ", text='" + this.text + '\'' + ", imageURL='" + this.imageURL + '\'' + ", areaID='" + this.areaID + '\'' + ", postID=" + this.postID + ", authorID=" + this.authorID + '}';
    }
}

