/*
 * Decompiled with CFR 0.152.
 */
package net.wildfyre.http;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.wildfyre.api.Internal;
import net.wildfyre.http.DataType;
import net.wildfyre.http.IssueInTransferException;
import net.wildfyre.http.Method;
import net.wildfyre.utils.ProgrammingException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 52\u00020\u0001:\u000245B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0012J\u0010\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u001b\u001a\u00020\u0005J\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u001fJ\u0015\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\"J\b\u0010#\u001a\u00020\u0012H\u0007J\u0015\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b'J\u0006\u0010(\u001a\u00020\u0012J\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020,J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u001dH\u0002J\b\u00100\u001a\u00020\u001dH\u0002J\u0014\u00101\u001a\u00020.*\u0002022\u0006\u00103\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000bj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lnet/wildfyre/http/Request;", "", "method", "Lnet/wildfyre/http/Method;", "address", "", "(Lnet/wildfyre/http/Method;Ljava/lang/String;)V", "fileOutput", "Ljava/io/File;", "fileOutputName", "headers", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getHeaders$wflib_java", "()Ljava/util/HashMap;", "id", "", "jsonOutput", "Lcom/eclipsesource/json/JsonValue;", "requestUrl", "Ljava/net/URL;", "addFile", "name", "file", "addJson", "params", "addToken", "token", "connect", "Ljava/net/HttpURLConnection;", "url", "connect$wflib_java", "convertToByteArray", "", "convertToByteArray$wflib_java", "get", "getInputStream", "Ljava/io/InputStream;", "connection", "getInputStream$wflib_java", "getJson", "getJsonArray", "Lcom/eclipsesource/json/JsonArray;", "getJsonObject", "Lcom/eclipsesource/json/JsonObject;", "multipart", "", "conn", "send", "write", "Ljava/io/DataOutputStream;", "msg", "CantConnectException", "Companion", "wflib-java"})
@SuppressFBWarnings(justification="The static variable 'reqId' is marked as Synchronized to avoid any problems.", value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
public final class Request {
    private final URL requestUrl;
    @NotNull
    private final HashMap<String, String> headers;
    private JsonValue jsonOutput;
    private File fileOutput;
    private String fileOutputName;
    private final int id;
    private final Method method;
    private final String address;
    private static final String API_URL = "https://api.wildfyre.net";
    private static final String API_URL_TESTING = "http://localhost:8000";
    private static final boolean isTesting;
    @JvmField
    @NotNull
    public static final Charset CHARSET;
    private static int reqId;
    public static final Companion Companion;

    @NotNull
    public final HashMap<String, String> getHeaders$wflib_java() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HttpURLConnection send() {
        Object object;
        Object object2;
        HttpURLConnection conn = this.connect$wflib_java(this.requestUrl);
        conn.setDoInput(true);
        String string = "" + '\n' + this.id + ':' + (Object)((Object)this.method) + ' ' + this.requestUrl + " HTTP/1.1";
        System.out.println((Object)string);
        this.method.setMethod(conn, this);
        int i = 0;
        Object object3 = this.headers;
        Iterator iterator = object3.entrySet().iterator();
        while (iterator.hasNext()) {
            object = object2 = iterator.next();
            String header = (String)object.getKey();
            object = object2;
            String value = (String)object.getValue();
            int n = i;
            i = n + 1;
            object = "" + this.id + ':' + n + " - " + header + ": " + value;
            System.out.println(object);
            conn.setRequestProperty(header, value);
        }
        if (this.fileOutput != null) {
            this.multipart(conn);
        } else {
            JsonValue jsonValue = this.jsonOutput;
            if (jsonValue != null) {
                JsonValue it = object2 = jsonValue;
                conn.setRequestProperty("Content-Type", DataType.JSON.toString());
                object3 = "" + this.id + ':' + i + " - Content-Type: " + (Object)((Object)DataType.JSON);
                System.out.println(object3);
                conn.setDoOutput(true);
                object3 = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream(), CHARSET));
                Throwable throwable = null;
                try {
                    BufferedWriter bw = (BufferedWriter)object3;
                    it.writeTo((Writer)bw);
                    object = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
                }
            }
        }
        object2 = this.id + ": Done sending.";
        System.out.println(object2);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void multipart(HttpURLConnection conn) {
        Object $receiver;
        Object object;
        Object object2;
        DataOutputStream writer;
        String boundary;
        String hyphens;
        String endl;
        block21: {
            String string = this.id + ": This is a multipart request";
            System.out.println((Object)string);
            endl = "\r\n";
            hyphens = "--";
            boundary = "----" + System.currentTimeMillis() + "---";
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            OutputStream output = conn.getOutputStream();
            writer = new DataOutputStream(output);
            writer.flush();
            JsonValue jsonValue = this.jsonOutput;
            if (jsonValue == null) break block21;
            object2 = jsonValue;
            JsonValue it = object2;
            object = this.id + ": There is some JSON attached";
            System.out.println(object);
            JsonObject jsonObject = it.asObject();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"it.asObject()");
            Iterable $receiver$iv = (Iterable)jsonObject;
            for (Object element$iv : $receiver$iv) {
                String string2;
                String string3;
                Object v;
                Object object3;
                JsonObject.Member obj;
                block23: {
                    block22: {
                        obj = (JsonObject.Member)element$iv;
                        this.write(writer, hyphens + boundary + endl);
                        StringBuilder stringBuilder = new StringBuilder().append("Content-Disposition: form-data; name=\"");
                        JsonObject.Member member = obj;
                        Intrinsics.checkExpressionValueIsNotNull((Object)member, (String)"obj");
                        this.write(writer, stringBuilder.append(member.getName()).append('\"').append(endl).toString());
                        JsonValue jsonValue2 = obj.getValue();
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsonValue2, (String)"obj.value");
                        if (jsonValue2.isArray()) break block22;
                        JsonValue jsonValue3 = obj.getValue();
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsonValue3, (String)"obj.value");
                        if (!jsonValue3.isObject()) break block23;
                    }
                    this.write(writer, "Content-Type: " + (Object)((Object)DataType.JSON) + "; charset=" + CHARSET + endl);
                    this.write(writer, endl);
                    object3 = new BufferedWriter(new OutputStreamWriter((OutputStream)writer, CHARSET));
                    Throwable throwable = null;
                    try {
                        BufferedWriter bw = (BufferedWriter)object3;
                        it.writeTo((Writer)bw);
                        bw = Unit.INSTANCE;
                    }
                    catch (Throwable bw) {
                        throwable = bw;
                        throw bw;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
                    }
                    this.write(writer, endl);
                    continue;
                }
                this.write(writer, "Content-Type: " + (Object)((Object)DataType.TEXT) + "; charset=" + CHARSET + endl);
                this.write(writer, endl);
                object3 = obj.getValue();
                DataOutputStream dataOutputStream = writer;
                Request request = this;
                Object object4 = v = object3;
                Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"v");
                if (object4.isTrue()) {
                    string3 = "true";
                } else if (v.isFalse()) {
                    string3 = "false";
                } else if (v.isNull()) {
                    string3 = "null";
                } else if (v.isNumber()) {
                    string3 = v.asString();
                } else if (v.isString()) {
                    string3 = v.asString();
                } else {
                    throw (Throwable)new ProgrammingException("Found " + v + " which doesn't match any type.", null, 2, null);
                }
                String string4 = string2 = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"obj.value.let { v ->\n   \u2026  }\n                    }");
                request.write(dataOutputStream, string4);
                this.write(writer, endl);
            }
        }
        File file = this.fileOutput;
        if (file != null) {
            Object file2 = object2 = file;
            this.write(writer, hyphens + boundary + endl);
            this.write(writer, "Content-Disposition: form-data; name=\"" + this.fileOutputName + "\"; filename=\"" + ((File)file2).getName() + '\"' + endl);
            this.write(writer, "Content-Type: " + URLConnection.guessContentTypeFromName(((File)file2).getName()) + endl);
            this.write(writer, endl);
            object = file2;
            $receiver = object = new FileInputStream((File)object);
            byte[] $receiver$iv = ByteStreamsKt.readBytes$default((InputStream)((InputStream)$receiver), (int)0, (int)1, null);
            int n = $receiver$iv.length;
            for (int i = 0; i < n; ++i) {
                byte element$iv;
                byte it = element$iv = $receiver$iv[i];
                writer.writeByte(it);
            }
        } else {
            throw (Throwable)new NullPointerException("This method has been called with a fileOutput=" + this.fileOutput + ", " + "but this should not be possible.");
        }
        ((FileInputStream)$receiver).close();
        this.write(writer, endl);
        this.write(writer, hyphens + boundary + hyphens + endl);
        writer.flush();
        writer.close();
    }

    @NotNull
    public final Request addToken(@NotNull String token) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Map map = this.headers;
        String string = "Authorization";
        String string2 = "token " + token;
        map.put(string, string2);
        return this;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Request addToken$default(Request request, String string, int n, Object object) {
        if ((n & 1) != 0) {
            String string2 = Internal.token();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Internal.token()");
            string = string2;
        }
        return request.addToken(string);
    }

    @NotNull
    public final Request addJson(@NotNull JsonValue params) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        this.jsonOutput = params;
        return this;
    }

    @NotNull
    public final Request addFile(@NotNull String name, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.fileOutput = file;
        this.fileOutputName = name;
        return this;
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="getJson"), message="Deprecated because of implicit data type request, use Request.getJson instead.")
    @NotNull
    public final JsonValue get() throws IssueInTransferException {
        return this.getJson();
    }

    @NotNull
    public final JsonValue getJson() throws IssueInTransferException {
        Map map = this.headers;
        String string = "Accept";
        String string2 = DataType.JSON.toString();
        map.put(string, string2);
        return Companion.readJson(this.getInputStream$wflib_java(this.send()));
    }

    @NotNull
    public final JsonObject getJsonObject() {
        JsonValue jsonValue = this.getJson();
        if (jsonValue == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.eclipsesource.json.JsonObject");
        }
        return (JsonObject)jsonValue;
    }

    @NotNull
    public final JsonArray getJsonArray() {
        JsonValue jsonValue = this.getJson();
        if (jsonValue == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.eclipsesource.json.JsonArray");
        }
        return (JsonArray)jsonValue;
    }

    @NotNull
    public final HttpURLConnection connect$wflib_java(@NotNull URL url) throws CantConnectException {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        try {
            URLConnection uRLConnection = url.openConnection();
            if (uRLConnection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            return (HttpURLConnection)uRLConnection;
        }
        catch (IOException e) {
            throw (Throwable)new CantConnectException("Cannot connect to the server.", e);
        }
    }

    @NotNull
    public final byte[] convertToByteArray$wflib_java(@NotNull JsonValue params) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        try {
            String string = params.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"params.toString()");
            String string2 = string;
            Charset charset = CHARSET;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            return byArray;
        }
        catch (UnsupportedEncodingException e) {
            throw (Throwable)new RuntimeException("There was a problem with the character encoding '" + CHARSET + "'." + "Because it is hard-written in the class, this error should never happen.", e);
        }
    }

    @NotNull
    public final InputStream getInputStream$wflib_java(@NotNull HttpURLConnection connection) throws IssueInTransferException {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        try {
            String string = this.id + ": Beginning reception... HTTP Status: " + connection.getResponseCode();
            System.out.println((Object)string);
            InputStream inputStream = connection.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"connection.inputStream");
            return inputStream;
        }
        catch (IOException e) {
            String string = this.id + ": The server refused the request.";
            InputStream inputStream = connection.getErrorStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"connection.errorStream");
            throw (Throwable)new IssueInTransferException(string, inputStream);
        }
    }

    private final void write(@NotNull DataOutputStream $receiver, String msg) {
        String string = msg;
        Charset charset = CHARSET;
        DataOutputStream dataOutputStream = $receiver;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        dataOutputStream.write(byArray2);
    }

    public Request(@NotNull Method method, @NotNull String address) throws CantConnectException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)method), (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        this.method = method;
        this.address = address;
        this.requestUrl = new URL(Companion.getUrl$wflib_java() + this.address);
        this.headers = new HashMap();
        int n = reqId;
        reqId = n + 1;
        this.id = n;
        Map map = this.headers;
        String string = "From";
        String string2 = "lib-java";
        map.put(string, string2);
        map = this.headers;
        string = "Host";
        String string3 = this.requestUrl.getHost();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"requestUrl.host");
        string2 = string3;
        map.put(string, string2);
    }

    static {
        Companion = new Companion(null);
        isTesting = Intrinsics.areEqual((Object)System.getProperty("org.gradle.test.worker", "default"), (Object)"default") ^ true;
        CHARSET = Charsets.UTF_8;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/wildfyre/http/Request$CantConnectException;", "Ljava/io/IOException;", "msg", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Ljava/lang/Exception;)V", "wflib-java"})
    public static final class CantConnectException
    extends IOException {
        public CantConnectException(@NotNull String msg, @NotNull Exception e) {
            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            super(msg, e);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\nR\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lnet/wildfyre/http/Request$Companion;", "", "()V", "API_URL", "", "API_URL_TESTING", "CHARSET", "Ljava/nio/charset/Charset;", "isTesting", "", "()Z", "<set-?>", "", "reqId", "url", "getUrl$wflib_java", "()Ljava/lang/String;", "readJson", "Lcom/eclipsesource/json/JsonValue;", "input", "Ljava/io/InputStream;", "wflib-java"})
    public static final class Companion {
        public final boolean isTesting() {
            return isTesting;
        }

        @NotNull
        public final String getUrl$wflib_java() {
            return Companion.isTesting() ? Request.API_URL_TESTING : Request.API_URL;
        }

        @NotNull
        public final JsonValue readJson(@NotNull InputStream input) throws IssueInTransferException {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            try {
                JsonValue jsonValue = Json.parse((Reader)new InputStreamReader(input, CHARSET));
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonValue, (String)"Json.parse(\n            \u2026      )\n                )");
                return jsonValue;
            }
            catch (UnsupportedEncodingException e) {
                throw (Throwable)new RuntimeException("There was an encoding error. Since the encoding is hardcoded in Request.CHARSET, this error should never occur. Please report to the developers with the full stacktrace.", e);
            }
            catch (IOException e) {
                throw (Throwable)new IssueInTransferException("There was an I/O error while parsing the JSON data, or the server refused the request.", e);
            }
            catch (ParseException e) {
                try {
                    String content = new BufferedReader(new InputStreamReader(input, CHARSET)).lines().collect(Collectors.joining("\n"));
                    throw (Throwable)new RuntimeException("The content of the InputStream was not a JSON object:\n" + content + "\nSize: " + content.length(), e);
                }
                catch (UnsupportedEncodingException e1) {
                    throw (Throwable)new RuntimeException("This should never happen: Request.CHARSET is wrong.", e1);
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

