/*
 * Decompiled with CFR 0.152.
 */
package net.wildfyre.descriptors;

import net.wildfyre.descriptors.CacheManager;
import net.wildfyre.descriptors.NoSuchEntityException;
import net.wildfyre.http.Request;

public abstract class Descriptor {
    private long lastUsage;
    private boolean isNew;

    public Descriptor() {
        this.use();
        this.isNew = true;
    }

    public boolean isValid(long currentTime) {
        return currentTime - this.lastUsage < this.cacheManager().objectsExpireAfter();
    }

    public final boolean isValid() {
        return this.isValid(System.currentTimeMillis());
    }

    public final boolean isNew() {
        return this.isNew;
    }

    public final void use() {
        this.lastUsage = System.currentTimeMillis();
        this.isNew = false;
    }

    public abstract CacheManager cacheManager();

    public abstract void update() throws NoSuchEntityException, Request.CantConnectException;
}

