/*
 * Decompiled with CFR 0.152.
 */
package net.wildfyre.areas;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.WriterConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.wildfyre.api.Internal;
import net.wildfyre.areas.Area;
import net.wildfyre.descriptors.CacheManager;
import net.wildfyre.http.Method;
import net.wildfyre.http.Request;
import net.wildfyre.utils.LazyMap;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012J\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0086\u0002J\u0006\u0010\u0016\u001a\u00020\u000fJ\u0006\u0010\u0017\u001a\u00020\u000fR&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/wildfyre/areas/Areas;", "", "()V", "areas", "", "", "Lnet/wildfyre/areas/Area;", "getAreas$wflib_java", "()Ljava/util/Map;", "setAreas$wflib_java", "(Ljava/util/Map;)V", "manager", "Lnet/wildfyre/descriptors/CacheManager;", "cacheManager", "clean", "", "clear", "collection", "", "get", "Ljava/util/Optional;", "areaID", "init", "load", "wflib-java"})
@SuppressFBWarnings(justification="FindBugs displays this warning because it doesn't understand Kotlin's objects.", value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
public final class Areas {
    @NotNull
    private static Map<String, Area> areas;
    private static final CacheManager manager;
    public static final Areas INSTANCE;

    @NotNull
    public final Map<String, Area> getAreas$wflib_java() {
        return areas;
    }

    public final void setAreas$wflib_java(@NotNull Map<String, Area> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        areas = map;
    }

    public final void init() throws Request.CantConnectException {
        this.load();
        Iterable $receiver$iv = this.collection();
        for (Object element$iv : $receiver$iv) {
            Area it = (Area)element$iv;
            it.loadDrafts();
            it.loadOwnPosts();
        }
    }

    public final void load() throws Request.CantConnectException {
        Request request = new Request(Method.GET, "/areas/");
        String string = Internal.token();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Internal.token()");
        JsonArray json = request.addToken(string).getJsonArray();
        areas = new LazyMap(json.size());
        Iterable $receiver$iv = (Iterable)json;
        for (Object element$iv : $receiver$iv) {
            Area area;
            JsonValue area2;
            JsonValue jsonValue = area2 = (JsonValue)element$iv;
            if (jsonValue == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.eclipsesource.json.JsonObject");
            }
            JsonObject it = (JsonObject)jsonValue;
            Object object = it.get("name");
            if (object == null || (object = object.asString()) == null) {
                throw (Throwable)new NullPointerException("Cannot have a 'null' area:\n" + json.toString(WriterConfig.PRETTY_PRINT));
            }
            Object name = object;
            JsonValue jsonValue2 = it.get("displayname");
            String displayName = jsonValue2 != null ? jsonValue2.asString() : null;
            Map<String, Area> map = areas;
            Intrinsics.checkExpressionValueIsNotNull((Object)INSTANCE.get((String)name).orElseGet(new Supplier<Area>((String)name, displayName){
                final /* synthetic */ String $name;
                final /* synthetic */ String $displayName;

                @NotNull
                public final Area get() {
                    return new Area(this.$name, this.$displayName);
                }
                {
                    this.$name = string;
                    this.$displayName = string2;
                }
            }), (String)"get(name).orElseGet { Area(name, displayName) }");
            map.put((String)name, area);
        }
    }

    @NotNull
    public final Optional<Area> get(@NotNull String areaID) {
        Intrinsics.checkParameterIsNotNull((Object)areaID, (String)"areaID");
        Optional<Area> optional = Optional.ofNullable(areas.get(areaID));
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.ofNullable(areas[areaID])");
        return optional;
    }

    @NotNull
    public final Collection<Area> collection() {
        Collection<Area> collection = Collections.unmodifiableCollection(areas.values());
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"Collections.unmodifiableCollection(areas.values)");
        return collection;
    }

    public final void clear() {
        areas.clear();
    }

    @NotNull
    public final CacheManager cacheManager() {
        CacheManager cacheManager = manager;
        Intrinsics.checkExpressionValueIsNotNull((Object)cacheManager, (String)"manager");
        return cacheManager;
    }

    public final void clean() {
        long time = System.currentTimeMillis();
        areas.values().removeIf(new Predicate<Area>(time){
            final /* synthetic */ long $time;

            public final boolean test(@NotNull Area it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return !it.isValid(this.$time);
            }
            {
                this.$time = l;
            }
        });
    }

    private Areas() {
    }

    static {
        Areas areas;
        INSTANCE = areas = new Areas();
        Areas.areas = new HashMap(0);
        manager = new CacheManager().setExpirationTime(3600000);
    }
}

