/*
 * Decompiled with CFR 0.152.
 */
package net.wildfyre.areas;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.WriterConfig;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.wildfyre.api.Internal;
import net.wildfyre.areas.Area;
import net.wildfyre.areas.Areas;
import net.wildfyre.descriptors.CacheManager;
import net.wildfyre.descriptors.Descriptor;
import net.wildfyre.descriptors.NoSuchEntityException;
import net.wildfyre.http.IssueInTransferException;
import net.wildfyre.http.Method;
import net.wildfyre.http.Request;
import net.wildfyre.posts.Draft;
import net.wildfyre.posts.Post;
import net.wildfyre.utils.LazyMap;
import net.wildfyre.utils.ProgrammingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010!\u001a\u00020\"H\u0016J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0011J\u0010\u0010&\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0002\u001a\u00020\u0010J\u0006\u0010%\u001a\u00020\u0011J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0096\u0002J\b\u0010+\u001a\u00020\fH\u0016J\u0006\u0010,\u001a\u00020$J\u0006\u0010-\u001a\u00020$J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018J\u0010\u0010/\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0002\u001a\u00020\u0010J\u000e\u00100\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0011J\b\u00101\u001a\u00020\u0003H\u0016J\b\u00102\u001a\u00020$H\u0016R\u001c\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001e\u00a8\u00063"}, d2={"Lnet/wildfyre/areas/Area;", "Lnet/wildfyre/descriptors/Descriptor;", "id", "", "displayName", "(Ljava/lang/String;Ljava/lang/String;)V", "ID", "ID$annotations", "()V", "getID", "()Ljava/lang/String;", "_reputation", "", "_spread", "drafts", "", "", "Lnet/wildfyre/posts/Draft;", "<set-?>", "name", "getName", "setName", "(Ljava/lang/String;)V", "ownPostsIDs", "", "posts", "Lnet/wildfyre/utils/LazyMap;", "Lnet/wildfyre/posts/Post;", "reputation", "getReputation", "()I", "spread", "getSpread", "cacheManager", "Lnet/wildfyre/descriptors/CacheManager;", "cachedDraft", "", "draft", "cachedPost", "equals", "", "other", "", "hashCode", "loadDrafts", "loadOwnPosts", "ownPosts", "post", "removeCached", "toString", "update", "wflib-java"})
public final class Area
extends Descriptor {
    @NotNull
    private final String ID;
    @NotNull
    private String name;
    private int _reputation;
    private int _spread;
    private final LazyMap<Long, Post> posts;
    private final Map<Long, Draft> drafts;
    private List<Long> ownPostsIDs;

    public static /* synthetic */ void ID$annotations() {
    }

    @NotNull
    public final String getID() {
        return this.ID;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    private final void setName(String string) {
        this.name = string;
    }

    public final int getReputation() {
        if (this._reputation == -1) {
            this.update();
        }
        return this._reputation;
    }

    public final int getSpread() {
        if (this._spread == -1) {
            this.update();
        }
        return this._spread;
    }

    @Override
    @NotNull
    public CacheManager cacheManager() {
        return Areas.INSTANCE.cacheManager();
    }

    @Override
    public void update() throws Request.CantConnectException, NoSuchEntityException {
        try {
            Request request = new Request(Method.GET, "/areas/" + this.ID + "/rep/");
            String string = Internal.token();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Internal.token()");
            JsonObject json = request.addToken(string).getJson().asObject();
            JsonValue jsonValue = json.get("reputation");
            if (jsonValue == null) {
                throw (Throwable)new ProgrammingException("Missing reputation.\n" + json.toString(WriterConfig.PRETTY_PRINT), null, 2, null);
            }
            this._reputation = jsonValue.asInt();
            JsonValue jsonValue2 = json.get("spread");
            if (jsonValue2 == null) {
                throw (Throwable)new ProgrammingException("Missing spread.\n" + json.toString(WriterConfig.PRETTY_PRINT), null, 2, null);
            }
            this._spread = jsonValue2.asInt();
        }
        catch (IssueInTransferException e) {
            JsonValue jsonValue = e.getJson();
            if (Intrinsics.areEqual(jsonValue != null && (jsonValue = jsonValue.asObject()) != null && (jsonValue = jsonValue.get("detail")) != null ? jsonValue.asString() : null, (Object)"Not found.")) {
                Areas.INSTANCE.getAreas$wflib_java().remove(this.ID);
                throw (Throwable)new NoSuchEntityException("This Area was deleted server-side.", this);
            }
            throw (Throwable)new RuntimeException("An unforeseen error happened while updating an Area.", e);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        Area area = (Area)other;
        return this.getReputation() == area.getReputation() && this.getSpread() == area.getSpread() && Intrinsics.areEqual((Object)this.ID, (Object)area.ID);
    }

    public int hashCode() {
        return Objects.hash(this.ID);
    }

    @NotNull
    public String toString() {
        return "Area{id='" + this.ID + "'" + ", reputation=" + this._reputation + ", spread=" + this._spread + "}";
    }

    @Nullable
    public final Post post(long id) {
        Post post = this.cachedPost(id);
        if (post == null) {
            post = new Post(id, this.ID);
        }
        Post post2 = post;
        try {
            if (post2.isNew()) {
                Map map = this.posts;
                Long l = id;
                Post post3 = post2;
                map.put(l, post3);
                post2.update();
            }
        }
        catch (NoSuchEntityException e) {
            return null;
        }
        catch (Request.CantConnectException e) {
            Internal.throwCantConnect(e);
            return null;
        }
        if (!post2.isValid()) {
            Internal.submitUpdate((Descriptor)post2);
        }
        post2.use();
        return post2;
    }

    @Nullable
    public final Post cachedPost(long id) {
        return this.posts.get(id);
    }

    public final void loadDrafts() throws Request.CantConnectException {
        try {
            this.drafts.clear();
            Request request = new Request(Method.GET, "/areas/" + this.ID + "/drafts/");
            String string = Internal.token();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Internal.token()");
            JsonArray jsonArray = request.addToken(string).getJsonObject().get("results").asArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"Request(GET, \"/areas/$ID\u2026ct()[\"results\"].asArray()");
            Sequence $receiver$iv = SequencesKt.map((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)jsonArray)), (Function1)loadDrafts.1.INSTANCE), (Function1)loadDrafts.2.INSTANCE)), (Function1)((Function1)new Function1<String, Draft>(this){
                final /* synthetic */ Area this$0;

                @NotNull
                public final Draft invoke(@NotNull String it) {
                    Draft draft;
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    String string = it;
                    Draft draft2 = draft;
                    Draft draft3 = draft;
                    long l = Long.parseLong(string);
                    draft2(l, this.this$0.getID());
                    return draft3;
                }
                {
                    this.this$0 = area;
                    super(1);
                }
            }));
            for (Object element$iv : $receiver$iv) {
                Draft it = (Draft)element$iv;
                Internal.submitUpdate((Descriptor)it);
                this.cachedDraft(it);
            }
        }
        catch (IssueInTransferException e) {
            e.printStackTrace();
        }
    }

    public final void cachedDraft(@NotNull Draft draft) {
        Intrinsics.checkParameterIsNotNull((Object)draft, (String)"draft");
        Map<Long, Draft> map = this.drafts;
        Long l = draft.ID();
        Draft draft2 = draft;
        map.put(l, draft2);
    }

    public final void removeCached(@NotNull Draft draft) {
        Intrinsics.checkParameterIsNotNull((Object)draft, (String)"draft");
        this.drafts.remove(draft.ID());
    }

    @NotNull
    public final Draft draft() {
        return new Draft(this.ID);
    }

    public final void loadOwnPosts() throws Request.CantConnectException {
        try {
            Request request = new Request(Method.GET, "/areas/" + this.ID + "/own/");
            String string = Internal.token();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Internal.token()");
            JsonArray jsonArray = request.addToken(string).getJsonObject().get("results").asArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"Request(GET, \"/areas/$ID\u2026ct()[\"results\"].asArray()");
            this.ownPostsIDs = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)jsonArray)), (Function1)loadOwnPosts.1.INSTANCE), (Function1)loadOwnPosts.2.INSTANCE)), (Function1)loadOwnPosts.3.INSTANCE));
        }
        catch (IssueInTransferException e) {
            throw (Throwable)new ProgrammingException("This request shouldn't fail.", e);
        }
    }

    @NotNull
    public final List<Post> ownPosts() {
        return SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.ownPostsIDs), (Function1)((Function1)new Function1<Long, Post>(this){
            final /* synthetic */ Area this$0;

            @Nullable
            public final Post invoke(long it) {
                return this.this$0.post(it);
            }
            {
                this.this$0 = area;
                super(1);
            }
        }))));
    }

    public Area(@NotNull String id, @Nullable String displayName) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.ID = id;
        String string = displayName;
        if (string == null) {
            string = id;
        }
        this.name = string;
        this._reputation = -1;
        this._spread = -1;
        this.posts = new LazyMap();
        this.drafts = new LazyMap();
        this.ownPostsIDs = CollectionsKt.emptyList();
    }
}

